package org.j3de.input;

import java.awt.Dimension;  
import java.awt.GraphicsConfiguration;  
import java.awt.GraphicsDevice;                             
import java.awt.GraphicsEnvironment;

import javax.swing.JFrame;
import javax.swing.JWindow;

import javax.media.j3d.AmbientLight;          
import javax.media.j3d.BoundingSphere;          
import javax.media.j3d.BranchGroup;          
import javax.media.j3d.Canvas3D;          
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Locale;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;

import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import com.sun.j3d.utils.geometry.ColorCube;

import org.j3de.util.Configuration;
import org.j3de.behavior.impl.DefaultMovementBehavior;

/** Simple test of the inputdevices. */
public class InputTest {
  private Configuration config;
  private PhysicalEnvironment env;
  
  public InputTest(String configPath) throws Exception {
    config = new Configuration(configPath);
    createWorld();
  }
   
  private void createWorld() throws Exception {
    Canvas3D canvas3d = createCanvas3D(); 

    VirtualUniverse vr = new VirtualUniverse();
    
    View view = createView();  
 
    Locale locale = new Locale(vr); 
    BranchGroup world_object_group = new BranchGroup();      
    // add something to the world ...
    world_object_group.addChild(new ColorCube(2.0)); 
    
    // add light, so we see "something" 
    AmbientLight light = new AmbientLight(new Color3f(1.0f, 1.0f, 1.0f));
    light.setInfluencingBounds(new BoundingSphere(new Point3d(0.0,0.0,0.0), 100)); 
    world_object_group.addChild(light);
    
    // Create view platform and at it to a Transformgroup            
    ViewPlatform viewplatform =  new ViewPlatform();
    
    TransformGroup viewTransformGroup = new TransformGroup();  
    viewTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
    viewTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
    
    // set out starting position
    Transform3D startPosition = new Transform3D();
    startPosition.setTranslation(new Vector3d(5.0, 0.0, 20.0));
    viewTransformGroup.setTransform(startPosition); 
    
    viewTransformGroup.addChild(viewplatform);
    world_object_group.addChild(viewTransformGroup);
    
    // Create movement behavior
    DefaultMovementBehavior movementBehavior =  new DefaultMovementBehavior();
    viewTransformGroup.addChild(movementBehavior);
    
    // set the transformgroup the behavior works on ...
    movementBehavior.setTransformGroup(viewTransformGroup);
    
    // read inputdevice from configuration
    InputDevice inputdevice = (InputDevice)config.getHelper().getComponent("InputDevice");
    
    inputdevice.initialize();
    
    env.addInputDevice(inputdevice);
    // if inputdevice has a behavior : add it to viewTransformGroup
    if (inputdevice instanceof HasBehavior)
      viewTransformGroup.addChild(((HasBehavior)inputdevice).getBehavior());   
    
    // set sensor movementBehavior reacts to
    movementBehavior.setSensor(inputdevice.getSensor(0));
    
    locale.addBranchGraph(world_object_group);     
    view.addCanvas3D(canvas3d);
    view.attachViewPlatform(viewplatform);

    JFrame window = new JFrame();
    window.getContentPane().add(canvas3d);    
    window.pack();
    window.validate();
    window.setSize(new Dimension(400, 400));
    window.show();       
  }
   
  private Canvas3D createCanvas3D() {
    GraphicsConfigTemplate3D tmpl = new GraphicsConfigTemplate3D();
    GraphicsEnvironment env       = GraphicsEnvironment.getLocalGraphicsEnvironment();
    GraphicsDevice device         = env.getDefaultScreenDevice();
    GraphicsConfiguration config  = device.getBestConfiguration(tmpl);
    return new Canvas3D(config);   
  }
  
  private View createView() {
    PhysicalBody body          = new PhysicalBody();
    env = new PhysicalEnvironment();
    View view = new View();
    view.setPhysicalBody(body);
    view.setPhysicalEnvironment(env);
    return view;
  }
  
/** 
  * Starts the test. This method expects a path to a config-file as the first
  * commandline argument.
  */  
  public static void main(String args[]) {
    try {
      new InputTest(args[0]);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}