/*
 * Copyright (c) 2000, Niklas Mehner 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 * 
 *   - Redistributions of source code must retain the above copyright 
 *     notice, this list of conditions and the following disclaimer.
 * 
 *   - Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the 
 *     distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */ 
package org.j3de.util;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;

import org.w3c.dom.Node; 
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import org.j3de.util.ConfigurationException;

public abstract class AbstractComponent implements Configurable {
  protected transient ConfigHelper helper;

  public void configure(Node node, Document nodeFactory) throws ConfigurationException  {
    if (helper == null)
      helper = new ConfigHelper(node, nodeFactory, false);
  }    
  
  public Node configure(Document nodeFactory, String componentName) throws ConfigurationException {  
    Element component = ConfigHelper.newComponent(nodeFactory, componentName, this); 
    helper = new ConfigHelper(component, nodeFactory, true);
    configure(component, nodeFactory);
    return component;
  }
   
  public boolean isConfigurationChanged() {
    return helper.isConfigurationChanged();
  }   
   
  public void configurationSaved() { 
    helper.configurationSaved();
  }       
  
}