/*
 * Copyright (c) 2000, Niklas Mehner 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 * 
 *   - Redistributions of source code must retain the above copyright 
 *     notice, this list of conditions and the following disclaimer.
 * 
 *   - Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the 
 *     distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */ 
package org.j3de.util;
 
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/** This interface has to be implemented by all components, that are configureable
  * by a XML configuration file.
  * @author Niklas Mehner
  * @version $Revision: 1.3 $, $Date: 2000/09/06 21:42:52 $
  * @since  j3de 1.0
  */
public interface Configurable { 
  
  /** Configure the component.
    * @param node contains the root node for the configuration of this component.
    * @param nodeFactory the nodeFactory gives the component the possibility to create new configuration entries.
    * @throws ConfigurationException if the configuration is incorrect
    */ 
  public void configure(Node node, Document nodeFactory) throws ConfigurationException;
  
  /** Configure the component. This method is called, after a new 
    * Component is created, or when the user wants a change in the configuration.
    * The component might have to create a new configuration. If UI is required,
    * only swing components may be used, because Gui3D might not be available
    * yet.
    * @param nodeFactory the nodeFactory gives the component the possibility to create new configuration entries.
    * @param componentName the Name that is assigned to this component
    * @return new configuration
    * @throws ConfigurationException if the configuration is incorrect
    */
  public Node configure(Document nodeFactory, String componentName) throws ConfigurationException;    
  
  /** 
   * Returns wether the configuration has been changed since it was read or last saved.
   * @return true if the configuration has been changed.
   */
  public boolean isConfigurationChanged();   
   
  /**
   * Informs the component, that it's configuration has been saved.
   */
  public void configurationSaved();
}
