/*
 * Copyright (c) 2000, Niklas Mehner 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 * 
 *   - Redistributions of source code must retain the above copyright 
 *     notice, this list of conditions and the following disclaimer.
 * 
 *   - Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the 
 *     distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */ 
package org.j3de.util; 
 
import java.io.File;
import java.io.FileReader;        
import java.io.FileWriter;        
import java.io.InputStreamReader;  
import java.io.IOException;
import java.io.Reader;        
import java.lang.reflect.InvocationTargetException;        
import java.net.URL;
import java.util.List;
import java.util.LinkedList;    
                                             
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
 
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
         
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.sun.xml.tree.XmlDocument;

public class Configuration {
  private XmlDocument  configDocument;
  private Element      rootElement;
  private ConfigHelper configHelper;   
  
  public Configuration(Reader reader) throws IOException, ParserConfigurationException, SAXException {
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder = factory.newDocumentBuilder();
    configDocument = (XmlDocument)builder.parse(new InputSource(reader));    
    rootElement    = configDocument.getDocumentElement();   
    configHelper   = new ConfigHelper(rootElement, configDocument, false);
   }
  
  public Configuration(String filename) throws IOException, ParserConfigurationException, SAXException {   
    this(new FileReader(new File(filename)));          
  }                  

  public Configuration(URL url) throws IOException, ParserConfigurationException, SAXException {   
    this(new InputStreamReader(url.openStream()));          
  }                  
          
  public Configuration() throws ParserConfigurationException {
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance(); 
    DocumentBuilder builder = factory.newDocumentBuilder();
    
    configDocument = (XmlDocument)builder.newDocument();     
    rootElement = (Element) configDocument.createElement("configuration");  
    rootElement.setAttribute("name", "j3de");
    configHelper   = new ConfigHelper(rootElement, configDocument, true);
    configDocument.appendChild (rootElement);  
   }
  
  public void saveConfiguration(String filename) throws IOException {
    configDocument.write (new FileWriter(new File(filename)));
    configHelper.configurationSaved();
  }                                            
  
  public Object getComponent(String  componentName, 
                             Class   defaultImplementation,
                             Class[] parameterTypes,
                             Object[]parameters) throws ConfigurationException {
    return configHelper.getComponent(componentName,
                                     defaultImplementation,
                                     parameterTypes,
                                     parameters);
  }
  
  public Object getComponent(String  componentName, 
                             Class   defaultImplementation) throws ConfigurationException {
    return getComponent(componentName, defaultImplementation, null, null);
  }     
  
  public Object getComponent(String      componentName, 
                             ClassLoader loader) throws ConfigurationException {
    return configHelper.getComponent(componentName, null, null, null, loader);
  }     
  
  public String getProperty(String name) {
    return configHelper.getPropertyValue(name);
  }

  public String getProperty(String name, String defaultValue, boolean warn) {
    return configHelper.getPropertyValue(name, defaultValue, warn);
  }
  
  public boolean isConfigurationChanged() { 
    return configHelper.isConfigurationChanged();
  }

  public ConfigHelper getHelper() {
    return configHelper;
  }  
}
