/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.dxf;

import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Material;
import javax.vecmath.Color3f;
import ncsa.j3d.loaders.dxf.ColorTable;

class ColorObj {
    ColorObj() {
    }

    public static Color3f ColorList(int n) {
        switch (n) {
            case -1: {
                return new Color3f(0.7f, 0.7f, 0.7f);
            }
        }
        return ColorTable.lookup(n);
    }

    public static Appearance getColor(int n, float f, boolean bl) {
        if (!bl) {
            Appearance appearance = new Appearance();
            appearance.setColoringAttributes(new ColoringAttributes(ColorObj.ColorList(n), 1));
            return appearance;
        }
        return ColorObj.makeAppearance(ColorObj.ColorList(n), f);
    }

    public static Appearance getColor(Appearance appearance, boolean bl) {
        Color3f color3f = new Color3f();
        appearance.getColoringAttributes().getColor(color3f);
        if (!bl) {
            Appearance appearance2 = new Appearance();
            appearance2.setColoringAttributes(new ColoringAttributes(color3f, 1));
            return appearance2;
        }
        Color3f color3f2 = new Color3f();
        appearance.getMaterial().getAmbientColor(color3f2);
        float f = color3f2.x / color3f.x;
        return ColorObj.makeAppearance(color3f, f);
    }

    public static boolean is3D(Appearance appearance) {
        return appearance.getMaterial() != null;
    }

    private static Appearance makeAppearance(Color3f color3f, float f) {
        Appearance appearance = new Appearance();
        float f2 = color3f.x;
        float f3 = color3f.y;
        float f4 = color3f.z;
        Material material = new Material();
        material.setEmissiveColor(0.0f, 0.0f, 0.0f);
        material.setAmbientColor(f2 * f * f, f3 * f * f, f4 * f * f);
        material.setDiffuseColor(f2 * f, f3 * f, f4 * f);
        material.setSpecularColor(f2, f3, f4);
        material.setCapability(0);
        appearance.setCapability(0);
        appearance.setMaterial(material);
        return appearance;
    }
}

