/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.dxf;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.io.FileReader;
import java.io.Reader;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import ncsa.j3d.loaders.dxf.ColorObj;
import ncsa.j3d.loaders.dxf.LayerList;
import ncsa.j3d.loaders.dxf.NodeList;
import ncsa.j3d.loaders.dxf.PointList;
import ncsa.util.ReaderTokenizer;

public class DXFLoader {
    private ReaderTokenizer fis;
    private BranchGroup bg;
    private NodeList nl;
    private LayerList al;
    private boolean progress = false;
    private boolean watchFile = false;
    private boolean EOF = false;
    private boolean forceReadNextTokenAsInt = false;
    private final int divisions = 50;
    private final boolean t3d = false;
    private boolean angdir = true;
    private int dimaunit = 0;
    private float shadedif = 0.7f;

    private void CleanDXFLayers() {
        if (this.progress) {
            System.out.print(":");
        }
        String string = this.al.Start();
        while (string != null) {
            int n = this.al.getSize() + 1;
            if (this.progress) {
                System.out.print("[" + string + "," + n);
            }
            if (this.al.getType() == 0) {
                Shape3D shape3D = this.al.getShape();
                TriangleFanArray triangleFanArray = (TriangleFanArray)shape3D.getGeometry();
                int n2 = this.al.getColor();
                if (n > 1) {
                    Vector3f vector3f;
                    int[] nArray = new int[n];
                    int n3 = 0;
                    while (n3 < n) {
                        nArray[n3] = 4;
                        ++n3;
                    }
                    TriangleFanArray triangleFanArray2 = new TriangleFanArray(n * 4, 3, nArray);
                    Point3f[] point3fArray = new Point3f[n * 4];
                    PointList pointList = new PointList();
                    int n4 = 0;
                    while (n4 < n * 4) {
                        point3fArray[n4] = new Point3f();
                        Point3f point3f = new Point3f();
                        vector3f = new Vector3f();
                        triangleFanArray.getCoordinate(n4, point3fArray[n4]);
                        triangleFanArray.getNormal(n4, vector3f);
                        pointList.addPoint(point3fArray[n4], vector3f);
                        if (n4 % 400 == 0 && this.progress) {
                            System.out.print(".");
                        }
                        ++n4;
                    }
                    if (this.progress) {
                        System.out.print("^");
                    }
                    pointList.Done();
                    int n5 = 0;
                    while (n5 < n * 4) {
                        vector3f = new Point3f();
                        Vector3f vector3f2 = new Vector3f();
                        vector3f = pointList.getPoint(point3fArray[n5]);
                        vector3f2 = pointList.getNormal((Point3f)vector3f);
                        triangleFanArray2.setCoordinate(n5, (Point3f)vector3f);
                        triangleFanArray2.setNormal(n5, vector3f2);
                        if (n5 % 400 == 0 && this.progress) {
                            System.out.print(".");
                        }
                        ++n5;
                    }
                    this.bg.addChild((Node)new Shape3D((Geometry)triangleFanArray2, this.itemAppearance(null, n2, true)));
                }
            } else {
                this.bg.addChild((Node)this.al.getShape());
            }
            if (this.progress) {
                System.out.print("]");
            }
            string = this.al.Next();
        }
        if (this.progress) {
            System.out.print(":");
        }
    }

    private void FileError(String string) {
        System.err.println("Error with the .DXF file.  Does not conform to given DXF specs.");
        if (string != null) {
            System.err.println(string);
        }
        System.exit(1);
    }

    private void GoToNextData() {
        int n = this.readInt(this.fis);
        String string = this.getLine(this.fis);
        while (!(n == 0 && string != null && string.compareTo("ENDSEC") == 0 || this.EOF)) {
            n = this.readInt(this.fis);
            string = this.getLine(this.fis);
        }
    }

    public BranchGroup LoadDXF(Reader reader) {
        this.bg = new BranchGroup();
        this.bg.setCapability(3);
        this.fis = new ReaderTokenizer(reader);
        this.fis.ordinaryChar(35);
        this.fis.wordChars(34, 34);
        this.LoadDXFWaiting();
        return this.bg;
    }

    public BranchGroup LoadDXF(Reader reader, boolean bl) {
        this.progress = bl;
        this.bg = new BranchGroup();
        this.bg.setCapability(3);
        this.fis = new ReaderTokenizer(reader);
        this.fis.ordinaryChar(35);
        this.fis.wordChars(34, 34);
        this.LoadDXFWaiting();
        this.bg.compile();
        return this.bg;
    }

    private String LoadDXF3DFace(BranchGroup branchGroup) {
        int n;
        Vector3f vector3f;
        Vector3f vector3f2;
        Object object;
        TriangleFanArray triangleFanArray;
        Object object2;
        int n2;
        float[] fArray = new float[12];
        boolean bl = false;
        String string = null;
        int n3 = -1;
        int n4 = this.readInt(this.fis);
        String string2 = null;
        while (n4 != 0) {
            switch (n4) {
                case 8: {
                    string = this.getLine(this.fis);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    fArray[n4 / 10 + n4 % 10 * 3 - 1] = this.readFloat(this.fis);
                    if (n4 % 10 != 3) break;
                    bl = true;
                    break;
                }
                case 62: {
                    n3 = this.readInt(this.fis);
                    break;
                }
                default: {
                    string2 = this.getLine(this.fis);
                }
            }
            n4 = this.readInt(this.fis);
        }
        string2 = this.getLine(this.fis);
        if (!bl) {
            fArray[9] = fArray[6];
            fArray[10] = fArray[7];
            fArray[11] = fArray[8];
        } else if (fArray[9] == fArray[6] && fArray[10] == fArray[7] && fArray[11] == fArray[8]) {
            bl = false;
        }
        Shape3D shape3D = null;
        boolean bl2 = false;
        if (this.al.Find(string) != null) {
            shape3D = this.al.getChild(string);
            this.al.addSize(string, 1);
            n2 = this.al.getSize(string);
        } else {
            object2 = new int[]{4};
            triangleFanArray = new TriangleFanArray(4, 31, object2);
            shape3D = new Shape3D((Geometry)triangleFanArray, this.itemAppearance(null, n3, true));
            n2 = 0;
        }
        object2 = (GeometryArray)shape3D.getGeometry();
        triangleFanArray = (TriangleFanArray)object2;
        if (object2.getVertexCount() / 4 <= n2) {
            object = new int[n2 * 2];
            vector3f2 = new Point3f[n2 * 8];
            vector3f = new Vector3f[n2 * 8];
            int n5 = 0;
            while (n5 < n2) {
                object[n5] = 4;
                object[n2 + n5] = 4;
                ++n5;
            }
            int n6 = 0;
            while (n6 < n2) {
                n = 0;
                while (n < 4) {
                    vector3f2[4 * n6 + n] = new Point3f();
                    vector3f2[4 * (n6 + n2) + n] = new Point3f();
                    object2.getCoordinate(4 * n6 + n, (Point3f)vector3f2[4 * n6 + n]);
                    vector3f[4 * n6 + n] = new Vector3f();
                    vector3f[4 * (n6 + n2) + n] = new Vector3f();
                    object2.getNormal(4 * n6 + n, vector3f[4 * n6 + n]);
                    ++n;
                }
                ++n6;
            }
            triangleFanArray = new TriangleFanArray(n2 * 2 * 4, 31, object);
            triangleFanArray.setCoordinates(0, (Point3f[])vector3f2);
            triangleFanArray.setNormals(0, (Vector3f[])vector3f);
        }
        object = new Vector3f(fArray[3] - fArray[0], fArray[4] - fArray[1], fArray[5] - fArray[2]);
        vector3f2 = new Vector3f(fArray[6] - fArray[3], fArray[7] - fArray[4], fArray[8] - fArray[5]);
        vector3f = new Vector3f(fArray[9] - fArray[6], fArray[10] - fArray[7], fArray[11] - fArray[8]);
        Vector3f vector3f3 = new Vector3f(fArray[0] - fArray[9], fArray[1] - fArray[10], fArray[2] - fArray[11]);
        Vector3f vector3f4 = new Vector3f(fArray[6] - fArray[0], fArray[7] - fArray[1], fArray[8] - fArray[2]);
        if (bl) {
            triangleFanArray.setNormal(n2 * 4, this.vNormalize(this.vAdd(this.vCross(this.vNeg((Vector3f)object), this.vNeg(vector3f4)), this.vCross(this.vNeg(vector3f4), vector3f3))));
            triangleFanArray.setNormal(n2 * 4 + 2, this.vNormalize(this.vAdd(this.vCross(vector3f2, this.vNeg(vector3f4)), this.vCross(this.vNeg(vector3f4), this.vNeg(vector3f)))));
            triangleFanArray.setNormal(n2 * 4 + 3, this.vNormalize(this.vCross(this.vNeg(vector3f3), vector3f)));
        } else {
            triangleFanArray.setNormal(n2 * 4, this.vNormalize(this.vCross(this.vNeg((Vector3f)object), this.vNeg(vector3f4))));
            triangleFanArray.setNormal(n2 * 4 + 2, this.vNeg(this.vNormalize(this.vCross(vector3f2, vector3f4))));
            triangleFanArray.setNormal(n2 * 4 + 3, new Vector3f(0.0f, 0.0f, 0.0f));
        }
        triangleFanArray.setNormal(n2 * 4 + 1, this.vNeg(this.vNormalize(this.vCross((Vector3f)object, this.vNeg(vector3f2)))));
        n = 0;
        while (n < 4) {
            Point3f point3f = new Point3f(fArray[3 * n], fArray[3 * n + 1], fArray[3 * n + 2]);
            triangleFanArray.setCoordinate(n2 * 4 + n, point3f);
            ++n;
        }
        shape3D.setGeometry((Geometry)triangleFanArray);
        if (this.al.Find(string) == null) {
            branchGroup.addChild((Node)shape3D);
        }
        return string2;
    }

    private String LoadDXFArc(BranchGroup branchGroup) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float f = 1.0f;
        float[] fArray3 = new float[2];
        fArray2[0] = 0.0f;
        fArray2[1] = 0.0f;
        fArray2[2] = 1.0f;
        int n = -1;
        String string = null;
        int n2 = this.readInt(this.fis);
        String string2 = null;
        while (n2 != 0) {
            switch (n2) {
                case 8: {
                    string = this.getLine(this.fis);
                    break;
                }
                case 10: 
                case 20: 
                case 30: {
                    fArray[n2 / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                case 40: {
                    f = this.readFloat(this.fis);
                    break;
                }
                case 50: {
                    fArray3[0] = this.convAngle(this.readFloat(this.fis));
                    break;
                }
                case 51: {
                    fArray3[1] = this.convAngle(this.readFloat(this.fis));
                    break;
                }
                case 62: {
                    n = this.readInt(this.fis);
                    break;
                }
                case 210: 
                case 220: 
                case 230: {
                    fArray2[(n2 - 200) / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                default: {
                    string2 = this.getLine(this.fis);
                }
            }
            n2 = this.readInt(this.fis);
        }
        string2 = this.getLine(this.fis);
        if (fArray3[0] > fArray3[1]) {
            fArray3[0] = fArray3[0] - (float)Math.PI * 2;
        }
        float f2 = fArray3[0];
        fArray3[0] = this.angdir ? fArray3[0] : fArray3[1];
        fArray3[1] = this.angdir ? fArray3[1] : f2;
        float f3 = fArray3[1] - fArray3[0];
        int[] nArray = new int[]{51};
        LineStripArray lineStripArray = new LineStripArray(51, 1, nArray);
        float[] fArray4 = new float[]{(float)(Math.cos(fArray3[0]) * (double)f), (float)(Math.sin(fArray3[0]) * (double)f), 0.0f};
        Point3f point3f = new Point3f(fArray[0] + fArray2[0] * fArray4[2] + (fArray2[1] + fArray2[2]) * fArray4[0], fArray[1] + (fArray2[0] + fArray2[2]) * fArray4[1] + fArray2[1] * fArray4[2], fArray[2] + fArray2[0] * -fArray4[0] + fArray2[1] * -fArray4[1] + fArray2[2] * fArray4[2]);
        lineStripArray.setCoordinate(0, point3f);
        int n3 = 1;
        while (n3 <= 50) {
            float f4 = fArray3[0] + (float)n3 * f3 / 50.0f;
            fArray4[0] = (float)(Math.cos(f4) * (double)f);
            fArray4[1] = (float)(Math.sin(f4) * (double)f);
            fArray4[2] = 0.0f;
            point3f = new Point3f(fArray[0] + fArray2[0] * fArray4[2] + (fArray2[1] + fArray2[2]) * fArray4[0], fArray[1] + (fArray2[0] + fArray2[2]) * fArray4[1] + fArray2[1] * fArray4[2], fArray[2] + fArray2[0] * -fArray4[0] + fArray2[1] * -fArray4[1] + fArray2[2] * fArray4[2]);
            lineStripArray.setCoordinate(n3, point3f);
            ++n3;
        }
        Appearance appearance = this.itemAppearance(string, n, false);
        branchGroup.addChild((Node)new Shape3D((Geometry)lineStripArray, appearance));
        return string2;
    }

    private void LoadDXFBlock(NodeList nodeList) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(3);
        SharedGroup sharedGroup = new SharedGroup();
        float[] fArray = new float[3];
        String string = null;
        int n = this.readInt(this.fis);
        String string2 = null;
        while (n != 0) {
            switch (n) {
                case 2: {
                    string = this.getLine(this.fis);
                    break;
                }
                case 10: 
                case 20: 
                case 30: {
                    fArray[n / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                default: {
                    string2 = this.getLine(this.fis);
                }
            }
            n = this.readInt(this.fis);
        }
        string2 = this.getLine(this.fis);
        if (this.progress) {
            System.out.print("<");
        }
        this.LoadDXFData(branchGroup, "ENDBLK", string2);
        if (this.progress) {
            System.out.print(">");
        }
        sharedGroup.addChild((Node)branchGroup);
        nodeList.addChild(sharedGroup, string);
    }

    private void LoadDXFBlocks() {
        this.nl = new NodeList();
        int n = this.readInt(this.fis);
        String string = this.readString(this.fis);
        while (string == null || string.compareTo("ENDSEC") != 0) {
            if (string.compareTo("BLOCK") == 0) {
                this.LoadDXFBlock(this.nl);
            }
            string = this.UseNextData();
        }
    }

    private String LoadDXFCircle(BranchGroup branchGroup) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float f = 1.0f;
        fArray2[0] = 0.0f;
        fArray2[1] = 0.0f;
        fArray2[2] = 1.0f;
        int n = -1;
        String string = null;
        int n2 = this.readInt(this.fis);
        String string2 = null;
        while (n2 != 0) {
            switch (n2) {
                case 8: {
                    string = this.getLine(this.fis);
                    break;
                }
                case 10: 
                case 20: 
                case 30: {
                    fArray[n2 / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                case 40: {
                    f = this.readFloat(this.fis);
                    break;
                }
                case 62: {
                    n = this.readInt(this.fis);
                    break;
                }
                case 210: 
                case 220: 
                case 230: {
                    fArray2[(n2 - 200) / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                default: {
                    string2 = this.getLine(this.fis);
                }
            }
            n2 = this.readInt(this.fis);
        }
        string2 = this.getLine(this.fis);
        int[] nArray = new int[]{51};
        LineStripArray lineStripArray = new LineStripArray(51, 1, nArray);
        float f2 = 0.0f;
        float[] fArray3 = new float[]{(float)(Math.cos(0.0) * (double)f), (float)(Math.sin(0.0) * (double)f), 0.0f};
        Point3f point3f = new Point3f(fArray[0] + fArray2[0] * fArray3[2] + (fArray2[1] + fArray2[2]) * fArray3[0], fArray[1] + (fArray2[0] + fArray2[2]) * fArray3[1] + fArray2[1] * fArray3[2], fArray[2] + fArray2[0] * -fArray3[0] + fArray2[1] * -fArray3[1] + fArray2[2] * fArray3[2]);
        lineStripArray.setCoordinate(0, point3f);
        int n3 = 1;
        while (n3 <= 50) {
            f2 = (float)((double)n3 * (Math.PI * 2) / 50.0);
            fArray3[0] = (float)(Math.cos(f2) * (double)f);
            fArray3[1] = (float)(Math.sin(f2) * (double)f);
            fArray3[2] = 0.0f;
            point3f = new Point3f(fArray[0] + fArray2[0] * fArray3[2] + (fArray2[1] + fArray2[2]) * fArray3[0], fArray[1] + (fArray2[0] + fArray2[2]) * fArray3[1] + fArray2[1] * fArray3[2], fArray[2] + fArray2[0] * -fArray3[0] + fArray2[1] * -fArray3[1] + fArray2[2] * fArray3[2]);
            lineStripArray.setCoordinate(n3, point3f);
            ++n3;
        }
        Appearance appearance = this.itemAppearance(string, n, false);
        branchGroup.addChild((Node)new Shape3D((Geometry)lineStripArray, appearance));
        return string2;
    }

    private void LoadDXFData(BranchGroup branchGroup, String string, String string2) {
        String string3;
        int n;
        if (string2 == null) {
            n = this.readInt(this.fis);
            string3 = this.getLine(this.fis);
        } else {
            n = 0;
            string3 = new String(string2);
        }
        while (n != 0 || string3.compareTo(string) != 0) {
            if (this.progress) {
                System.out.print(".");
            }
            switch (string3.charAt(0)) {
                case '3': {
                    if (string3.compareTo("3DFACE") == 0) {
                        string3 = this.LoadDXF3DFace(branchGroup);
                        break;
                    }
                    string3 = this.UseNextData();
                    break;
                }
                case 'A': {
                    if (string3.compareTo("ARC") == 0) {
                        string3 = this.LoadDXFArc(branchGroup);
                        break;
                    }
                    string3 = this.UseNextData();
                    break;
                }
                case 'C': {
                    if (string3.compareTo("CIRCLE") == 0) {
                        string3 = this.LoadDXFCircle(branchGroup);
                        break;
                    }
                    string3 = this.UseNextData();
                    break;
                }
                case 'E': {
                    if (string3.compareTo("ELLIPSE") == 0) {
                        string3 = this.LoadDXFEllipse(branchGroup);
                        break;
                    }
                    string3 = this.UseNextData();
                    break;
                }
                case 'I': {
                    if (string3.compareTo("INSERT") == 0) {
                        string3 = this.LoadDXFInsert(branchGroup);
                        break;
                    }
                    string3 = this.UseNextData();
                    break;
                }
                case 'L': {
                    if (string3.compareTo("LINE") == 0) {
                        string3 = this.LoadDXFLine(branchGroup);
                        break;
                    }
                    string3 = this.UseNextData();
                    break;
                }
                case 'P': {
                    if (string3.compareTo("POINT") == 0) {
                        string3 = this.LoadDXFPoint(branchGroup);
                        break;
                    }
                    if (string3.compareTo("POLYLINE") == 0) {
                        string3 = this.LoadDXFPolyline(branchGroup);
                        break;
                    }
                    string3 = this.UseNextData();
                    break;
                }
                case 'S': {
                    if (string3.compareTo("SHAPE") == 0) {
                        string3 = this.LoadDXFInsert(branchGroup);
                        break;
                    }
                    if (string3.compareTo("SOLID") == 0) {
                        string3 = this.LoadDXFSolid(branchGroup);
                        break;
                    }
                    string3 = this.UseNextData();
                    break;
                }
                case 'T': {
                    if (string3.compareTo("TEXT") == 0) {
                        string3 = this.LoadDXFText(branchGroup);
                        break;
                    }
                    string3 = this.UseNextData();
                    break;
                }
                default: {
                    string3 = this.UseNextData();
                }
            }
            n = 0;
        }
    }

    private String LoadDXFEllipse(BranchGroup branchGroup) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float f = 1.0f;
        float[] fArray3 = new float[2];
        float[] fArray4 = new float[3];
        fArray3[0] = 0.0f;
        fArray3[1] = (float)Math.PI * 2;
        fArray4[0] = 0.0f;
        fArray4[1] = 0.0f;
        fArray4[2] = 1.0f;
        int n = -1;
        String string = null;
        int n2 = this.readInt(this.fis);
        String string2 = null;
        while (n2 != 0) {
            switch (n2) {
                case 8: {
                    string = this.getLine(this.fis);
                    break;
                }
                case 10: 
                case 20: 
                case 30: {
                    fArray[n2 / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                case 11: 
                case 21: 
                case 31: {
                    fArray2[n2 / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                case 40: {
                    f = this.readFloat(this.fis);
                    break;
                }
                case 41: {
                    fArray3[0] = this.convAngle(this.readFloat(this.fis));
                    break;
                }
                case 42: {
                    fArray3[1] = this.convAngle(this.readFloat(this.fis));
                    break;
                }
                case 62: {
                    n = this.readInt(this.fis);
                    break;
                }
                case 210: 
                case 220: 
                case 230: {
                    fArray4[(n2 - 200) / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                default: {
                    string2 = this.getLine(this.fis);
                }
            }
            n2 = this.readInt(this.fis);
        }
        string2 = this.getLine(this.fis);
        float f2 = (float)Math.pow(Math.pow(fArray2[0], 2.0) + Math.pow(fArray2[1], 2.0) + Math.pow(fArray2[2], 2.0), 0.5);
        int[] nArray = new int[]{51};
        LineStripArray lineStripArray = new LineStripArray(51, 1, nArray);
        float[] fArray5 = new float[]{f2, 0.0f, 0.0f};
        float[] fArray6 = new float[]{(fArray5[0] * fArray2[0] + fArray5[1] * -fArray2[1] + fArray5[2] * -fArray2[2]) / f2, ((fArray5[0] + fArray5[2]) * fArray2[1] + fArray5[1] * fArray2[0]) / f2, ((fArray5[0] + fArray5[1]) * fArray2[2] + fArray5[2] * fArray2[0]) / f2};
        Point3f point3f = new Point3f(fArray[0] + fArray4[0] * fArray6[2] + (fArray4[1] + fArray4[2]) * fArray6[0], fArray[1] + (fArray4[0] + fArray4[2]) * fArray6[1] + fArray4[1] * fArray6[2], fArray[2] + fArray4[0] * -fArray6[0] + fArray4[1] * -fArray6[1] + fArray4[2] * fArray6[2]);
        lineStripArray.setCoordinate(0, point3f);
        float f3 = fArray3[1] - fArray3[0];
        int n3 = 1;
        while (n3 <= 50) {
            float f4 = fArray3[0] + (float)n3 * f3 / 50.0f;
            fArray5[0] = (float)(Math.cos(f4) * (double)f2);
            fArray5[1] = (float)(Math.sin(f4) * (double)f * (double)f2);
            fArray5[2] = 0.0f;
            fArray6[0] = (fArray5[0] * fArray2[0] + fArray5[1] * -fArray2[1] + fArray5[2] * -fArray2[2]) / f2;
            fArray6[1] = ((fArray5[0] + fArray5[2]) * fArray2[1] + fArray5[1] * fArray2[0]) / f2;
            fArray6[2] = ((fArray5[0] + fArray5[1]) * fArray2[2] + fArray5[2] * fArray2[0]) / f2;
            point3f = new Point3f(fArray[0] + fArray4[0] * fArray6[2] + (fArray4[1] + fArray4[2]) * fArray6[0], fArray[1] + (fArray4[0] + fArray4[2]) * fArray6[1] + fArray4[1] * fArray6[2], fArray[2] + fArray4[0] * -fArray6[0] + fArray4[1] * -fArray6[1] + fArray4[2] * fArray6[2]);
            lineStripArray.setCoordinate(n3, point3f);
            ++n3;
        }
        Appearance appearance = this.itemAppearance(string, n, false);
        branchGroup.addChild((Node)new Shape3D((Geometry)lineStripArray, appearance));
        return string2;
    }

    private void LoadDXFEntities() {
        this.LoadDXFData(this.bg, "ENDSEC", null);
    }

    private void LoadDXFHeader() {
        int n = this.readInt(this.fis);
        String string = this.readString(this.fis);
        while (n != 0 || string.compareTo("ENDSEC") != 0) {
            if (string.length() >= 2) {
                switch (string.charAt(1)) {
                    case 'A': {
                        if (string.compareTo("$ANGDIR") != 0) break;
                        this.nextLine(this.fis);
                        this.angdir = this.readInt(this.fis) != 0;
                        break;
                    }
                    case 'D': {
                        if (string.compareTo("$DIMAUNIT") != 0) break;
                        this.nextLine(this.fis);
                        this.dimaunit = this.readInt(this.fis);
                        break;
                    }
                    case 'S': {
                        if (string.compareTo("$SHADEDIF") != 0) break;
                        this.nextLine(this.fis);
                        this.shadedif = this.readFloat(this.fis);
                        break;
                    }
                }
            }
            n = this.readInt(this.fis);
            string = this.readString(this.fis);
        }
    }

    private String LoadDXFInsert(BranchGroup branchGroup) {
        String string = null;
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        double[] dArray = new double[]{1.0, 1.0, 1.0};
        float f = 0.0f;
        float[] fArray2 = new float[]{0.0f, 0.0f, 1.0f};
        int n = this.readInt(this.fis);
        String string2 = null;
        while (n != 0) {
            switch (n) {
                case 2: {
                    string = this.getLine(this.fis);
                    break;
                }
                case 10: 
                case 20: 
                case 30: {
                    fArray[n / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                case 41: 
                case 42: 
                case 43: {
                    dArray[n - 41] = this.readFloat(this.fis);
                    break;
                }
                case 50: {
                    f = this.convAngle(this.readFloat(this.fis));
                    break;
                }
                case 210: 
                case 220: 
                case 230: {
                    fArray2[(n - 200) / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                default: {
                    string2 = this.getLine(this.fis);
                }
            }
            n = this.readInt(this.fis);
        }
        string2 = this.getLine(this.fis);
        Link link = this.nl.getChild(string);
        TransformGroup transformGroup = new TransformGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(new Vector3d(dArray));
        transform3D.setTranslation(new Vector3f(fArray));
        transform3D.setRotation(new Matrix3f(fArray2[2], fArray2[0], fArray2[0], fArray2[1], fArray2[2], fArray2[1], -fArray2[0], -fArray2[1], fArray2[2]));
        transformGroup.addChild((Node)link);
        transformGroup.setTransform(transform3D);
        branchGroup.addChild((Node)transformGroup);
        return string2;
    }

    private void LoadDXFLayerTable(LayerList layerList) {
        String string = null;
        int n = -1;
        String string2 = null;
        block6: while (string == null || string.compareTo("ENDTAB") != 0) {
            int n2 = this.readInt(this.fis);
            switch (n2) {
                case 0: {
                    string = this.getLine(this.fis);
                    if (string.compareTo("ENDTAB") == 0 || !this.progress) continue block6;
                    System.out.print("[");
                    break;
                }
                case 2: {
                    string2 = this.getLine(this.fis);
                    if (!this.progress) continue block6;
                    System.out.print("n" + string2);
                    break;
                }
                case 6: {
                    string = this.getLine(this.fis);
                    int[] nArray = new int[]{4};
                    TriangleFanArray triangleFanArray = new TriangleFanArray(4, 31, nArray);
                    Shape3D shape3D = new Shape3D((Geometry)triangleFanArray, this.itemAppearance(null, n, true));
                    shape3D.setCapability(13);
                    layerList.addChild(shape3D, string2, n, 0, 0);
                    if (!this.progress) continue block6;
                    System.out.print("]");
                    break;
                }
                case 62: {
                    n = this.readInt(this.fis);
                    if (!this.progress) continue block6;
                    System.out.print("a");
                    break;
                }
                default: {
                    string = this.getLine(this.fis);
                    break;
                }
            }
        }
    }

    private String LoadDXFLine(BranchGroup branchGroup) {
        float[] fArray = new float[6];
        int n = -1;
        String string = null;
        int n2 = this.readInt(this.fis);
        String string2 = null;
        while (n2 != 0) {
            switch (n2) {
                case 8: {
                    string = this.getLine(this.fis);
                    break;
                }
                case 10: 
                case 11: 
                case 20: 
                case 21: 
                case 30: 
                case 31: {
                    fArray[n2 / 10 + 3 * (n2 % 10) - 1] = this.readFloat(this.fis);
                    break;
                }
                case 39: {
                    float f = this.readFloat(this.fis);
                    break;
                }
                case 62: {
                    n = this.readInt(this.fis);
                    break;
                }
                default: {
                    string2 = this.getLine(this.fis);
                }
            }
            n2 = this.readInt(this.fis);
        }
        string2 = this.getLine(this.fis);
        Appearance appearance = this.itemAppearance(string, n, false);
        if (string == null || this.al.getType(string) == 0 && this.al.getSize(string) > 0 || this.al.getChild(string) == null) {
            LineArray lineArray = new LineArray(2, 1);
            lineArray.setCoordinate(0, new Point3f(fArray[0], fArray[1], fArray[2]));
            lineArray.setCoordinate(1, new Point3f(fArray[3], fArray[4], fArray[5]));
            branchGroup.addChild((Node)new Shape3D((Geometry)lineArray, appearance));
        } else {
            LineArray lineArray = null;
            Shape3D shape3D = null;
            shape3D = this.al.getChild(string);
            int n3 = 0;
            if (this.al.getSize(string) == 0) {
                lineArray = new LineArray(2, 9);
                this.al.Find(string);
                this.al.replaceChild(new Shape3D((Geometry)lineArray, this.itemAppearance(null, this.al.getColor(), false)), string, this.al.getColor(), 0, 1);
            } else {
                shape3D = this.al.getChild(string);
                lineArray = (LineArray)shape3D.getGeometry();
                n3 = this.al.getSize(string);
            }
            if (lineArray.getVertexCount() / 2 <= n3) {
                int n4 = lineArray.getVertexCount() / 2;
                int[] nArray = new int[n4 * 2];
                Point3f[] point3fArray = new Point3f[n4 * 4];
                int n5 = 0;
                while (n5 < 2 * n3) {
                    point3fArray[n5] = new Point3f();
                    lineArray.getCoordinate(n5, point3fArray[n5]);
                    ++n5;
                }
                lineArray = new LineArray(n3 * 2 * 2, 9);
                int n6 = 0;
                while (n6 < n3 * 2) {
                    lineArray.setCoordinate(n6, point3fArray[n6]);
                    ++n6;
                }
                shape3D.setGeometry((Geometry)lineArray);
            }
            lineArray.setCoordinate(2 * n3, new Point3f(fArray[0], fArray[1], fArray[2]));
            lineArray.setCoordinate(2 * n3 + 1, new Point3f(fArray[3], fArray[4], fArray[5]));
            this.al.addSize(string, 1);
        }
        return string2;
    }

    private String LoadDXFPoint(BranchGroup branchGroup) {
        float[] fArray = new float[3];
        int n = -1;
        String string = null;
        int n2 = this.readInt(this.fis);
        String string2 = null;
        while (n2 != 0) {
            switch (n2) {
                case 8: {
                    string = this.getLine(this.fis);
                    break;
                }
                case 10: 
                case 20: 
                case 30: {
                    fArray[n2 / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                case 62: {
                    n = this.readInt(this.fis);
                    break;
                }
                default: {
                    string2 = this.getLine(this.fis);
                }
            }
            n2 = this.readInt(this.fis);
        }
        string2 = this.getLine(this.fis);
        Appearance appearance = this.itemAppearance(string, n, false);
        PointArray pointArray = new PointArray(1, 1);
        pointArray.setCoordinate(0, new Point3f(fArray));
        branchGroup.addChild((Node)new Shape3D((Geometry)pointArray, appearance));
        return string2;
    }

    private String LoadDXFPolyline(BranchGroup branchGroup) {
        int n;
        int n2;
        Object object;
        Object object2;
        if (this.progress) {
            System.out.print("/");
        }
        int n3 = 0;
        float[] fArray = new float[3];
        int n4 = 0;
        int n5 = 0;
        String string = null;
        int n6 = 0;
        Vector<Point3f> vector = new Vector<Point3f>();
        Vector<Integer> vector2 = new Vector<Integer>();
        int n7 = this.readInt(this.fis);
        String string2 = null;
        while (n7 != 0) {
            switch (n7) {
                case 8: {
                    string = this.getLine(this.fis);
                    break;
                }
                case 10: 
                case 20: 
                case 30: {
                    fArray[n7 / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                case 62: {
                    n6 = this.readInt(this.fis);
                    break;
                }
                case 70: {
                    n3 = this.readInt(this.fis);
                    break;
                }
                case 71: {
                    n4 = this.readInt(this.fis);
                    break;
                }
                case 72: {
                    n5 = this.readInt(this.fis);
                    break;
                }
                default: {
                    string2 = this.getLine(this.fis);
                }
            }
            n7 = this.readInt(this.fis);
        }
        string2 = this.getLine(this.fis);
        while (n7 != 0 || string2 == null || string2.compareTo("SEQEND") != 0) {
            if (this.progress) {
                System.out.print("^");
            }
            n7 = this.readInt(this.fis);
            object2 = new float[3];
            object = new int[4];
            n2 = 0;
            while (n2 < 4) {
                object[n2] = -1;
                ++n2;
            }
            int n8 = 0;
            while (n7 != 0) {
                switch (n7) {
                    case 10: 
                    case 20: 
                    case 30: {
                        object2[n7 / 10 - 1] = this.readFloat(this.fis);
                        break;
                    }
                    case 70: {
                        n8 = this.readInt(this.fis);
                        break;
                    }
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: {
                        object[n7 - 71] = this.readInt(this.fis);
                        if (object[n7 - 71] >= 0) break;
                        int n9 = n7 - 71;
                        object[n9] = object[n9] * -1;
                        break;
                    }
                    default: {
                        string2 = this.getLine(this.fis);
                    }
                }
                n7 = this.readInt(this.fis);
            }
            string2 = this.getLine(this.fis);
            if ((n3 & 0x40) > 0 && (n8 & 0xC0) == 128) {
                if (object[3] <= 0) {
                    object[3] = object[2];
                }
                n = 0;
                while (n < 4) {
                    int n10 = n;
                    object[n10] = object[n10] - 1;
                    vector2.add(new Integer(object[n]));
                    ++n;
                }
                continue;
            }
            vector.add(new Point3f(object2));
        }
        if ((n3 & 0x40) == 0) {
            object = new int[]{vector.size()};
            object2 = new LineStripArray(object[0], 1, object);
            n2 = 0;
            while (n2 < object[0]) {
                object2.setCoordinate(n2, (Point3f)vector.elementAt(n2));
                ++n2;
            }
        } else {
            object = new GeometryInfo(3);
            NormalGenerator normalGenerator = new NormalGenerator();
            int[] nArray = new int[vector2.size() / 4];
            n = 0;
            while (n < nArray.length) {
                nArray[n] = 4;
                ++n;
            }
            object.setStripCounts(nArray);
            Point3f[] point3fArray = new Point3f[vector2.size()];
            int n11 = 0;
            while (n11 < vector2.size()) {
                int n12 = (Integer)vector2.elementAt(n11);
                if (n12 == -1) {
                    n12 = (Integer)vector2.elementAt(n11 - 1);
                }
                point3fArray[n11] = (Point3f)vector.elementAt(n12);
                ++n11;
            }
            object.setCoordinates(point3fArray);
            normalGenerator.generateNormals((GeometryInfo)object);
            object2 = object.getGeometryArray();
        }
        object = this.itemAppearance(string, n6, (n3 & 0x40) > 0);
        branchGroup.addChild((Node)new Shape3D((Geometry)object2, (Appearance)object));
        if (this.progress) {
            System.out.print("\\");
        }
        return this.UseNextData();
    }

    private void LoadDXFSection() {
        int n = this.readInt(this.fis);
        String string = this.readString(this.fis);
        if (this.progress) {
            System.out.print("{" + string);
        }
        if (n == 2) {
            switch (string.charAt(0)) {
                case 'B': {
                    if (string.compareTo("BLOCKS") == 0) {
                        this.LoadDXFBlocks();
                        break;
                    }
                    this.GoToNextData();
                    break;
                }
                case 'E': {
                    if (string.compareTo("ENTITIES") == 0) {
                        this.LoadDXFEntities();
                        this.CleanDXFLayers();
                        break;
                    }
                    this.GoToNextData();
                    break;
                }
                case 'H': {
                    if (string.compareTo("HEADER") == 0) {
                        this.LoadDXFHeader();
                        break;
                    }
                    this.GoToNextData();
                    break;
                }
                case 'T': {
                    if (string.compareTo("TABLES") == 0) {
                        this.LoadDXFTables();
                        break;
                    }
                    this.GoToNextData();
                    break;
                }
                default: {
                    this.GoToNextData();
                    break;
                }
            }
        }
        if (this.progress) {
            System.out.print("}");
        }
    }

    private String LoadDXFSolid(BranchGroup branchGroup) {
        Appearance appearance;
        float[] fArray = new float[12];
        boolean bl = false;
        int n = -1;
        String string = null;
        int n2 = this.readInt(this.fis);
        String string2 = null;
        while (n2 != 0) {
            switch (n2) {
                case 8: {
                    string = this.getLine(this.fis);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    fArray[n2 / 10 + n2 % 10 * 3 - 1] = this.readFloat(this.fis);
                    if (n2 % 10 != 3) break;
                    bl = true;
                    break;
                }
                case 62: {
                    n = this.readInt(this.fis);
                    break;
                }
                default: {
                    string2 = this.getLine(this.fis);
                }
            }
            n2 = this.readInt(this.fis);
        }
        string2 = this.getLine(this.fis);
        int[] nArray = new int[3];
        nArray[0] = 8;
        TriangleStripArray triangleStripArray = new TriangleStripArray(8, 1, nArray);
        if (!bl) {
            fArray[9] = fArray[6];
            fArray[10] = fArray[7];
            fArray[11] = fArray[8];
        } else if (fArray[9] == fArray[6] && fArray[10] == fArray[7] && fArray[11] == fArray[8]) {
            bl = false;
        }
        int n3 = 0;
        while (n3 < 4) {
            appearance = new Point3f(fArray[3 * n3], fArray[3 * n3 + 1], fArray[3 * n3 + 2]);
            triangleStripArray.setCoordinate(n3, (Point3f)appearance);
            triangleStripArray.setCoordinate(4 + n3, (Point3f)appearance);
            ++n3;
        }
        appearance = this.itemAppearance(string, n, false);
        branchGroup.addChild((Node)new Shape3D((Geometry)triangleStripArray, appearance));
        return string2;
    }

    private void LoadDXFTable(LayerList layerList) {
        int n = this.readInt(this.fis);
        String string = this.readString(this.fis);
        switch (string.charAt(0)) {
            case 'L': {
                if (string.compareTo("LAYER") != 0) break;
                n = this.readInt(this.fis);
                string = this.readString(this.fis);
                this.LoadDXFLayerTable(layerList);
                break;
            }
            {
                string = this.UseNextData();
                default: {
                    if (string.compareTo("ENDTAB") != 0) continue;
                }
            }
        }
    }

    private void LoadDXFTables() {
        int n = this.readInt(this.fis);
        String string = this.readString(this.fis);
        while (string.compareTo("ENDSEC") != 0) {
            if (string.compareTo("TABLE") == 0) {
                this.LoadDXFTable(this.al);
            }
            string = this.UseNextData();
        }
    }

    private String LoadDXFText(BranchGroup branchGroup) {
        String string = new String("*&^%$#@!");
        float[] fArray = new float[3];
        float f = 1.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        String string2 = null;
        int n5 = this.readInt(this.fis);
        String string3 = null;
        while (n5 != 0) {
            switch (n5) {
                case 1: {
                    string = this.getLine(this.fis);
                    break;
                }
                case 8: {
                    string2 = this.getLine(this.fis);
                    break;
                }
                case 10: 
                case 20: 
                case 30: {
                    fArray[n5 / 10 - 1] = this.readFloat(this.fis);
                    break;
                }
                case 40: {
                    f = this.readFloat(this.fis);
                    break;
                }
                case 41: {
                    f3 = this.readFloat(this.fis);
                    break;
                }
                case 50: {
                    f2 = this.convAngle(this.readFloat(this.fis));
                    break;
                }
                case 62: {
                    n4 = this.readInt(this.fis);
                    break;
                }
                case 71: {
                    n = this.readInt(this.fis);
                    break;
                }
                case 72: {
                    n2 = this.readInt(this.fis);
                    break;
                }
                case 73: {
                    n3 = this.readInt(this.fis);
                    break;
                }
                default: {
                    string3 = this.getLine(this.fis);
                }
            }
            n5 = this.readInt(this.fis);
        }
        string3 = this.getLine(this.fis);
        return string3;
    }

    private void LoadDXFWaiting() {
        this.al = new LayerList();
        boolean bl = false;
        while (!bl) {
            int n = this.readInt(this.fis);
            String string = this.readString(this.fis);
            switch (n) {
                case 0: {
                    if (string.compareTo("SECTION") == 0) {
                        this.LoadDXFSection();
                        break;
                    }
                    if (string.compareTo("EOF") == 0) {
                        bl = true;
                        break;
                    }
                    this.FileError("Section Expected");
                    break;
                }
            }
            if (!this.EOF) continue;
            bl = true;
        }
    }

    private String UseNextData() {
        int n = this.readInt(this.fis);
        String string = this.getLine(this.fis);
        while (n != 0) {
            n = this.readInt(this.fis);
            string = this.getLine(this.fis);
        }
        return string;
    }

    private float convAngle(float f) {
        float f2 = 0.0f;
        switch (this.dimaunit) {
            case 0: {
                f2 = (float)((double)(f / 180.0f) * Math.PI);
                break;
            }
            case 1: {
                f2 = (float)((double)(f / 180.0f) * Math.PI);
                break;
            }
            case 2: {
                f2 = (float)((double)(f / 200.0f) * Math.PI);
                break;
            }
            case 3: {
                f2 = f;
                break;
            }
            case 4: {
                f2 = (float)((double)(f / 200.0f) * Math.PI);
                break;
            }
            default: {
                f2 = f;
            }
        }
        return f2;
    }

    private String getLine(ReaderTokenizer readerTokenizer) {
        readerTokenizer.parseNumbersAsWords();
        readerTokenizer.wordChars(32, 32);
        readerTokenizer.wordChars(9, 9);
        int n = readerTokenizer.lineno;
        this.nextLine(readerTokenizer);
        String string = readerTokenizer.sval;
        readerTokenizer.whitespaceChar(9);
        readerTokenizer.whitespaceChar(32);
        readerTokenizer.parseNumbers();
        if (readerTokenizer.lineno > n + 1) {
            readerTokenizer.pushBack();
            string = "";
            this.forceReadNextTokenAsInt = true;
        }
        return string;
    }

    private Appearance itemAppearance(String string, int n, boolean bl) {
        Appearance appearance = null;
        if (string != null && n == -1) {
            appearance = this.al.getChild(string).getAppearance();
            appearance = ColorObj.getColor(appearance, bl);
        } else {
            if (n == -1) {
                n = 255;
            }
            appearance = ColorObj.getColor(n, this.shadedif, bl);
        }
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(7);
        polygonAttributes.setCullFace(0);
        polygonAttributes.setBackFaceNormalFlip(true);
        if (appearance != null) {
            appearance.setPolygonAttributes(polygonAttributes);
        }
        return appearance;
    }

    public static void main(String[] stringArray) {
        try {
            FileReader fileReader = new FileReader(stringArray[0]);
            DXFLoader dXFLoader = new DXFLoader();
            BranchGroup branchGroup = dXFLoader.LoadDXF(fileReader);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void nextLine(ReaderTokenizer readerTokenizer) {
        readerTokenizer.nextToken();
        if (readerTokenizer.ttype == -103) {
            this.EOF = true;
        }
        if (this.watchFile) {
            if (readerTokenizer.ttype == -101) {
                System.out.print("    word  ");
            } else if (readerTokenizer.ttype == -102) {
                System.out.print("    number");
            } else {
                System.out.print("    not a word or number");
            }
            System.out.println("    token: " + readerTokenizer.nval + "   " + readerTokenizer.sval + "  line " + readerTokenizer.lineno);
        }
    }

    private float readFloat(ReaderTokenizer readerTokenizer) {
        int n = readerTokenizer.lineno;
        float f = (float)readerTokenizer.nval;
        this.nextLine(readerTokenizer);
        float f2 = (float)readerTokenizer.nval;
        if (readerTokenizer.lineno > n + 1) {
            readerTokenizer.pushBack();
            f2 = f;
        }
        return f2;
    }

    private int readInt(ReaderTokenizer readerTokenizer) {
        int n = readerTokenizer.lineno;
        int n2 = (int)readerTokenizer.nval;
        this.nextLine(readerTokenizer);
        int n3 = (int)readerTokenizer.nval;
        if (this.forceReadNextTokenAsInt) {
            this.forceReadNextTokenAsInt = false;
            if (readerTokenizer.ttype == -101) {
                try {
                    n3 = Integer.valueOf(readerTokenizer.sval.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (readerTokenizer.lineno > n + 1) {
            readerTokenizer.pushBack();
            n3 = n2;
        }
        return n3;
    }

    private String readString(ReaderTokenizer readerTokenizer) {
        int n = readerTokenizer.lineno;
        this.nextLine(readerTokenizer);
        String string = readerTokenizer.sval;
        if (readerTokenizer.lineno > n + 1) {
            readerTokenizer.pushBack();
            string = "";
        }
        return string;
    }

    private Vector3f vAdd(Vector3f vector3f, Vector3f vector3f2) {
        return new Vector3f(vector3f.x + vector3f2.x, vector3f.y + vector3f2.y, vector3f.z + vector3f2.z);
    }

    private Vector3f vCross(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f, vector3f2);
        return vector3f3;
    }

    private Vector3f vNeg(Vector3f vector3f) {
        return new Vector3f(-vector3f.x, -vector3f.y, -vector3f.z);
    }

    private Vector3f vNormalize(Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f();
        vector3f2.normalize(vector3f);
        return vector3f2;
    }
}

