/*
 * Decompiled with CFR 0.152.
 */
import com.sun.j3d.audioengines.javasound.JavaSoundMixer;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.PointLight;
import javax.media.j3d.PointSound;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Sound;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

class My3DWindow {
    private SimpleUniverse universe;
    protected Canvas3D canvas;
    private Label label = new Label("xx.xx fps");
    private BranchGroup mainBranch;
    private BranchGroup textBranch;

    protected My3DWindow(Applet applet) throws Exception {
        applet.add("South", this.label);
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
        this.canvas = new MyCanvas3D(graphicsConfiguration, this.label);
        this.canvas.stopRenderer();
        this.canvas.setSize(new Dimension(300, 300));
        applet.add("West", (Component)this.canvas);
        Button button = new Button("Toggle Text");
        applet.add("North", button);
        button.addActionListener((ActionListener)((Object)applet));
        this.universe = new SimpleUniverse(this.canvas);
        PhysicalEnvironment physicalEnvironment = this.universe.getViewer().getPhysicalEnvironment();
        JavaSoundMixer javaSoundMixer = new JavaSoundMixer(physicalEnvironment);
        javaSoundMixer.initialize();
        physicalEnvironment.setAudioDevice((AudioDevice)javaSoundMixer);
        this.mainBranch = new BranchGroup();
        this.mainBranch.setCapability(13);
        this.mainBranch.setCapability(14);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(0.0, 0.0, -30.0));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        this.mainBranch.addChild((Node)transformGroup);
        this.makeCone((Group)transformGroup);
        Transform3D transform3D2 = new Transform3D();
        this.makeLight((Group)transformGroup, transform3D2, new Color3f(0.2f, 0.8f, 0.7f), 3250L, true);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.rotX(-1.5707963267948966);
        this.makeLight((Group)transformGroup, transform3D3, new Color3f(0.8f, 0.8f, 0.2f), 8500L, false);
        this.textBranch = this.makeText();
        this.mainBranch.addChild((Node)this.textBranch);
        this.universe.addBranchGraph(this.mainBranch);
    }

    protected void toggleText() {
        if (this.textBranch.isLive()) {
            this.textBranch.detach();
        } else {
            this.mainBranch.addChild((Node)this.textBranch);
        }
    }

    private void makeCone(Group group) {
        TransformGroup transformGroup = new TransformGroup();
        group.addChild((Node)transformGroup);
        transformGroup.setCapability(18);
        Appearance appearance = new Appearance();
        Material material = new Material();
        material.setDiffuseColor(0.8f, 0.6f, 0.7f);
        material.setEmissiveColor(0.1f, 0.1f, 0.1f);
        material.setLightingEnable(true);
        appearance.setMaterial(material);
        Cone cone = new Cone(5.0f, 10.0f, 1, 60, 20, appearance);
        transformGroup.addChild((Node)cone);
        Transform3D transform3D = new Transform3D();
        transform3D.rotZ(1.5707963267948966);
        RotationInterpolator rotationInterpolator = new RotationInterpolator(new Alpha(-1, 7700L), transformGroup);
        rotationInterpolator.setAxisOfRotation(transform3D);
        rotationInterpolator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
        group.addChild((Node)rotationInterpolator);
    }

    private void makeLight(Group group, Transform3D transform3D, Color3f color3f, long l, boolean bl) {
        TransformGroup transformGroup = new TransformGroup();
        group.addChild((Node)transformGroup);
        transformGroup.setCapability(18);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.setTranslation(new Vector3f(12.0f, 0.0f, 0.0f));
        TransformGroup transformGroup2 = new TransformGroup(transform3D2);
        transformGroup.addChild((Node)transformGroup2);
        PointLight pointLight = new PointLight();
        pointLight.setColor(color3f);
        pointLight.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
        transformGroup2.addChild((Node)pointLight);
        Appearance appearance = new Appearance();
        Material material = new Material();
        material.setEmissiveColor(color3f);
        material.setDiffuseColor(color3f);
        appearance.setMaterial(material);
        transformGroup2.addChild((Node)new Sphere(1.0f, appearance));
        if (bl) {
            transformGroup2.addChild((Node)this.makeSound());
        }
        Alpha alpha = new Alpha();
        alpha.setMode(2);
        alpha.setDecreasingAlphaDuration(l);
        RotationInterpolator rotationInterpolator = new RotationInterpolator(alpha, transformGroup);
        rotationInterpolator.setAxisOfRotation(transform3D);
        rotationInterpolator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
        group.addChild((Node)rotationInterpolator);
    }

    private BranchGroup makeText() {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        Text2D text2D = new Text2D("Java3D", new Color3f(1.0f, 0.0f, 0.0f), "Helvetica", 24, 1);
        TextureAttributes textureAttributes = text2D.getAppearance().getTextureAttributes();
        if (textureAttributes == null) {
            textureAttributes = new TextureAttributes();
            text2D.getAppearance().setTextureAttributes(textureAttributes);
        }
        textureAttributes.setTextureMode(2);
        text2D.getAppearance().getTransparencyAttributes().setTransparency(0.5f);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(-5.0, 0.0, -15.0));
        transform3D.setScale(30.0);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)text2D);
        branchGroup.addChild((Node)transformGroup);
        return branchGroup;
    }

    private Sound makeSound() {
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        float[] fArray = new float[]{0.0f, 50.0f};
        float[] fArray2 = new float[]{1.0f, 0.0f};
        PointSound pointSound = null;
        URL uRL = this.getClass().getResource("boing.wav");
        System.out.println("soundURL = " + uRL);
        MediaContainer mediaContainer = new MediaContainer(uRL);
        pointSound = new PointSound(mediaContainer, 3.0f, 0.0f, 0.0f, 0.0f);
        pointSound.setDistanceGain(fArray, fArray2);
        pointSound.setSchedulingBounds((Bounds)boundingSphere);
        pointSound.setLoop(1000);
        pointSound.setEnable(true);
        return pointSound;
    }
}

