/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GraphicsConfiguration;
import java.awt.Label;
import java.text.DecimalFormat;
import javax.media.j3d.Canvas3D;

class MyCanvas3D
extends Canvas3D {
    private long lastTime = -1L;
    private long frameCount = 0L;
    private Label myLabel;
    private StringBuffer buffer = new StringBuffer(15);
    private DecimalFormat format;

    MyCanvas3D(GraphicsConfiguration graphicsConfiguration, Label label) {
        super(graphicsConfiguration);
        this.myLabel = label;
        this.format = new DecimalFormat("###.00");
    }

    public void postRender() {
        super.postRender();
        ++this.frameCount;
        long l = System.currentTimeMillis();
        if (this.lastTime == -1L) {
            this.lastTime = l;
            return;
        }
        long l2 = l - this.lastTime;
        if (l2 >= 2000L) {
            double d = (double)this.frameCount / (double)l2 * 1000.0;
            this.myLabel.setText(this.format.format(d) + " fps");
            this.frameCount = 0L;
            this.lastTime = l;
        }
    }
}

