/*
 * Decompiled with CFR 0.152.
 */
import com.sun.j3d.utils.applet.MainFrame;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TestJ3D
extends Applet
implements ActionListener {
    private TextArea textArea;
    private My3DWindow win;

    public void init() {
        this.setLayout(new BorderLayout());
        this.textArea = new TextArea("Inspecting your Java installation...\n", 20, 10);
        this.textArea.append("Java Version: " + this.getProp("java.version") + "\n");
        this.textArea.append("Vendor: " + this.getProp("java.vendor") + "\n");
        this.textArea.append("Looking for Java3D version 1.2.1 or later.\n");
        this.textArea.append("Installed Java3D version: ");
        boolean bl = true;
        try {
            Class<?> clazz = Class.forName("javax.media.j3d.BranchGroup");
            this.textArea.append(clazz.getPackage().getImplementationVersion() + "\n");
            this.textArea.append("Java 3D upgrade required? " + clazz.getPackage().isCompatibleWith("1.2.1") + "\n");
        }
        catch (Exception exception) {
            this.textArea.append("Java3D not installed!\n");
            bl = false;
        }
        try {
            if (bl) {
                this.do3DStuff();
            }
        }
        catch (Exception exception) {
            this.textArea.append("Caught an exception while trying to run 3D:\n");
            this.textArea.append(exception.getMessage());
        }
        this.add("Center", this.textArea);
    }

    private void do3DStuff() throws Exception {
        this.win = new My3DWindow(this);
    }

    public void start() {
        if (this.win != null) {
            this.win.canvas.startRenderer();
        }
    }

    public void stop() {
    }

    public void destroy() {
        this.stop();
    }

    public static void main(String[] stringArray) {
        System.out.println("In main!");
        new MainFrame((Applet)new TestJ3D(), 380, 380);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Toggle Text")) {
            this.win.toggleText();
        }
    }

    private String getProp(String string) {
        String string2;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            string2 = securityException.toString();
        }
        return string2;
    }
}

