import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3f;

final public class MyMatrix3f extends Matrix3f {


  public MyMatrix3f() {
    super();
  }
  public MyMatrix3f(float[] v) {
    super(v);
  }
  public MyMatrix3f(float m00, float m01, float m02, 
		    float m10, float m11, float m12, 
		    float m20, float m21, float m22) {

    super(m00, m01, m02, 
	  m10, m11, m12, 
	  m20, m21, m22);
  }
  public MyMatrix3f(Matrix3f m) {
    super(m);
  }
  public MyMatrix3f(Matrix3d m) {
    super(m);
  }

  /**
   * Return the Vectorsum of the vector multiplication of itself and Vector3f v
   */
  final public MyVector3f mul(Vector3f v) {
    return new MyVector3f(m00*v.x + m01*v.y + m02*v.z,
			m10*v.x + m11*v.y + m12*v.z,
			m20*v.x + m21*v.y + m22*v.z);
  }
}
