import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3d;

final public class MyVector3f extends Vector3f {

  public MyVector3f() {
    super();
  }
  public MyVector3f(float[] v) {
    super(v);
  }
  public MyVector3f(float x, float y, float z) {
    super(x, y, z);
  }
  public MyVector3f(Vector3f v) {
    super(v);
  }
  public MyVector3f(Vector3d v) {
    super(v);
  }
  public MyVector3f(Tuple3f v) {
    super(v);
  }
  public MyVector3f(Tuple3d v) {
    super(v);
  }

  /**
   * Set the value of this Vector to the vector multiplication of Matrix3f m and itself.
   */
  final public void mul(Matrix3f m) {
    float x1 = x*m.m00 + y*m.m10 + z*m.m20;
    float y1 = x*m.m01 + y*m.m11 + z*m.m21;
    z = x*m.m02 + y*m.m12 + z*m.m22;
    x = x1; y = y1;
  }

  /**
   * Return the Vector sum of the vector multiplication of Matrix3f m and itself.
   */
  final public Vector3f mulNewVector(Matrix3f m) {
    return new Vector3f(x*m.m00 + y*m.m10 + z*m.m20,
			x*m.m01 + y*m.m11 + z*m.m21,
			x*m.m02 + y*m.m12 + z*m.m22);
  }
}

