
/**
 * Title:        Simulador_Beta1<p>
 * Description:  Arquivo do Frame Inicial do Simulador<p>
 * Copyright:    Copyright (c) Denis Hiplito<p>
 * Company:      DEE/CCT<p>
 * @author Denis Hiplito
 * @version 1.0
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Frame_princip extends JFrame {
  JPanel contentPane;
  JMenuBar menuBar1 = new JMenuBar();
  JMenu menuFile = new JMenu();
  JMenuItem menuFileConfig = new JMenuItem();
  //JMenuItem menuFileNew = new JMenuItem();
  JMenuItem menuFileExit = new JMenuItem();
  JMenu menuHelp = new JMenu();
  JMenuItem menuHelpAbout = new JMenuItem();
  JLabel statusBar = new JLabel();
  BorderLayout borderLayout1 = new BorderLayout();

  //Construcao do Frame
  public Frame_princip() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      init();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  //Inicializacao dos Componentes
  private void init() throws Exception  {
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(borderLayout1);
    contentPane.setBackground(Color.white);
    this.setSize(new Dimension(700, 600));
    this.setTitle("Simulador Versao Beta-teste1");
    statusBar.setText(" ");
    menuFile.setText("Arquivo");
    menuFileConfig.setText("Configuracao");
    menuFileConfig.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        fileConfig_actionPerformed(e);
      }
    });
    //menuFileNew.setText("Novo");
    menuFileExit.setText("Exit");
    menuFileExit.addActionListener(new ActionListener()  {

      public void actionPerformed(ActionEvent e) {
        fileExit_actionPerformed(e);
      }
    });
    menuHelp.setText("Ajuda");
    menuHelpAbout.setText("Sobre");
    menuHelpAbout.addActionListener(new ActionListener()  {

      public void actionPerformed(ActionEvent e) {
        helpAbout_actionPerformed(e);
      }
    });

    //menuFile.add(menuFileNew);
    menuFile.add(menuFileConfig);
    menuFile.addSeparator();	
    menuFile.add(menuFileExit);
    menuHelp.add(menuHelpAbout);
    menuBar1.add(menuFile);
    menuBar1.add(menuHelp);
    contentPane.add(menuBar1,BorderLayout.NORTH);
    this.setJMenuBar(menuBar1);
    contentPane.add(statusBar, BorderLayout.SOUTH);
    contentPane.add(new Animation(), BorderLayout.CENTER);
  }
  //Metodo Arquivo | Sair
  public void fileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }
  public void fileConfig_actionPerformed(ActionEvent e){
    Config dlg = new Config();
    dlg.show();
  }
  //Tela Sobre o Simulador
  public void helpAbout_actionPerformed(ActionEvent e) {
    Frame_princip_AboutBox dlg = new Frame_princip_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x,
                    (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.show();
  }

  //Fechar Janela
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      fileExit_actionPerformed(null);
    }
  }
}
