/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.ClassPrepareRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jde.debugger.Debug;
import jde.debugger.EventHandler;
import jde.debugger.GeneralCommands;
import jde.debugger.JDEException;
import jde.debugger.Jdebug;
import jde.debugger.LispForm;
import jde.debugger.ObjectStore;
import jde.debugger.Protocol;
import jde.debugger.SpecCommands;
import jde.debugger.ThreadCommands;
import jde.debugger.spec.BreakpointSpec;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.EventRequestSpecList;
import jde.debugger.spec.ExceptionSpec;
import jde.debugger.spec.WatchpointSpec;

public class Application
implements Protocol {
    private long id = 0L;
    final Integer my_id;
    final Jdebug jdebug;
    Socket mySocket = null;
    EventHandler eventHandler;
    VirtualMachine vm;
    EventRequestSpecList eventRequestSpecs;
    Collection pendingCommands;
    ObjectStore store;
    GeneralCommands generalCommands;
    SpecCommands specCommands;
    ThreadCommands threadCommands;
    private boolean shuttingDown = false;

    public Long getNewID() {
        Integer n = Jdebug.my_id;
        synchronized (n) {
            Long l = new Long(this.id++);
            Object var2_3 = null;
            return l;
        }
    }

    private boolean isShuttingDown() {
        return this.shuttingDown;
    }

    /*
     * WARNING - void declaration
     */
    public int initialize(String connectType, List args) throws JDEException {
        void var3_3;
        String connectSpec;
        int ioport = -1;
        if (connectType.equals("launch")) {
            connectSpec = "com.sun.jdi.CommandLineLaunch";
            Connector connector = this.getConnector(connectSpec);
            if (connector == null) {
                throw new JDEException("No such connector is avaliable: " + connectSpec);
            }
            ioport = this.launch((LaunchingConnector)connector, args);
        } else if (connectType.equals("attach_socket") || connectType.equals("attach_shmem")) {
            connectSpec = null;
            connectSpec = connectType.equals("attach_socket") ? "com.sun.jdi.SocketAttach" : "com.sun.jdi.SharedMemoryAttach";
            Connector connector = this.getConnector(connectSpec);
            if (connector == null) {
                throw new JDEException("No such connector is available: " + connectSpec);
            }
            if (connectType.equals("attach_socket")) {
                this.attachSocket((AttachingConnector)connector, args);
            } else {
                this.attachShmem((AttachingConnector)connector, args);
            }
        } else if (connectType.equals("listen_socket") || connectType.equals("listen_shmem")) {
            connectSpec = null;
            connectSpec = connectType.equals("listen_socket") ? "com.sun.jdi.SocketListen" : "com.sun.jdi.SharedMemoryListen";
            Connector connector = this.getConnector(connectSpec);
            if (connector == null) {
                throw new JDEException("No such connector is available: " + connectSpec);
            }
            if (connectType.equals("listen_socket")) {
                this.listenSocket((ListeningConnector)connector, args);
            } else {
                this.listenShmem((ListeningConnector)connector, args);
            }
        }
        this.eventHandler = new EventHandler(this);
        this.eventRequestSpecs = new EventRequestSpecList(this);
        ClassPrepareRequest cprequest = this.vm.eventRequestManager().createClassPrepareRequest();
        cprequest.putProperty("default", "default");
        cprequest.setSuspendPolicy(2);
        cprequest.enable();
        this.generalCommands = new GeneralCommands(this, this.store);
        this.specCommands = new SpecCommands(this, this.eventRequestSpecs, this.store);
        this.threadCommands = new ThreadCommands(this, this.store);
        return (int)var3_3;
    }

    public VirtualMachine getVM() {
        return this.vm;
    }

    public Integer getId() {
        return this.my_id;
    }

    public ObjectStore getStore() {
        return this.store;
    }

    public EventQueue getEventQueue() {
        return this.vm.eventQueue();
    }

    public void shutdown() {
        this.shuttingDown = true;
        Process process = null;
        if (this.vm != null) {
            process = this.vm.process();
        }
        try {
            try {
                if (this.vm != null) {
                    this.vm.dispose();
                    this.vm = null;
                    this.eventHandler.shutdown();
                }
                this.mySocket.close();
            }
            catch (Exception exception) {
                Object var3_3 = null;
                if (process != null) {
                    process.destroy();
                }
                this.jdebug.removeApplication(this.my_id);
            }
            Object var3_2 = null;
            if (process != null) {
                process.destroy();
            }
            this.jdebug.removeApplication(this.my_id);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (process != null) {
                process.destroy();
            }
            this.jdebug.removeApplication(this.my_id);
            throw throwable;
        }
    }

    private Connector getConnector(String name) {
        List<Connector> connectors = Bootstrap.virtualMachineManager().allConnectors();
        Iterator<Connector> iter = connectors.iterator();
        while (iter.hasNext()) {
            Connector connector = iter.next();
            if (!connector.name().equals(name)) continue;
            return connector;
        }
        return null;
    }

    private int launch(LaunchingConnector connector, List args) throws JDEException {
        Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
        Connector.Argument mainArg = argumentMap.get("main");
        String commandLine = "";
        String quote = argumentMap.get("quote").value();
        if (args.size() == 0) {
            throw new JDEException("Insufficient arguments");
        }
        String executable = "java";
        while (args.size() > 0 && args.get(0).toString().startsWith("-")) {
            String arg = args.remove(0).toString().toLowerCase();
            if (arg.equals("-use_executable")) {
                if (args.size() == 0) {
                    throw new JDEException("Missing argument to 'use_executable'");
                }
                executable = args.remove(0).toString();
                Connector.Argument vmexecArg = argumentMap.get("vmexec");
                vmexecArg.setValue(executable);
                continue;
            }
            args.add(0, arg);
            break;
        }
        if (args.size() == 0) {
            throw new JDEException("Missing arguments: no class specified?");
        }
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            String arg = (String)iterator.next();
            if (arg.equalsIgnoreCase("-classic")) {
                Connector.Argument optionsArg = argumentMap.get("options");
                String options = optionsArg.value();
                options = "-classic" + " " + options;
                optionsArg.setValue(options);
                this.signal("message", "VM options: '" + options + "'");
                continue;
            }
            commandLine = commandLine + quote + arg + quote + " ";
        }
        mainArg.setValue(commandLine);
        try {
            this.vm = connector.launch(argumentMap);
            this.signal("message", "Launched VM " + this.vm.description());
        }
        catch (IOException ex) {
            Debug.printIf(ex);
            throw new JDEException("Unable to launch: " + ex);
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Invalid or inconsistent connector arguments for connector '" + connector + "'");
        }
        catch (VMStartException ex) {
            this.dumpFailedAppStreams(ex.process());
            throw new JDEException(ex.getMessage());
        }
        int port = this.manageAppStreams(this.vm.process());
        return port;
    }

    private void attachSocket(AttachingConnector connector, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Missing arguments: specify at least the port");
        }
        try {
            Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
            while (args.size() > 0 && args.get(0).toString().startsWith("-")) {
                String arg = args.remove(0).toString().toLowerCase();
                if (arg.equals("-host")) {
                    if (args.size() == 0) {
                        throw new JDEException("Missing argument to 'host'");
                    }
                    String host = args.remove(0).toString();
                    Connector.Argument hostArg = argumentMap.get("host");
                    hostArg.setValue(host);
                    continue;
                }
                if (arg.equals("-port")) {
                    if (args.size() == 0) {
                        throw new JDEException("Missing argument to 'port'");
                    }
                    String port = args.remove(0).toString();
                    Connector.Argument portArg = argumentMap.get("port");
                    portArg.setValue(port);
                    continue;
                }
                args.add(0, arg);
                break;
            }
            this.vm = connector.attach(argumentMap);
            this.signal("message", "Attached VM (socket) " + this.vm.description());
        }
        catch (IOException ex) {
            Debug.printIf(ex);
            throw new JDEException("Error occured managing application streams");
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Illegal connector arguments for connector '" + connector);
        }
    }

    private void attachShmem(AttachingConnector connector, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Missing name");
        }
        try {
            Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
            Connector.Argument nameArg = argumentMap.get("name");
            nameArg.setValue(args.remove(0).toString());
            this.vm = connector.attach(argumentMap);
            this.signal("message", "Attached VM (shmem) " + this.vm.description());
        }
        catch (IOException ex) {
            Debug.printIf(ex);
            throw new JDEException("Error occured managing application streams");
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Illegal connector arguments for connector '" + connector);
        }
    }

    private void listenSocket(ListeningConnector connector, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Missing arguments: specify at least the port");
        }
        try {
            Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
            String port = args.remove(0).toString();
            Connector.Argument portArg = argumentMap.get("port");
            portArg.setValue(port);
            connector.startListening(argumentMap);
            this.vm = connector.accept(argumentMap);
            connector.stopListening(argumentMap);
        }
        catch (IOException ex) {
            Debug.printIf(ex);
            throw new JDEException("Error occured managing application streams");
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Illegal connector arguments for connector '" + connector);
        }
    }

    private void listenShmem(ListeningConnector connector, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Missing name");
        }
        try {
            Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
            Connector.Argument nameArg = argumentMap.get("name");
            nameArg.setValue(args.remove(0).toString());
            connector.startListening(argumentMap);
            this.vm = connector.accept(argumentMap);
            connector.stopListening(argumentMap);
        }
        catch (IOException ex) {
            Debug.printIf(ex);
            throw new JDEException("Error occured managing application streams");
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Illegal connector arguments for connector '" + connector);
        }
    }

    private int manageAppStreams(Process process) throws JDEException {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(0);
        }
        catch (IOException ex) {
            throw new JDEException("Unable to create a server socket");
        }
        ServerSocket sstmp = ss;
        int port = ss.getLocalPort();
        Application application = this;
        if (application == null) {
            throw null;
        }
        Thread thr = new Thread(application, sstmp, process, "Temporary Thread for App #" + this.my_id){
            private final /* synthetic */ Application this$0;
            private final /* synthetic */ ServerSocket val$sstmp;
            private final /* synthetic */ Process val$process;

            public void run() {
                try {
                    this.this$0.mySocket = this.val$sstmp.accept();
                    this.val$sstmp.close();
                }
                catch (IOException ex) {
                    this.this$0.shutdown();
                }
                Application.access$0(this.this$0, this.val$process.getOutputStream());
                Application.access$1(this.this$0, this.val$process.getInputStream());
                Application.access$1(this.this$0, this.val$process.getErrorStream());
            }
            {
                this.val$sstmp = val$sstmp;
                this.val$process = val$process;
                this.this$0 = this$0;
                this.constructor$0(this$0, $1);
            }

            private final void constructor$0(Application application, String $1) {
            }
        };
        thr.start();
        return port;
    }

    private void dumpFailedAppStreams(Process process) {
        try {
            this.dumpStream(process.getInputStream());
            this.dumpStream(process.getErrorStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processRemoteInput(OutputStream stream) {
        void var2_2;
        Application application = this;
        if (application == null) {
            throw null;
        }
        Thread thr = new Thread(application, stream, "Input Processor for App #" + this.my_id){
            private final /* synthetic */ Application this$0;
            private final /* synthetic */ OutputStream val$stream;

            public void run() {
                block8: {
                    try {
                        String line;
                        PrintStream out = new PrintStream(this.val$stream, true);
                        BufferedReader in = new BufferedReader(new InputStreamReader(this.this$0.mySocket.getInputStream()));
                        while ((line = in.readLine()) != null) {
                            out.println(line);
                            out.flush();
                        }
                        if (!Application.access$2(this.this$0)) {
                            try {
                                this.this$0.mySocket.close();
                                this.this$0.signal("message", "Application I/O closed");
                            }
                            catch (Exception ex) {
                                this.this$0.signal("message", "Couldn't close application I/O");
                            }
                        }
                    }
                    catch (IOException ex) {
                        if (Application.access$2(this.this$0)) break block8;
                        try {
                            this.this$0.mySocket.close();
                            this.this$0.signal("error", "Input error; application I/O closed");
                        }
                        catch (Exception e) {
                            this.this$0.signal("error", "Input error; couldn't close application I/O");
                        }
                    }
                }
            }
            {
                this.val$stream = val$stream;
                this.this$0 = this$0;
                this.constructor$0(this$0, $1);
            }

            private final void constructor$0(Application application, String $1) {
            }
        };
        thr.setPriority(9);
        var2_2.start();
    }

    /*
     * WARNING - void declaration
     */
    private void displayRemoteOutput(InputStream stream) {
        void var2_2;
        Application application = this;
        if (application == null) {
            throw null;
        }
        Thread thr = new Thread(application, stream, "Output Processor for App #" + this.my_id){
            private final /* synthetic */ Application this$0;
            private final /* synthetic */ InputStream val$stream;

            public void run() {
                block4: {
                    try {
                        Application.access$3(this.this$0, this.val$stream);
                    }
                    catch (IOException ex) {
                        if (Application.access$2(this.this$0)) break block4;
                        try {
                            this.this$0.mySocket.close();
                            this.this$0.signal("error", "Output error; application I/O closed");
                        }
                        catch (Exception e) {
                            this.this$0.signal("error", "Output error; couldn't close application I/O");
                        }
                    }
                }
            }
            {
                this.val$stream = val$stream;
                this.this$0 = this$0;
                this.constructor$0(this$0, $1);
            }

            private final void constructor$0(Application application, String $1) {
            }
        };
        thr.setPriority(9);
        var2_2.start();
    }

    private void dumpStream(InputStream stream) throws IOException {
        String line;
        if (this.mySocket == null || this.mySocket.getOutputStream() == null) {
            return;
        }
        PrintStream outStream = new PrintStream(this.mySocket.getOutputStream());
        BufferedReader in = new BufferedReader(new InputStreamReader(stream));
        while ((line = in.readLine()) != null) {
            outStream.println(line);
            outStream.flush();
        }
        if (!this.isShuttingDown()) {
            try {
                this.mySocket.close();
                this.signal("message", "Application I/O closed");
            }
            catch (Exception ex) {
                this.signal("message", "Couldn't close application I/O");
            }
        }
    }

    public List findClassesMatchingPattern(String pattern) throws JDEException {
        if (this.vm == null) {
            return null;
        }
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>();
        if (pattern.startsWith("*.")) {
            pattern = pattern.substring(1);
            List<ReferenceType> classes = this.vm.allClasses();
            Iterator<ReferenceType> iter = classes.iterator();
            while (iter.hasNext()) {
                ReferenceType type = iter.next();
                if (!type.name().endsWith(pattern)) continue;
                result.add(type);
            }
            return result;
        }
        return this.vm.classesByName(pattern);
    }

    /*
     * Loose catch block
     */
    public void handleCommand(Integer cmd_id, String command, List args) {
        Collection collection;
        Collection collection2 = this.pendingCommands;
        synchronized (collection2) {
            if (this.pendingCommands.contains(cmd_id)) {
                this.signalCommandError(new Integer(-1), "Duplicate command id '" + cmd_id + "'");
            }
        }
        try {
            block45: {
                command = command.toLowerCase();
                if (command.equals("run")) {
                    this.generalCommands.doRun(cmd_id, args);
                    break block45;
                }
                if (command.equals("finish")) {
                    this.generalCommands.doFinish(cmd_id, args);
                    break block45;
                }
                if (command.equals("evaluate")) {
                    this.generalCommands.doEvaluate(cmd_id, args);
                    break block45;
                }
                if (command.equals("get_object")) {
                    this.generalCommands.doGetObject(cmd_id, args);
                    break block45;
                }
                if (command.equals("get_array")) {
                    this.generalCommands.doGetArray(cmd_id, args);
                    break block45;
                }
                if (command.equals("get_string")) {
                    this.generalCommands.doGetString(cmd_id, args);
                    break block45;
                }
                if (command.equals("get_locals")) {
                    this.generalCommands.doGetLocals(cmd_id, args);
                    break block45;
                }
                if (command.equals("get_loaded_classes")) {
                    this.generalCommands.doGetLoadedClasses(cmd_id, args);
                    break block45;
                }
                if (command.equals("get_path_information")) {
                    this.generalCommands.doGetPathInformation(cmd_id, args);
                    break block45;
                }
                if (command.equals("trace_classes")) {
                    this.generalCommands.doTraceClasses(cmd_id, args);
                    break block45;
                }
                if (command.equals("cancel_trace_classes")) {
                    this.generalCommands.doCancelTraceClasses(cmd_id, args);
                    break block45;
                }
                if (command.equals("trace_exceptions")) {
                    this.specCommands.doTraceExceptions(cmd_id, args);
                    break block45;
                }
                if (command.equals("watch")) {
                    this.specCommands.doWatch(cmd_id, args);
                    break block45;
                }
                if (command.equals("break")) {
                    this.specCommands.doBreak(cmd_id, args);
                    break block45;
                }
                if (command.equals("clear")) {
                    this.specCommands.doClear(cmd_id, args);
                    break block45;
                }
                if (command.equals("step")) {
                    this.specCommands.doStep(cmd_id, args);
                    break block45;
                }
                if (command.equals("trace_methods")) {
                    this.generalCommands.doTraceMethods(cmd_id, args);
                    break block45;
                }
                if (command.equals("cancel_trace_methods")) {
                    this.generalCommands.doCancelTraceMethods(cmd_id, args);
                    break block45;
                }
                if (command.equals("suspend")) {
                    this.threadCommands.doSuspend(cmd_id, args);
                    break block45;
                }
                if (command.equals("resume")) {
                    this.threadCommands.doResume(cmd_id, args);
                    break block45;
                }
                if (command.equals("interrupt")) {
                    this.threadCommands.doInterrupt(cmd_id, args);
                    break block45;
                }
                if (command.equals("kill_thread")) {
                    this.threadCommands.doKillThread(cmd_id, args);
                    break block45;
                }
                if (command.equals("get_threads")) {
                    this.threadCommands.doGetThreads(cmd_id, args);
                    break block45;
                }
                if (command.equals("get_thread")) {
                    this.threadCommands.doGetThread(cmd_id, args);
                    break block45;
                }
                if (command.equals("get_object_monitors")) {
                    this.threadCommands.doGetObjectMonitors(cmd_id, args);
                    break block45;
                }
                if (command.equals("trace_threads")) {
                    this.threadCommands.doTraceThreads(cmd_id, args);
                    break block45;
                }
                if (command.equals("cancel_trace_threads")) {
                    this.threadCommands.doCancelTraceThreads(cmd_id, args);
                    break block45;
                }
                this.signalCommandError(cmd_id, "'" + command + "' is not supported");
            }
            Object var5_6 = null;
            collection = this.pendingCommands;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            Collection collection3 = this.pendingCommands;
            synchronized (collection3) {
                this.pendingCommands.remove(cmd_id);
            }
            throw throwable;
        }
        synchronized (collection) {
            this.pendingCommands.remove(cmd_id);
        }
        {
            catch (JDEException ex) {
                Debug.printIf(ex);
                this.signalCommandError(cmd_id, ex);
                Object var5_7 = null;
                Collection collection4 = this.pendingCommands;
                synchronized (collection4) {
                    this.pendingCommands.remove(cmd_id);
                }
                return;
            }
            catch (Exception ex) {
                Debug.printIf(ex);
                this.signalCommandError(cmd_id, "An unspecified error occured: '" + ex.toString() + "'");
                Object var5_8 = null;
                Collection collection5 = this.pendingCommands;
                synchronized (collection5) {
                    this.pendingCommands.remove(cmd_id);
                }
                return;
            }
        }
    }

    public void resolve(ReferenceType ref) {
        this.eventRequestSpecs.resolve(ref);
    }

    public void informJDEInstallSuccessful(EventRequestSpec spec) {
        this.signal("spec-resolved", spec.getID());
    }

    public void removeSpecAndInformJDE(EventRequestSpec spec, String problem) {
        if (spec instanceof BreakpointSpec) {
            this.signal("invalid-break", new LispForm(spec.getID() + " \"" + problem + "\""));
        } else if (spec instanceof WatchpointSpec) {
            this.signal("invalid-watch", new LispForm(spec.getID() + " \"" + problem + "\""));
        } else if (spec instanceof ExceptionSpec) {
            this.signal("invalid-trace_exceptions", new LispForm(spec.getID() + " \"" + problem + "\""));
        }
        this.eventRequestSpecs.delete(spec);
    }

    public void signal(String type, Object obj) {
        this.jdebug.signal(this.my_id, type, obj);
    }

    public void signalCommandResult(Integer cmd_id) {
        this.jdebug.signalCommandResult(this.my_id, cmd_id);
    }

    public void signalCommandResult(Integer cmd_id, Object obj) {
        this.jdebug.signalCommandResult(this.my_id, cmd_id, obj);
    }

    public void signalCommandError(Integer cmd_id, String error) {
        this.jdebug.signalCommandError(this.my_id, cmd_id, error);
    }

    public void signalCommandError(Integer cmd_id, JDEException ex) {
        this.jdebug.signalCommandError(this.my_id, cmd_id, ex.getMessage());
    }

    static /* synthetic */ void access$0(Application application, OutputStream outputStream) {
        application.processRemoteInput(outputStream);
    }

    static /* synthetic */ void access$1(Application application, InputStream inputStream) {
        application.displayRemoteOutput(inputStream);
    }

    static /* synthetic */ boolean access$2(Application application) {
        return application.isShuttingDown();
    }

    static /* synthetic */ void access$3(Application application, InputStream inputStream) throws IOException {
        application.dumpStream(inputStream);
    }

    public Application(Jdebug jdebug, Integer app_id) {
        this.jdebug = jdebug;
        this.my_id = app_id;
        this.pendingCommands = Collections.synchronizedSet(new HashSet());
        this.store = new ObjectStore(this);
    }
}

