/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jde.debugger.LispForm;
import jde.debugger.ObjectStore;
import jde.debugger.Protocol;

public class Rep
implements Protocol {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LispForm getLocationRep(Location loc) {
        String locationString = "(list \"" + loc.declaringType().name() + "\"";
        try {
            locationString = locationString + " \"" + loc.sourceName() + "\"";
        }
        catch (AbsentInformationException ex) {
            locationString = locationString + " nil";
        }
        locationString = locationString + " " + loc.lineNumber() + ")";
        return new LispForm(locationString);
    }

    static LispForm getMethodRep(Method m) {
        List<String> l = m.argumentTypeNames();
        String argList = "(list";
        Iterator<String> it = l.iterator();
        while (it.hasNext()) {
            argList = argList + " \"" + it.next().toString() + "\"";
        }
        argList = argList + ")";
        return new LispForm("(list \"" + m.declaringType().name() + "\"" + " \"" + m.name() + "\"" + " \"" + m.returnTypeName() + "\"" + Protocol.BR + argList + (m.isFinal() ? " \"final\"" : "") + (m.isStatic() ? " \"static\"" : "") + (m.isNative() ? " \"native\"" : "") + (m.isConstructor() ? " \"constructor\"" : "") + (m.isAbstract() ? " \"abstract\"" : "") + (m.isSynchronized() ? " \"synchronized\"" : "") + (m.isStaticInitializer() ? " \"static_initializer\"" : "") + ")");
    }

    static LispForm getLocalVariableRep(LocalVariable lv) {
        return new LispForm("(list" + " \"" + lv.name() + "\"" + " \"" + lv.typeName() + "\")");
    }

    static LispForm getLocalVariableValueRep(LocalVariable lv, Value v, ObjectStore s) {
        return new LispForm("(cons " + Rep.getLocalVariableRep(lv) + " " + Rep.getValueRep(v, s) + ")");
    }

    static LispForm getLocalVariableValueMapRep(Map map, ObjectStore s) {
        String localVariablesValuesString = "(list ";
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iter.next();
            Value val = (Value)map.get(localVariable);
            localVariablesValuesString = localVariablesValuesString + Protocol.BR + Rep.getLocalVariableValueRep(localVariable, val, s);
        }
        localVariablesValuesString = localVariablesValuesString + ")";
        return new LispForm(localVariablesValuesString);
    }

    static LispForm getFieldRep(Field f) {
        return new LispForm("(list" + " \"" + f.name() + "\"" + " \"" + f.typeName() + "\"" + (f.isTransient() ? " \"transient\"" : "") + (f.isVolatile() ? " \"volatile\"" : "") + (f.isFinal() ? " \"final\"" : "") + (f.isStatic() ? " \"static\"" : "") + ")");
    }

    static LispForm getFieldValueRep(Field f, Value v, ObjectStore s) {
        return new LispForm("(cons " + Rep.getFieldRep(f) + " " + Rep.getValueRep(v, s) + ")");
    }

    static LispForm getFieldValueMapRep(Map map, ObjectStore s) {
        String fieldsValuesString = "(list ";
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Field field = (Field)iter.next();
            Value val = (Value)map.get(field);
            fieldsValuesString = fieldsValuesString + Protocol.BR + Rep.getFieldValueRep(field, val, s);
        }
        fieldsValuesString = fieldsValuesString + ")";
        return new LispForm(fieldsValuesString);
    }

    static LispForm getValueRep(Value value, ObjectStore store) {
        if (value == null) {
            return new LispForm("(list \"null\")");
        }
        if (value instanceof VoidValue) {
            return new LispForm("(list \"void\")");
        }
        if (value instanceof ObjectReference) {
            return Rep.getObjectRep((ObjectReference)value, store);
        }
        PrimitiveValue v = (PrimitiveValue)value;
        if (v instanceof BooleanValue) {
            return new LispForm("(list \"boolean\" \"" + v.booleanValue() + "\")");
        }
        if (v instanceof ByteValue) {
            return new LispForm("(list \"byte\" '" + v.byteValue() + "')");
        }
        if (v instanceof CharValue) {
            return new LispForm("(list \"char\" '" + v.charValue() + ")");
        }
        if (v instanceof DoubleValue) {
            return new LispForm("(list \"double\" " + v.doubleValue() + ")");
        }
        if (v instanceof FloatValue) {
            return new LispForm("(list \"float\" " + v.floatValue() + ")");
        }
        if (v instanceof IntegerValue) {
            return new LispForm("(list \"int\" " + v.intValue() + ")");
        }
        if (v instanceof LongValue) {
            return new LispForm("(list \"long\" " + v.longValue() + ")");
        }
        if (v instanceof ShortValue) {
            return new LispForm("(list \"short\" " + v.shortValue() + ")");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LispForm getArrayRep(ArrayReference a, ObjectStore store, int index, int length) {
        String string;
        if (a == null) {
            return new LispForm("\"Error!\"");
        }
        store.put(a);
        String elementsString = "";
        try {
            if (index != -1) {
                List<Value> elements = a.getValues(index, length);
                Iterator<Value> it = elements.iterator();
                while (it.hasNext()) {
                    elementsString = elementsString + " " + Rep.getValueRep(it.next(), store);
                }
            }
        }
        catch (IndexOutOfBoundsException ex) {
            elementsString = "\"Index out of bounds\"";
        }
        catch (ObjectCollectedException ex) {
            elementsString = "\"The object has already been collected\"";
        }
        StringBuffer stringBuffer = new StringBuffer().append("(list ").append("\"").append(a.referenceType().name()).append("\"").append(" ").append(a.uniqueID());
        if (a.isCollected()) {
            string = " 't";
            return new LispForm(stringBuffer.append(string).append(" ").append(a.length()).append(elementsString).append(")").toString());
        }
        string = " nil";
        return new LispForm(stringBuffer.append(string).append(" ").append(a.length()).append(elementsString).append(")").toString());
    }

    static LispForm getStringRep(StringReference s, ObjectStore store) {
        if (s == null) {
            return new LispForm("\"Error!\"");
        }
        store.put(s);
        return new LispForm("(list " + "\"" + s.referenceType().name() + "\"" + " " + s.uniqueID() + (s.isCollected() ? " 't" : " nil") + " \"" + s.value() + "\")");
    }

    static LispForm getObjectRep(ObjectReference o, ObjectStore store) {
        return Rep.getObjectRep(o, store, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LispForm getObjectRep(ObjectReference o, ObjectStore store, boolean detailed) {
        String string;
        if (o == null) {
            return new LispForm("(list \"null\")");
        }
        store.put(o);
        if (detailed) {
            String string2;
            String fieldsValuesString;
            try {
                fieldsValuesString = Rep.getFieldValueMapRep(o.getValues(o.referenceType().visibleFields()), store).toString();
            }
            catch (ClassNotPreparedException ex) {
                fieldsValuesString = "\"The class isn't prepared\"";
            }
            catch (ObjectCollectedException ex) {
                fieldsValuesString = "\"The object has already been collected\"";
            }
            catch (Exception ex) {
                fieldsValuesString = "\"Unable to access fields and values. Optimized class?\"";
            }
            StringBuffer stringBuffer = new StringBuffer().append("(list ").append("\"").append(o.referenceType().name()).append("\"").append(" ").append(o.uniqueID());
            if (o.isCollected()) {
                string2 = " 't";
                return new LispForm(stringBuffer.append(string2).append(Protocol.BR).append(fieldsValuesString).append(")").toString());
            }
            string2 = " nil";
            return new LispForm(stringBuffer.append(string2).append(Protocol.BR).append(fieldsValuesString).append(")").toString());
        }
        StringBuffer stringBuffer = new StringBuffer().append("(list ").append("\"").append(o.referenceType().name()).append("\"").append(" ").append(o.uniqueID());
        if (o.isCollected()) {
            string = " 't";
            return new LispForm(stringBuffer.append(string).append(")").toString());
        }
        string = " nil";
        return new LispForm(stringBuffer.append(string).append(")").toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LispForm getObjectMonitorsRep(ObjectReference o, ObjectStore store) {
        String string;
        String waitingThreadsString;
        String owningThread;
        if (o == null) {
            return new LispForm("null");
        }
        store.put(o);
        try {
            ThreadReference t = o.owningThread();
            owningThread = t == null ? "nil" : Rep.getThreadRep(t, store).toString();
        }
        catch (IncompatibleThreadStateException ex) {
            owningThread = "\"Information Not Available\"";
        }
        catch (UnsupportedOperationException ex) {
            owningThread = "\"VM has no information\"";
        }
        try {
            waitingThreadsString = "(list";
            List<ThreadReference> waitingThreads = o.waitingThreads();
            Iterator<ThreadReference> it = waitingThreads.iterator();
            while (true) {
                if (!it.hasNext()) {
                    waitingThreadsString = waitingThreadsString + ")";
                    break;
                }
                waitingThreadsString = waitingThreadsString + Protocol.BR + Rep.getThreadRep(it.next(), store);
            }
        }
        catch (IncompatibleThreadStateException ex) {
            waitingThreadsString = "\"Information Not Available\"";
        }
        catch (UnsupportedOperationException ex) {
            waitingThreadsString = "\"VM has no information\"";
        }
        StringBuffer stringBuffer = new StringBuffer().append("(list ").append(o.uniqueID()).append(" ").append("\"").append(o.referenceType().name()).append("\"");
        if (o.isCollected()) {
            string = " 't";
            return new LispForm(stringBuffer.append(string).append(Protocol.BR).append(owningThread).append(Protocol.BR).append(waitingThreadsString).append(")").toString());
        }
        string = " nil";
        return new LispForm(stringBuffer.append(string).append(Protocol.BR).append(owningThread).append(Protocol.BR).append(waitingThreadsString).append(")").toString());
    }

    static LispForm getThreadGroupRep(ThreadGroupReference t, ObjectStore store) {
        store.put(t);
        String rep = "(list \"ThreadGroup\" " + t.uniqueID() + " \"" + t.name() + "\" ";
        List<ObjectReference> list = t.threads();
        Iterator<ObjectReference> it = list.iterator();
        rep = rep + Protocol.BR + "(list";
        while (it.hasNext()) {
            rep = rep + Protocol.BR + Rep.getThreadRep(it.next(), store);
        }
        rep = rep + ")";
        list = t.threadGroups();
        it = list.iterator();
        rep = rep + Protocol.BR + "(list";
        while (it.hasNext()) {
            rep = rep + Protocol.BR + Rep.getThreadGroupRep((ThreadGroupReference)it.next(), store);
        }
        rep = rep + ")";
        rep = rep + ")";
        return new LispForm(rep);
    }

    static LispForm getThreadRep(ThreadReference t, ObjectStore store) {
        return Rep.getThreadRep(t, store, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LispForm getThreadRep(ThreadReference t, ObjectStore store, boolean detailed) {
        String currentContendedMonitorString;
        String ownedMonitorsString;
        String stackString;
        int status = t.status();
        String statusString = "unknown";
        switch (status) {
            case 3: {
                statusString = "waiting on monitor";
                break;
            }
            case 5: {
                statusString = "not started";
                break;
            }
            case 1: {
                statusString = "runnable";
                break;
            }
            case 2: {
                statusString = "sleeping";
                break;
            }
            case 4: {
                statusString = "waiting";
                break;
            }
            case 0: {
                statusString = "zombie";
                break;
            }
            case -1: {
                statusString = "unknown";
                break;
            }
        }
        String stateString = "normal";
        if (t.isAtBreakpoint()) {
            stateString = "suspended at breakpoint";
        } else if (t.suspendCount() > 0) {
            stateString = "suspended by debugger";
        }
        if (!detailed) {
            store.put(t);
            return new LispForm("(list \"Thread\"" + " " + t.uniqueID() + " \"" + t.name() + "\"" + " \"" + statusString + "\"" + " \"" + stateString + "\")");
        }
        try {
            stackString = "(list";
            List<StackFrame> stackFrames = t.frames();
            Iterator<StackFrame> it = stackFrames.iterator();
            int index = 0;
            while (true) {
                if (!it.hasNext()) {
                    stackString = stackString + ")";
                    break;
                }
                stackString = stackString + Protocol.BR + Rep.getStackFrameRep(it.next(), index++);
            }
        }
        catch (IncompatibleThreadStateException ex) {
            stackString = "\"Information Not Available\"";
        }
        try {
            ownedMonitorsString = "(list";
            List<ObjectReference> ownedMonitors = t.ownedMonitors();
            Iterator<ObjectReference> it = ownedMonitors.iterator();
            while (true) {
                if (!it.hasNext()) {
                    ownedMonitorsString = ownedMonitorsString + ")";
                    break;
                }
                ownedMonitorsString = ownedMonitorsString + Protocol.BR + Rep.getObjectRep(it.next(), store);
            }
        }
        catch (IncompatibleThreadStateException ex) {
            ownedMonitorsString = "\"Information Not Available\"";
        }
        catch (UnsupportedOperationException ex) {
            ownedMonitorsString = "\"VM has no information\"";
        }
        catch (ObjectCollectedException ex) {
            ownedMonitorsString = "\"The object has been collected\"";
        }
        try {
            ObjectReference o = t.currentContendedMonitor();
            currentContendedMonitorString = o == null ? "nil" : Rep.getObjectRep(o, store).toString();
        }
        catch (IncompatibleThreadStateException ex) {
            currentContendedMonitorString = "\"Information Not Available\"";
        }
        catch (UnsupportedOperationException ex) {
            currentContendedMonitorString = "\"VM has no information\"";
        }
        catch (ObjectCollectedException ex) {
            currentContendedMonitorString = "\"The object has been collected\"";
        }
        store.put(t);
        return new LispForm("(list \"Thread\"" + " " + t.uniqueID() + " \"" + t.name() + "\"" + " \"" + statusString + "\"" + " \"" + stateString + "\"" + Protocol.BR + stackString + Protocol.BR + ownedMonitorsString + Protocol.BR + currentContendedMonitorString + ")");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LispForm getStackFrameRep(StackFrame s, int index) {
        try {
            Location loc = s.location();
            return new LispForm("(list " + index + " " + "\"" + loc.declaringType().name() + "\" " + "\"" + loc.sourceName() + "\" " + loc.lineNumber() + ")");
        }
        catch (AbsentInformationException ex) {
            return new LispForm("(list \"StackFrame\" " + index + " \"Information not available\")");
        }
    }
}

