package com.iintiip.suncertify.db;

import java.io.*;

/**
 * This class embodies the description of a record from the database. 
 * It describes a record number, a list of Strings which reflect 
 * the values of the fields in, and a description of each field.
 *
 * @version 1.0  11-Sep-1997
 */
public class Record implements Serializable {
  private int recordNumber;
  private String [] values;
  final static char sc = 'A';

  /**
   * This constructor creates a Record object which has null 
   * Strings for its field values.
   *
   * @param recordNumber - the unique number for this record.
   * @param fields - the array of Field objects
   *                             which represent the names and
   *                             lenghts of the fields in this
   *                             Record object.
   */
  public Record(int recordNumber, Field [] fields) {
    this.recordNumber = recordNumber;
    this.values = new String[fields.length];
  }

  /**
   * This constructor creates a Record object that contains 
   * Strings for its field values.
   *
   * @param recordNumber - the unique number for this record.
   * @param fields - the array of Field objects
   *                             which represent the names and
   *                             lenghts of the fields in this
   *                             Record object.
   * @param values - The values for the field values.
   */
  public Record(int recordNumber, Field [] fields, String [] values) {
    this(recordNumber, fields);
    System.arraycopy(values, 0, this.values, 0, values.length);
  }

  /**
   * This method returns the record number associated with this 
   * Record.
   *
   * @returns int - the unique record number of this Record
   */
  public int getRecordNumber() {
    return recordNumber;
  }

  /**
   * This method returns an array of Strings, which reflect the 
   * values of the fields in this DataItem.   
   *
   * @returns String[] - String array of all the field values 
   *                     of this Record.
   */
  public String [] getValues() {
    return values;
  }

  /**
   * This method constructs and returns a String which describes 
   * this Record object in a form suitable for debug output.
   *
   * @returns String - A textual representation of this Record.
   */
  public String toString() {
    StringBuffer rv = new StringBuffer("record " + recordNumber + ":  ");
    for (int i = 0; i < values.length; i++) {
      rv.append(values[i].trim());
      if (i<values.length-1) {
	rv.append(", ");
      }
    }
    return rv.toString();
  }
}
