/* $Id: xdb_odbc.c,v 1.4 2001/03/27 02:24:43 lubos Exp $
 * xdb_odbc.c
 *
 * This code was written by Chuck Youse and Jon Simantov.
 *
 * 11/3/00 - Modified by LP (ABM), port to jabberd 1.2
 */
#include "jabberd.h"
#include "xdb_odbc.h"

/*
 * Store/retrieve user data to/from a ODBC database.
 */

result xdb_odbc_handler(instance i, dpacket p, void *arg)
{
    char *ns, *act, *match;
    xmlnode file, top, data;
    int ret = 0, flag_set = 0;

    log_debug(ZONE,"handling xdb request %s",xmlnode2str(p->x));

    if((ns = xmlnode_get_attrib(p->x,"ns")) == NULL)
        return r_ERR;

    if(j_strcmp(xmlnode_get_attrib(p->x,"type"), "set") == 0)
        flag_set = 1;

    xdbodbc_connect();

    top = file =
      xdbodbc_get(p->id->server,
		  (p->id->user != NULL) ? p->id->user : "");
    if (top == NULL)
      {
	top = file = xmlnode_str("<xdb/>", 6);
	if (top == NULL) return r_ERR;
	if (xdbodbc_set(p->id->server,
			(p->id->user != NULL) ? p->id->user : "", file) < 0)
	  {
	    log_error(p->id->server,
		      "xdb request failed, unable to save user %s",
		      (p->id->user != NULL) ? p->id->user : "");
	    return r_ERR;
	  }
      }

    /* if we're dealing w/ a resource, just get that element */
    if(p->id->resource != NULL)
    {
        if((top = xmlnode_get_tag(top,spools(p->p,"res?id=",p->id->resource,p->p))) == NULL)
        {
            top = xmlnode_insert_tag(file,"res");
            xmlnode_put_attrib(top,"id",p->id->resource);
        }
    }

    /* just query the relevant namespace */
    data = xmlnode_get_tag(top,spools(p->p,"?xdbns=",ns,p->p));

    if(flag_set)
    {
	act = xmlnode_get_attrib(p->x,"action");
	match = xmlnode_get_attrib(p->x,"match");
        if(act != NULL)
        {
            switch(*act)
            {
            case 'i':
                if(data == NULL)
                { /* we're inserting into something that doesn't exist?!?!? */
                    data = xmlnode_insert_tag(top,"foo");
                    xmlnode_put_attrib(data,"xdbns",ns);
                    xmlnode_put_attrib(data,"xmlns",ns); /* should have a top-level xmlns attrib */
                }
                xmlnode_hide(xmlnode_get_tag(data,match)); /* any match is a goner */
                /* insert the new chunk into the existing data */
                xmlnode_insert_tag_node(data, xmlnode_get_firstchild(p->x));
                break;
            default:
                log_warn("xdb_file","unable to handle unknown xdb action '%s'",act);
                return r_ERR;
            }
        }else{
            if(data != NULL)
                xmlnode_hide(data);

            /* copy the new data into file */
            data = xmlnode_insert_tag_node(top, xmlnode_get_firstchild(p->x));
            xmlnode_put_attrib(data,"xdbns",ns);
        }

        /* save the file */
	if (xdbodbc_set(p->id->server, (p->id->user != NULL) ? p->id->user : "", file) < 0)
	  log_error(p->id->server,
		    "xdb request failed, unable to save user %s",
		    (p->id->user != NULL) ? p->id->user : "");
        else
	  ret = 1;
    }else{
      /* a get always returns, data or not */
      ret = 1;

      if(data != NULL)
        { /* cool, send em back a copy of the data */
	  xmlnode_hide_attrib(xmlnode_insert_tag_node(p->x, data),"xdbns");
        }
    }

    xdbodbc_disconnect();

    if(ret)
    {
        xmlnode_put_attrib(p->x,"type","result");
        xmlnode_put_attrib(p->x,"to",xmlnode_get_attrib(p->x,"from"));
        xmlnode_put_attrib(p->x,"from",jid_full(p->id));
        deliver(dpacket_new(p->x), NULL); /* dpacket_new() shouldn't ever return NULL */

	log_debug(ZONE,"sending result %s",xmlnode2str(p->x));

	xmlnode_free(file);

        return r_DONE;
    }else{
        return r_ERR;
    }

} /* end xdb_odbc_handler */

void xdb_odbc(instance i, xmlnode x)
{
    xmlnode config;
    xdbcache xc;

    log_debug(ZONE,"xdb_odbc loading");

    xc = xdb_cache(i);
    config = xdb_get(xc,
		     jid_new(xmlnode_pool(x),"config@-internal"),
		     "jabber:config:xdb_odbc");

    if (!xdbodbc_config_init(config))
    { /* whoops! configuration failed! */
        log_error(ZONE,"[xdb_odbc] configuration failed");
	xmlnode_free(config);
        return;

    } /* end if */

    register_phandler(i, o_DELIVER, xdb_odbc_handler, (void *)0);

} /* end xdb_odbc */

