#ifndef XDB_ODBC_H_INCLUDED
#define XDB_ODBC_H_INCLUDED

#include "xdb_odbc_helper.h"

/*
 * Type definitions
 */

/* a single bound variable in a query definition */
typedef struct query_def_bind_var_struct
{
  struct query_def_bind_var_struct *next;  /* next variable binding */
  struct query_def_bind_var_struct *prev;  /* previous variable binding */
  const char *name;                        /* variable name */
  const char *replace_text;                /* text to replace in query */
  const char *default_value;               /* default value to replace in query */
  int need_escape;                         /* does it need escaping? */
} *query_def_bind_var;

/* Query definition */
typedef struct query_def_struct
{
  pool p;                        /* private memory pool for querydef */
  char *query_text;              /* the query text */
  query_def_bind_var first_var;  /* the first query variable */
  query_def_bind_var last_var;   /* the last query variable */
} *query_def;

/* Single entry in the column map */
typedef struct col_map_entry_struct
{
  struct col_map_entry_struct *next;  /* pointer to next column map entry */
  const char *name;                   /* column variable name */
  int index;                          /* index of column in row results */
} *col_map_entry;

/* Column map */
typedef struct col_map_struct
{
  pool p;                             /* memory pool for column map entries */
  col_map_entry first;                /* first column map entry */
  col_map_entry last;                 /* last column map entry */
} *col_map;

/*
 * Function prototypes
 */

/* xdb_odbc_file.c */
/* Configuration and DB handling */
extern int is_true(const char *str);
extern int is_false(const char *str);
extern int xdbodbc_config_init(xmlnode cfgroot);
extern HDBC *xdbodbc_database(void);
extern void xdbodbc_config_uninit(void);
extern void xdbodbc_connect(void);
extern void xdbodbc_disconnect(void);
extern xmlnode xdbodbc_query_get(const char *name);

/* Database access */
xmlnode xdbodbc_get(char *server, char *user);
int xdbodbc_set(char *server, char *user, xmlnode node);


/* xdb_odbc_querydef.c */
extern query_def xdbodbc_querydef_init(xmlnode qd_root);
extern void xdbodbc_querydef_setvar(query_def qd, const char *name,
				     const char *value);
extern char *xdbodbc_querydef_finalize(query_def qd);
extern void xdbodbc_querydef_free(query_def qd);
extern col_map xdbodbc_colmap_init(xmlnode qd_root);
extern void xdbodbc_colmap_free(col_map cm);
extern int xdbodbc_colmap_index(col_map cm, const char *name);

#endif  /* XDB_ODBC_H_INCLUDED */
