/* $Id: xdb_odbc_helper.h,v 1.2 2001/03/01 01:12:45 lubos Exp $

 * ODBC function wrappers to make life easier

 */



#ifndef XDB_ODBC_HELPER_H_INCLUDED

#define XDB_ODBC_HELPER_H_INCLUDED



/* #include <wchar.h> */

/* #include <infxsql.h> */

/* #include <infxcli.h> */

#include <time.h>

#include <sql.h>

#include <sqlext.h>



/* prototypes taken from the Cybersites Database Caching Layer */



/* connect to the database */

int odbc_init();

HDBC odbc_connect(const char *, const char *, const char *);



/* disconnect from the database */

int odbc_disconnect(HDBC);

int odbc_deinit();



void odbc_mkstmt(HDBC, HSTMT *, const char *);

int odbc_query(HDBC, HSTMT *, const char *);



/* bind parameters and columns */

void odbc_bindparam(HDBC, HSTMT, int, int, void *, int *);

void odbc_bindbigparam(HDBC, HSTMT, int, int, void *, int *, int);

void odbc_bindcol(HDBC, HSTMT, int, void *, int, int *);



/* get and put large binary data */

RETCODE odbc_paramdata(HDBC, HSTMT, void *);

int odbc_getdata(HDBC, HSTMT, int, void *, int, int *);

int odbc_putdata(HDBC, HSTMT, void *, int);



/* run a prepared statement */

int odbc_exec(HDBC, HSTMT, int);



/* fetch a row */

int odbc_fetch(HDBC, HSTMT);

int odbc_fetchonce(HDBC, HSTMT);



/* perform ODBC operations safely, capturing errors */

int odbc_safe(HDBC, HSTMT, RETCODE, int);



/* reset a statement */

void odbc_reset(HDBC, HSTMT);



/* free a statement */

void odbc_free(HDBC, HSTMT);



#endif /* XDB_ODBC_HELPER_H_INCLUDED */

