package com.yci.seb.portal.adapterportlet;

/**
 * A <CODE>AdapterPortletURI</CODE> represents a URI to a specific portlet
 * function. A URI is created through the <CODE>AdapterPortletResponse</CODE>
 * for a specific portlet mode. Then additional parameter can be
 * added to the URI. The complete URI can be converted to a string
 * which is ready for embedding into markup.
 * <P>
 * On top of the parameters, it is possible to add actions to a
 * portlet URI. Actions are portlet-specific activities that need to
 * be performed as result of the incoming request, but before the
 * <CODE>service()</CODE> method of the portlet is called. For example,
 * the PERSONALIZE mode of the portlet is likely to have a "Save"
 * button at the end of its dialog. The "Save" button has to bring
 * the user back to the DEFAULT mode of the portlet, but to save the
 * personalized portlet data, the portlet needs to be able to process
 * the posted data bfore the next markup is generated. This can be
 * achieved by adding a "Save" action to the URI that represents the
 * "Save" button. The respective listener is attached the respective
 * action listener to the portlet response. This listener will be
 * called when the next request comes and one of the portlet URIs
 * where the reason for the request. If more than one URI were part
 * of the response, the listener need to the check the action content.
 * This depends on the definition of the actual action which is the
 * responsibility of the portlet developer.
 * </P>
 * 
 * @version Modificaitons:
 * 	<p>02/15/2002	-	Marcus Mosttler	-	
 *		Created from jetspeed portlet api branch.
 *	<p>03/29/2002	-	Marcus Mosttler -
 *		Added addProfile and addPortlet.
 *	<p>06/13/2002	-	Marcus Mosttler	-
 *		Added setState to allow for the window state to be set on the portlet uri.
 *	<p>06/24/2002	-	Marcus Mosttler	-
 *		Added setPortlet to set the PIID for this URI.  
 *	<p>07/09/2002	-	Marcus Mosttler	-
 *		Added method to append a special controller path.  This was necessary to
 *		include the Tab Controller tab portions of the URI.
 *	<p>08/16/2002	-	Marcus Mosttler	-
 *		Added method to set the uri to be ssl.
 */
public interface AdapterPortletURI
{
    /**
     * Adds the given action to this URI. The action is a
     * portlet-defined implementation of the portlet action interface.
     * It can carry any information. How the information is recovered
     * should the next request be for this URI is at the discretion of
     * the portlet container.
     * <P>
     * Unless an action listener is registered in the portlet descriptor
     * this action will not be delivered.
     * 
     * @param action AdapterPortletAction
     *		the portlet action
     */
    public void addAction(AdapterPortletAction action);
 	/**
 	 * Sets the action for this uri.
 	 *
 	 * @param action String
 	 */ 
	public void addAction(String action);
    /**
     * Adds the given parameter to this URI. A portlet container
     * may wish to prefix the attribute names internally, to preserve
     * a unique namespace for the portlet.
     *
     * @param name java.lang.String
     * 		the parameter name
     * @param value java.lang.String
     *      the parameter value
     */
    public void addParameter(String name, String value);
   	/**
   	 * Adds to the end of the uri path the portlet id 
   	 * for the current portlet processing the request.
   	 * 
   	 * @param portlet java.lang.String
   	 */
	public void addPortlet(String portlet);
   	/**
   	 * Adds to the end of the uri path the portal profile.
   	 * Assumes the profile is a default not role or group.
   	 * 
   	 * @param profile java.lang.String
   	 */
	public void addProfile(String profile);
   	/**
   	 * Adds to the end of the uri path the portal profile.
   	 * 
   	 * @param profileParam java.lang.String
   	 * @param profileName java.lang.String
   	 */
	public void addProfile(String profileParam, String profileName);
/**
 * Adds the special controller path for the current request.
 * 
 * Creation date: (6/19/2002 11:44:53 AM)
 *
 * @param name java.lang.String
 * @param value int
 */
public void appendControllerPath(String name, int value);
/**
 * Adds the special controller path for the current request.
 * 
 * Creation date: (6/19/2002 11:44:53 AM)
 *
 * @param name java.lang.String
 * @param value java.lang.String
 */
public void appendControllerPath(String name, String value);
/**
 * Returns URI minus any query string.
 * 
 * Creation date: (6/13/2002 12:52:45 PM)
 * 
 * @return java.lang.String
 */
String getPathInfo();
   	/**
   	 * Returns the portion of the URI designating the portlet.
   	 * 
   	 * @return java.lang.String
   	 */
   	public String getPortletRootUri();
/**
 * Returns the query parameter string for this URI.
 * 
 * Creation date: (6/13/2002 12:53:32 PM)
 * 
 * @return java.lang.String
 */
String getQueryString();
   	/**
   	 * Returns the host for this URI.
   	 * 
   	 * @return java.lang.String
   	 */
   	public String getUriHost();
   	/**
   	 * Sets the Portlet this URI is for.
   	 * 
   	 * @param portlet java.lang.String
   	 */
	public void setPortlet(String portlet);
    /**
     * Method to specify that a URI should use SSL.
     *
     * @param enable boolean Specifies to enable or disable.
     */
    public void setSSL(boolean enable);
/**
 * Set the window state and add as an action to the URI path info.
 *
 * Creation date: (6/13/2002 11:39:39 AM)
 * 
 * @param newState com.yci.seb.portal.adapterportlet.AdapterPortletWindow.State
 */
public void setState(AdapterPortletWindow.State newState);
    /**
     * Returns the complete URI as a string.
     * The string is ready to be embedded in markup.
     * <P>
     * Once the string has been created, adding more parameters
     * or other listeners will not modify the string. You have to
     * call this method again, to create an updated string.
     *
     * @return java.lang.String
     * 		the encoded URI as a string
     */
    public String toString();
}
