package com.yci.seb.portal.controllers;

//Java
import java.util.*;

//Turbine
import org.apache.turbine.util.RunData;

//Jetspeed
import org.apache.jetspeed.portal.PanedPortletController;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.util.MetaData;

//SEB Portal
import com.yci.seb.portal.adapterportletcontainer.AdapterPortletURIImpl;
import com.yci.seb.portal.controls.JspPanedPortletControl;

/**
 * Enables use of 'n' numbered panes or pages to present the various
 * portlets.  This is used in conjunction with the JspPanedPortletControl.
 *
 * @version Modificaitons:
 * 	<p>01/11/2001	-	Marcus Mosttler	-	Initial Creation.
 * 	<p>06/19/2002	-	Marcus Mosttler	-
 *		Updated getPortletURI to use the AdapterPortletURI to generate
 *		correct URI for SEB.	
 * 	<p>08/1/2002	-	Marcus Mosttler	-
 *		Added fix to savePaneName to clean up UserTemp and Select Tabs
 *		to ensure only 1 tab selected per tier and correct controller path
 *		used.
 *	<p>08/07/2002	-	Marcus Mosttler -
 *		Added logic to add querystring if useQueryString parm provided.
 *	<p>08/13/2002	-	Marcus Mosttler -
 *		Fixed selected tab logic and created constant for "pane-".
 * 	<p>08/15/2002	-	Marcus Mosttler	-
 *		Added check for useSessionState parameter to determine if 
 *		controller, control, and portlet should use their session state or not.
 */
public class JspPanedPortletController 
	extends JspPortletController implements PanedPortletController
{   
    public static final String PARAM_PREFIX = "pane-";
    public static final String DEFAULT_PARAMETER = "pane";
	public static final String CONTROLLER_SHOWTIER = "showtier";
/**
 * Ensure only 1 tab in the list (current tier) is selected.
 * 
 * Creation date: (7/30/2002 7:35:28 PM)
 *
 * @param data RunData
 * @param name String 
 */
protected void cleanTierSelectedTabs(RunData data, String name) 
{
	Object selectedTabs = data.getRequest().getAttribute(JspPanedPortletControl.CONTROL_SELECTEDTABS);
	if(selectedTabs != null)
	{
		if(((Hashtable)selectedTabs).size() > 1)
		{
			if(logger.isDebugEnabled())
				logger.debug("Cleaning selected tabs ...");
				
			Object tabs = data.getRequest().getAttribute(JspPanedPortletControl.CONTROL_TABS);
			if(tabs != null)
			{
				Enumeration tabTitles = ((Hashtable)selectedTabs).keys();
				String curTitle;
				JspPanedPortletControl.PortletTab tab;
				while(tabTitles.hasMoreElements())
				{
					curTitle = tabTitles.nextElement().toString();
					if(!curTitle.equals(name))
					{	//then set to not selected
						int pos = ((Integer)((Hashtable)selectedTabs).get(curTitle)).intValue();
						if(pos+1 <= ((List)tabs).size())
						{
							tab = (JspPanedPortletControl.PortletTab)((List)tabs).get(pos);
							if(tab.isSelected() && tab.getTitle().equals(curTitle))
							{
								tab.setSelected(false);
							}
						}
					}
				}
			}
		}
		data.getRequest().removeAttribute(JspPanedPortletControl.CONTROL_SELECTEDTABS);
	}
}
/**
 * If the passed name is different than the stored name for this parameterName 
 * then remove all other "pane-" parameters if on 1st tier of cards.
 * This is to not keep selected state when leaving the previously selected pane.
 * 
 * Creation date: (7/30/2002 7:35:28 PM)
 *
 * @param data RunData
 * @param name String 
 */
protected void cleanUserTemp(RunData data, String name) 
{
	String paramName = PARAM_PREFIX + getParameterName();
	Object curValue = data.getUser().getTemp(paramName);
	if(curValue != null)
	{	
		Object curTier = data.getRequest().getAttribute(JspPanedPortletControl.CONTROL_TIER);
		if(curTier != null && curTier.toString().equals("1"))
		{
			//remove if starts with pane- (+ parameter value)
			String paramValue = PARAM_PREFIX;
			Hashtable tempStorage = data.getUser().getTempStorage();
			Enumeration keys = tempStorage.keys();
			Object curKey = null;
			while(keys.hasMoreElements())
			{
				curKey = keys.nextElement();			
				if(curKey != null)
				{
					if(logger.isDebugEnabled())
					{
						logger.debug("Checking for " + paramValue + ". Current temp storage key [" 
							+ curKey + " = " + tempStorage.get(curKey) + "]");
					}
					if(curKey.toString().startsWith(paramValue))
					{
						tempStorage.remove(curKey);
						if(logger.isDebugEnabled())
							logger.debug("Removing - " + curKey);
					}
				}
			}
		}
	}
	//FIXME: don't believe this code will ever be reached and don't believe it is necessary
	/*else if(curValue != null && curValue.toString().equals(name))
	{	//remove if equal to the paramName
		Object curTier = data.getRequest().getAttribute(JspPanedPortletControl.CONTROL_TIER);
		if(curTier != null && curTier.toString().equals("1"))
		{
			Hashtable tempStorage = data.getUser().getTempStorage();
			Enumeration keys = tempStorage.keys();
			Object curKey = null;
			while(keys.hasMoreElements())
			{
				curKey = keys.nextElement();			
				if(curKey != null)
				{
					if(logger.isDebugEnabled())
					{
						logger.debug("Checking for " + paramName + ". Current temp storage key [" 
							+ curKey + " = " + tempStorage.get(curKey) + "]");
					}

					if(curKey.toString().equals(paramName))
					{
						tempStorage.remove(curKey);
						if(logger.isDebugEnabled())
							logger.debug("Removing - " + curKey);
					}
				}
			}
		}
	}*/
}
/**
 * Returns the name of the pane selector parameter for this controller
 */
public String getParameterName() 
{
	return getParameterValue() + getPortlets().getName();
}
/**
 * Returns the name of the pane selector parameter for this controller
 */
public String getParameterValue() 
{
	return getConfig().getInitParameter("parameter", DEFAULT_PARAMETER);
}
/**
 * Builds a link object to access a given pane.
 *
 * @param p the pane portlet object
 * @param rundata the rundata for this request
 * @param selected flag to designate if this portlet is currently selected.
 * @return a DynamicURI that can be used to reference the specific 
 * portlet
 */
public org.apache.turbine.util.DynamicURI getPortletURI(Portlet p, RunData rundata)
{
	return getPortletURI(p, rundata, true);
}
/**
 * Builds a link object to access a given pane.
 *
 * @param p the pane portlet object
 * @param rundata the rundata for this request
 * @param selected flag to designate if this portlet is currently selected.
 * @return a DynamicURI that can be used to reference the specific 
 * portlet
 */
public org.apache.turbine.util.DynamicURI getPortletURI(Portlet p, RunData rundata, boolean selected)
{
    String title = p.getTitle();

    //first look for generic navigation parameter, if not present then use default parameter method.
    String parameterName = null;
//    if(rundata.getParameters().containsKey(NAVIGATION_PARAMETER))
//		parameterName = NAVIGATION_PARAMETER;
//	else
    	parameterName = getParameterName();

    if(logger.isDebugEnabled())
    	logger.debug("Using parameterName [ " + parameterName + " ]");
		
    AdapterPortletURIImpl uri = new AdapterPortletURIImpl(rundata);
    //explicitly add the profile to keep the URI in a logical order
    // (host/context/servlet/profile/pane/portlet)
    uri.appendProfile();
    
    uri.removePathInfo(parameterName);
    uri.removeQueryData(parameterName);

    if(MetaData.DEFAULT_TITLE.equals(title))
    {
        uri.appendControllerPath(parameterName, p.getPortletConfig().getPosition());
        if(selected)
        {
	        if(logger.isDebugEnabled())
	        {
	        	logger.debug("Portlet [ " + title + " ] is selected.  Setting Controller Path ... [ " 
		        	+ parameterName + "/" + p.getPortletConfig().getPosition() + " ]");
	        }
	        
			setControllerPath(rundata.getRequest(), 
	  	      parameterName + "/" + p.getPortletConfig().getPosition());
        }
    }
    else
    {
        uri.appendControllerPath(parameterName, title);
        if(selected)
        {
   	        if(logger.isDebugEnabled())
   	        {
	        	logger.debug("Portlet [ " + title + " ] is selected.  Setting Controller Path [ " 
		        	+ parameterName + "/" + title);
   	        }

	        setControllerPath(rundata.getRequest(), parameterName + "/" + title);
        }
    }

	//add showTier to link for tabs in tier to keep them showing.
    if(showTier(rundata))
	{
		if(useQueryString(rundata))
		{
			String query = rundata.getRequest().getQueryString();
			
			if(logger.isDebugEnabled())
				logger.debug("Adding query string: " + query);
				
			StringTokenizer nvps = new StringTokenizer(query, "&");
			String nvp;
			while(nvps.hasMoreTokens())
			{
				nvp = nvps.nextToken();
				int pos = nvp.indexOf("=");
				uri.addQueryData(nvp.substring(0, pos), nvp.substring(pos+1));
			}
		}
		else
		{
			uri.addQueryData(CONTROLLER_SHOWTIER, 
				rundata.getRequest().getParameter(CONTROLLER_SHOWTIER));
		}
	}

    return uri;
}
/**
 * Test whether the selected portlet is considered selected for the current
 * request.
 *
 * @param p the Portlet to check
 * @param rundata the RunData for the request
 * @return true if the portlet is selected, false otherwise
 */
public boolean isSelected(Portlet p, RunData rundata)
{
	boolean result = false;
    String pane = retrievePaneName(rundata);
    boolean searchTitle = false;
    int paneNum = 0;

    if(logger.isDebugEnabled())
    {
    	logger.debug("Checking (portlet [ " + p.getName() + " - " + p.getTitle() 
	    	+ " ] if [ " + pane + " ] is selected or not ...");
    }
    //should we test based on name/title or position
    try
    {
        paneNum = Integer.parseInt(pane);
    }
    catch(Exception e)
    {
        paneNum = 0;
        searchTitle = true;
    }

    // first search in the child titles...
    if(searchTitle == true)
    {
        result = (p.getName().equals(pane) || p.getTitle().equals(pane));
        String paneParam = retrievePaneParam(rundata, pane);
        if(!result && paneParam.equals(NAVIGATION_PARAMETER))
        {	//check if selected again not using the generic param to get pane name.
	        if(logger.isDebugEnabled())
	        	logger.debug("Check if selected again not using the generic param to get pane name.");
	        pane = retrievePaneName(rundata, false);
	        result = (p.getName().equals(pane) || p.getTitle().equals(pane));
        }
        else if(result && paneParam.equals(NAVIGATION_PARAMETER))
        {
	        saveGenericPane(rundata);
        }
    }
    else
    {   // ...then explicit position parameters...
        if(p.getPortletConfig().getPosition() == paneNum)
        {
            result = true;
        }	
		// sanity check: the position sought should be positive and lower than set size
		else if((paneNum >= getPortlets().size()) || (paneNum < 0))
	    {
	        result = false;
	    }
	    else
	    {   // ...finally test implicit position
	    	result = (getPortlets().getPortletAt(paneNum) == p);
	    }
    }

    return result;
}
/**
 * Returns the name of the pane that should be displayed
 */
public String retrievePaneName(RunData rundata)
{
	return retrievePaneName(rundata, true);
}
/**
 * Returns the name of the pane that should be displayed
 *
 * @param rundata RunData
 * @param checkGenericPara boolean Flag to determine if param "pane" should be checked.
 * @return String name of the selected pane.
 */
public String retrievePaneName(RunData rundata, boolean checkGenericParm)
{
	String parameterName = getParameterName();
    if(logger.isDebugEnabled())
    	logger.debug("Looking for Pane in parameters as [ " + parameterName + " ]");

	Object pane = rundata.getParameters().getString(parameterName);

    if(pane == null)
    {   //look for generic controller navigation parameter.          
	    if(logger.isDebugEnabled())
	    {
	    	logger.debug("Pane not found in parameters.");
	    	if(checkGenericParm)
	    	{
		    	logger.debug("Looking in parameters for generic controller navigation parameter [ " 
			    	+ NAVIGATION_PARAMETER + " ] ");
	    	}
	    }

	    if(checkGenericParm && rundata.getParameters().containsKey(NAVIGATION_PARAMETER))
	    {
		    pane = rundata.getParameters().getObject(NAVIGATION_PARAMETER);
	    }

        if(pane == null)
        {	// the parameter is undefined, search for sticky value in session
		    if(logger.isDebugEnabled() && checkGenericParm)
		    	logger.debug("Pane not found as generic controller navigation parameter.");
		    	
			//If parameter useSessionState present and is true then don't check sticky value.
			if(useSessionState(getConfig(), rundata))
			{
			    if(logger.isDebugEnabled())
			    	logger.debug("Looking in session for sticky value [ pane-" + parameterName + " ] ");
			    	
				//this sticky value is used to note the selected pane			
		     	//(if sub tab requested this will designate which parent pane to select)
			    pane = rundata.getUser().getTemp(PARAM_PREFIX + parameterName);
			}
			
		    if(pane == null)
	        {	// use default
			    if(logger.isDebugEnabled())
			    {
			    	logger.debug("Pane not found in session as sticky value.");
			    	logger.debug("Getting Default Selected Pane");
			    }
			    
 	           	pane = getConfig().getInitParameter("defaultpane", "0");
	        }
        }
    }
    return pane.toString();
}
/**
 * Returns the name of the parameter used to find the pane
 */
protected String retrievePaneParam(RunData rundata, String paneName)
{
	String parameterName = getParameterName();
	String pane = rundata.getParameters().getString(parameterName);
    if(pane == null)
    {
	    pane = rundata.getParameters().getString(NAVIGATION_PARAMETER);
        if(pane == null)
        {
			if(useSessionState(getConfig(), rundata))
			{
			    pane = rundata.getUser().getTemp(PARAM_PREFIX + parameterName).toString();
			    if(pane == null)
	 	           	parameterName = "defaultpane";
		        else
			        parameterName = PARAM_PREFIX + parameterName;
			}
	        else
		        parameterName = "defaultpane";
        }
        else
        {
	        parameterName = NAVIGATION_PARAMETER;
        }
    }
    return parameterName;
}
/**
 * Saves the generic pane value to the user temp storage.
 */
protected void saveGenericPane(RunData rundata)
{
    if(rundata.getParameters().containsKey(NAVIGATION_PARAMETER))
    {
	    Object pane = rundata.getParameters().getObject(NAVIGATION_PARAMETER);
	    if(pane != null)
	    {
		    rundata.getUser().setTemp(PARAM_PREFIX + getParameterName(), pane.toString());
		    rundata.getParameters().remove(NAVIGATION_PARAMETER);
	    }
    }
}
/**
 * Sets the name of the pane that should be displayed
 *
 * @param name the selection parameter name
 */
public void savePaneName(RunData data, String name)
{
	if(logger.isDebugEnabled())
		logger.debug("Saving Pane [" + name + "] ...");
		
	cleanUserTemp(data, name);

	data.getUser().setTemp(PARAM_PREFIX + getParameterName(), name);
	
	if(logger.isDebugEnabled())
		logger.debug("Saved Pane [" + PARAM_PREFIX + getParameterName() + " = " + name + "] ...");
		
	cleanTierSelectedTabs(data, name);
}
/**
 * Sets the name of the pane selector parameter for this controller
 * @param name the new parameter name
 */
public void setParameterName(String name)
{
	getConfig().setInitParameter( "parameter", name );
}
/**
 * Checks for showTier in request parameters, then
 * checks if same as current tier.
 * 
 * Creation date: (7/22/2002 12:44:36 PM)
 * 
 * @param rundata org.apache.turbine.util.RunData
 * @return boolean
 *		True if showTier = curTier
 *		False if showTier <> curTier or showTier not found
 */
public boolean showTier(RunData rundata) 
{
	boolean result = false;
	//check showTier parameter value and current tier value.
	Object showTier = rundata.getRequest().getParameter(CONTROLLER_SHOWTIER);
	if(showTier != null)
	{
		Object curTier = rundata.getRequest().getAttribute(JspPanedPortletControl.CONTROL_TIER);
		if(curTier != null)
		{				
			if(logger.isDebugEnabled())
				logger.debug("Check show tab showTier = " + showTier + " curTier = " + curTier);
				
			if(curTier.toString().equals(showTier.toString()))//if equal set paneState to open
				result = true;
		}
	}				
	return result;
}
/**
 * Checks for useQueryString in request parameters is true.
 * 
 * Creation date: (7/22/2002 12:44:36 PM)
 * 
 * @param rundata org.apache.turbine.util.RunData
 * @return boolean
 *		True if useQueryString = true
 *		False if not. */
public boolean useQueryString(RunData rundata) 
{
	String useQuery = rundata.getRequest().getParameter(
		com.yci.seb.portal.portlets.AppControllerPortlet.PARAM_USEQUERYSTRING);
		
	if(useQuery != null && useQuery.equalsIgnoreCase("true"))
		return true;
	else
		return false;
}
}
