package com.yci.seb.portal.controls;

// Java
import java.util.*;

// Turbine stuff
import org.apache.turbine.util.RunData;

// Jetspeed stuff
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.portal.PanedPortletController;
import org.apache.jetspeed.util.MetaData;

// SEB Portal
import com.yci.seb.portal.controllers.JspPanedPortletController;

/**
 * A JSP based portlet control designed for handling a PortletSet
 * child
 *
 * @version Modificaitons:
 * 	<p>06/14/2002	-	Marcus Mosttler	-	Initial Creation.
 * 	<p>07/19/2002	-	Marcus Mosttler	-
 *		Updated to pass flag for sub tabs and current tier # to template.
 *		Updated to allow for panes to have a state - 
 *		open (always show), closed (don't show by default), hidden (never show).
 *		If current tier equals showTier passed in then change closed to open.
 * 	<p>08/01/2002	-	Marcus Mosttler	-
 *		Updated to add selected tabs for current tier to Map Collection.
 */
public class JspPanedPortletControl extends JspPortletControl
{
	//constants
	public static final String CONTROL_TABS = "tabs";
	public static final String CONTROL_HASSUBTABS = "hasSubTabs";
	public static final String CONTROL_TIER = "tier";
	public static final String CONTROL_SELECTEDTABS = "selectedTabs";
	public static final String PORTLET_PANESTATE = "paneState";
	public static final String PORTLET_PANESTATE_OPEN = "open";
	public static final String PORTLET_PANESTATE_CLOSED = "closed";
	public static final String PORTLET_PANESTATE_HIDDEN = "hidden";
	
    /** 
     * Utilty class describing a Tab elemnt in the template Velocity Context
     */
    public class PortletTab implements com.yci.seb.portal.services.jsp.portaltags.Selectable
    {
        private String title = null;
        private boolean selected = false;
        private String link = null;
        private List actions = null;

        private boolean hasSubTabs = false;
        
        public String getTitle()
        {
            return this.title;
        }
        
        public void setTitle(String title)
        {
            this.title = title;
        }
        
        public boolean isSelected()
        {
            return this.selected;
        }
        
        public void setSelected(boolean selected)
        {
            this.selected = selected;
        }
        
        public String getLink()
        {
            return this.link;
        }
        
        public void setLink(String link)
        {
            this.link = link;
        }
        
        public List getActions()
        {
            return (this.actions==null)?new Vector():this.actions;
        }
        
        public void setActions(List actions)
        {
            this.actions = actions;
        }

        public void setHasSubTabs(boolean subTabs)
        {
	        hasSubTabs = subTabs;
        }
        public boolean getHasSubTabs()
        {
	        return hasSubTabs;
        }
    }
    /**
     * NOTE: this overridden since we do not want actions for tabs 
     * at this time.
     * <p> 
     * Builds a list of possible window actions for this portlet
     * instance. For best results, the portlet should also implement the
     * PortletState interface.
     *
     * @param rundata the request RunData
     * @param the portlet instance managed by this control
     * @return a list of ordered PortletAction objects describing the
     * the actions available for this portlet
     */
    protected List buildActionList(RunData rundata, Portlet portlet)
    {
        return new Vector(0);
    }
    /**
     * This method adds the control specific objects to the 
     * Request context
     *
     * @param rundata the RunData object for this request
     */
    protected void buildContext(RunData rundata) 
    {
        if (getPortlet() instanceof PortletSet)
        {   //Add count of tier depth by increasing by 1 the tier in the request.
            Object inTier = rundata.getRequest().getAttribute(CONTROL_TIER);
            String tier;
            if(inTier != null)
            {
	            rundata.getRequest().removeAttribute(CONTROL_TIER);
	            int outTier = Integer.parseInt(inTier.toString());
            	tier = Integer.toString(++outTier);
            }
            else
            	tier = "1";
            rundata.getRequest().setAttribute(CONTROL_TIER, tier);

            //Get collection of tabs to render.
            rundata.getRequest().setAttribute(CONTROL_TABS, 
		        getTabs((PortletSet)getPortlet(), rundata) );
        }
    }
    /**
     * This method removes the control specific objects from the 
     * Request context
     *
     * @param rundata the RunData object for this request
     */
    protected void clearContext(RunData rundata)
    {
        if (getPortlet() instanceof PortletSet)
        {
            rundata.getRequest().removeAttribute(CONTROL_TABS);
            rundata.getRequest().removeAttribute(CONTROL_HASSUBTABS);
			
			//NOTE: This may not be necessary since the original request
			// is not able to be updated by the include.
            Object inTier = rundata.getRequest().getAttribute(CONTROL_TIER);
            if(inTier != null)
            {
	            rundata.getRequest().removeAttribute(CONTROL_TIER);
	            int outTier = Integer.parseInt(inTier.toString());
	            if(outTier > 1)
	            {
	            	String tier = Integer.toString(--outTier);
		            if(logger.isDebugEnabled())
		            	logger.debug("Tier updated to [ " + tier + " ]");
	            	rundata.getRequest().setAttribute(CONTROL_TIER, tier);
	            }
            }
        }
    }
/**
 * Retrieves the pane state for the current portlet/portletset.
 * if the panestate is closed then check for showTier parameter in request.
 * if found match value with current tier, if equal then show all tabs in the current
 * set unless their panestate is hidden.
 * 
 * Creation date: (7/31/2002 5:45:09 AM)
 * 
 * @param curPortlet Portlet
 * @param controller com.yci.seb.portal.controllers.JspPanedPortletController
 * @param rundata RunData
 * @return java.lang.String
 */
protected String getPaneState(Portlet curPortlet, JspPanedPortletController controller, RunData rundata) 
{
    //FIXME: this doesn't work with current jetspeed cvs version.  fix was submitted.
    //paneState = curPortlet.getAttribute(PORTLET_PANESTATE, PORTLET_PANESTATE_OPEN, rundata);
    String paneState = curPortlet.getPortletConfig()
    	.getInitParameter(PORTLET_PANESTATE, PORTLET_PANESTATE_OPEN);

	if(paneState.equals(PORTLET_PANESTATE_CLOSED))
	{	//check showTier parameter value and current tier value.
		if(controller.showTier(rundata))				  //if equal set paneState to open
			paneState = PORTLET_PANESTATE_OPEN;
		else											  //if not equal set paneState to hidden
			paneState = PORTLET_PANESTATE_HIDDEN;
	}
    return paneState;
}
    /**
     * Populate a list of tabs that should be displayed by this control.
     * Each tab represents a child portlet.
     *
     * This method works best if the child of this control is a PortletSet
     * whose controller implements the PanedPortletController interface.
     * 
     * @param portlet PortletSet the base portlet to explore for children
     * @param rundata RunData
     */
    private List getTabs( PortletSet portlets, RunData rundata )
    {
        Vector tabs = new Vector();
        
        //if PortletSet, retrieve Controller, need PanedPortletController to work properly.
        JspPanedPortletController controller = null;
        if(portlets.getController() instanceof PanedPortletController)
            controller = (JspPanedPortletController)portlets.getController();
        else
        	return tabs;
        
		Portlet curPortlet = null;
		PortletTab tab = null;
        String paneState;
        boolean noTabSelected = true;

        Hashtable selectedTabs = new Hashtable(1);

        for(Enumeration en = portlets.getPortlets(); en.hasMoreElements();)
        {
            curPortlet = (Portlet)en.nextElement();
            
            // skip any closed portlet
            if((curPortlet instanceof PortletState) && (((PortletState)curPortlet).isClosed(rundata)))
            {
	            if(logger.isDebugEnabled())
					logger.debug("Portlet is closed and will be skipped");					
                continue;
            }
            paneState = getPaneState(curPortlet, controller, rundata);
                    
			tab = new PortletTab();
			tab.setTitle( (curPortlet.getTitle() != null) ? curPortlet.getTitle() : curPortlet.getName() );                
            tab.setSelected(controller.isSelected(curPortlet, rundata));
            tab.setLink(controller.getPortletURI(curPortlet, rundata, tab.isSelected()).toString());
                        
            if(logger.isDebugEnabled())
            {
				logger.debug("Portlet [ " + tab.getTitle() + " ] paneState [ " 
					+ paneState + " ] class [ " + curPortlet + " ] is selected = " + tab.isSelected());
            }
				
			//only add to tab collection if its state is open and it has a non-default title.
			if( (tab.getTitle() != null && !MetaData.DEFAULT_TITLE.equalsIgnoreCase(tab.getTitle()))
	            && paneState.equals(PORTLET_PANESTATE_OPEN))
            {
	            tab.setActions(buildActionList(rundata, curPortlet));
	            
	            if(curPortlet instanceof com.yci.seb.portal.controls.JspPanedPortletControl)
	            {
	  	  			tab.setHasSubTabs(true);
			  	  	if(tab.isSelected())
			  	  	{
				  	  	noTabSelected=false;
				  	  	setRequestHasSubTabs(rundata, Boolean.TRUE.toString());  	  	
			  	  	}	            	            	
	            }
	  	  		else
	  	  		{
		  	  		tab.setHasSubTabs(false);
	  	  		}		  	  		
	            tabs.addElement(tab);
            }
            
            if(tab.isSelected())
            	selectedTabs.put(tab.getTitle(), new Integer(tabs.size()-1));
        }        
        if(selectedTabs.size() > 1)
        {
	        rundata.getRequest().setAttribute(CONTROL_SELECTEDTABS, selectedTabs);
        }
        if(noTabSelected)
		{
			setRequestHasSubTabs(rundata, Boolean.FALSE.toString());
		}
        if(logger.isDebugEnabled())
        	logger.debug("Has Sub Tabs = " + rundata.getRequest().getAttribute(CONTROL_HASSUBTABS));
        
        return tabs;
    }
/**
 * Sets the request variable for hasSubTabs
 * 
 * Creation date: (7/22/2002 7:21:41 AM)
 * 
 * @param rundata org.apache.turbine.util.RunData
 * @param hasSubTabs String
 */
protected void setRequestHasSubTabs(RunData rundata, String hasSubTabs) 
{
 	if(rundata.getRequest().getAttribute(CONTROL_HASSUBTABS) != null)
		rundata.getRequest().removeAttribute(CONTROL_HASSUBTABS);

	rundata.getRequest().setAttribute(CONTROL_HASSUBTABS, hasSubTabs);
}
}
