package com.yci.seb.portal.controls;

//SEB Adapter Portal
import com.yci.seb.portal.adapterportlet.AdapterPortlet;

// Jetspeed stuff
import org.apache.jetspeed.portal.controls.AbstractPortletControl;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletControl;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.portal.PortletCustomizer;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.util.template.JetspeedTool;

// Turbine stuff
//import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.RelativeDynamicURI;
import org.apache.turbine.services.jsp.*;
import org.apache.turbine.services.servlet.*;
import org.apache.turbine.services.TurbineServices;

// Ecs stuff
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;

//Java
import javax.servlet.*;
import java.util.List;
import java.util.Vector;
import java.util.Iterator;

/**
 * A JSP based portlet control which implements all PortletState action
 *
 * <p>To use this control you need to define in your registry the following
 * entry or similar:</p>
 * <pre>
 *   <portlet-control-entry name="TitlePortletControl">
 *     <classname>com.yci.seb.portal.controls.JspPortletControl</classname>
 *     <meta-info>
 *       <title>TitleControl</title>
 *       <description>The standard Jetspeed boxed control</description>
 *     </meta-info>
 *     <parameter name="theme" value="default.jsp"/>
 *     <parameter name="showTitle" value="true"/>
 *     <media-type ref="html"/>
 *   </portlet-control-entry>
 * </pre>
 * 
 * @version Modificaitons:
 * 	<p>01/25/2002	-	Marcus Mosttler	-	Initial Creation.
 *	<p>03/26/2002	-	Marcus Mosttler	-
 *		Updated to pass controlConfig to template.
 */
public class JspPortletControl extends AbstractPortletControl
{
    /**
	 * Used to provide logging capabilities via Log4J.
	 */
	protected static org.apache.log4j.Logger logger;
	
	/** 
     * This utility class is used to give information about the actions 
     * available in a control theme template
     */
    public class PortletAction
    {
        String name = null;
        String link = null;
    
        protected PortletAction( String name )
        {
            this.name = name;
        }
        
        public String getName()
        {
            return this.name;
        }
        
        public String getLink()
        {
            return this.link;
        }
        
        public void setLink(String link)
        {
            this.link=link;
        }
    }
	public JspPortletControl()
	{
		super();
		logger = org.apache.log4j.Logger.getLogger(this.getClass().getName());
	}
    /** 
     * Builds a list of possible window actions for this portlet
     * instance. For best results, the portlet should also implement the
     * PortletState interface.
     *
     * @param rundata the request RunData
     * @param the portlet instance managed by this control
     * @return a list of ordered PortletAction objects describing the
     * the actions available for this portlet
     */
    protected List buildActionList( RunData rundata, Portlet portlet )
    {
     	List actions = new Vector(0);
		//FIXME: need to complete building action list for new AdapterPortlets.
//	    if(portlet instanceof AdapterPortlet)
	    	//actions = getAdapterActions();
//	    else
     		actions = getLegacyActions(rundata, portlet);
     	
                
        // Now that we know which actions should be displayed,
        // build the links and put it in the context
        Iterator i = actions.iterator();
                
        while( i.hasNext() )
        {
            PortletAction action = (PortletAction)i.next();
                    
            action.setLink(new RelativeDynamicURI(rundata)
	            .addQueryData("action", getAction(action.getName()))
                .addQueryData("portlet", portlet.getName())
                	.toString());
        }
        
        return actions;
    }
    /**
     * This method adds the control specific objects to the 
     * Request context
     *
     * @param rundata the RunData object for this request
     */
    protected void buildContext(RunData rundata)
    {
	    // empty, used by subclasses to populate the context
    }
    /**
     * This method removes the control specific objects from the 
     * Request context
     *
     * @param rundata the RunData object for this request
     */
    protected void clearContext(RunData rundata)
    {
	    // empty, used by subclasses to populate the context
    }
    /**
     * This method allows subclasses of the JspPortletControl
     * to populate the context of this control before rendering by
     * the template engine.
     *
     * @param rundata the RunData object for this request
     * @param context the Context used by the template
     */
//    public void buildContext( RunData rundata, Context context )
//    {
//        // empty, used by subclasses to populate the context
//    }
    /** 
     * Transforms an Action name in Turbine valid action name, by
     * adding a controls package prefix and capitalizing the first
     * letter of the name.
     */
    protected static String getAction( String name )
    {
        StringBuffer buffer = new StringBuffer("controls.");
        
        buffer.append(name.substring(0, 1).toUpperCase());
        buffer.append(name.substring(1, name.length()));
        
        return buffer.toString();
    }
    /**
     * Handles the content generation for this control using JSP
     */
    public ConcreteElement getContent(RunData rundata)
    {
        Portlet portlet = getPortlet();
        JetspeedRunData jdata = (JetspeedRunData)rundata;
      
 		//place data on request needed by the control view template.
        rundata.getRequest().setAttribute("controlActions", 
        	buildActionList(rundata, portlet).iterator());
        rundata.getRequest().setAttribute("controlSkin",         	
	        portlet.getPortletConfig().getPortletSkin());       
        rundata.getRequest().setAttribute("controlConfig", getConfig());

        if(logger.isDebugEnabled())
        {
			logger.debug("Using Control Portlet Skin [ " 
				+ portlet.getPortletConfig().getPortletSkin().getName() + " ]");
        }

        if( portlet.getName().equals(jdata.getCustomized())
        	&& (!(portlet instanceof PortletCustomizer)) )
        {            
            rundata.getRequest().setAttribute("portlet", JetspeedTool.getCustomizer(portlet));
        }
        else
        {
            rundata.getRequest().setAttribute("portlet", portlet);
        }
            
        // allow subclasses to add elements to the request context
        buildContext(rundata);
        
        String theme = getConfig().getInitParameter("theme", "default.jsp");

        String errorString = "";
        try 
        {
            String template = TemplateLocator.locateControlTemplate(rundata, theme);
        
            JspService service = (JspService)TurbineServices.getInstance()
				.getService(JspService.SERVICE_NAME);
            //this is only necessary if we ddon't run in a JSP page environment
            //but better be safe than sorry...
            service.addDefaultObjects(rundata);
            
            //handle request
            service.handleRequest(rundata, template);
            
	        //Clean up the request attributes.
	        rundata.getRequest().removeAttribute("controlActions");            
	        rundata.getRequest().removeAttribute("controlSkin");
   	        rundata.getRequest().removeAttribute("controlConfig");            
	        rundata.getRequest().removeAttribute("portlet");

	        // allow subclasses to remove elements from the request context
	        clearContext(rundata);
	        
	    }
        catch( Exception e )
        {
            errorString = e.toString();
        }
        return new StringElement(errorString);
    }
	/**
	 * Insert the method's description here.
	 * Creation date: (4/15/2002 12:46:08 PM)
	 * @param rundata org.apache.turbine.util.RunData
	 * @param portlet org.apache.jetspeed.portal.Portlet
	 */
	protected List getLegacyActions(RunData rundata, Portlet portlet) 
	{
		List actions = new Vector(0);
		JetspeedRunData jdata = (JetspeedRunData)rundata;

	    // list the available actions for this portlet
	    if(portlet instanceof PortletState)
	    {            
			// the portlet is state aware
	  		PortletState state = (PortletState)portlet;
	        boolean customized = (jdata.getMode()==jdata.CUSTOMIZE);
	        boolean maximized = customized||(jdata.getMode()==jdata.MAXIMIZE);
                    
            if ( state.allowCustomize( rundata ) )
            {
                if (! customized )
                {
                    actions.add( new PortletAction("customize") );
                }
            }
            else
            {
                if ( state.allowInfo( rundata ) )
                {
                    actions.add( new PortletAction("info") );
                }
            }
                       
            if ( (!customized) && (!maximized) && state.allowClose( rundata ) )
            {
                actions.add( new PortletAction("close") );
            }
            
            if ( state.isMinimized( rundata ) || maximized )
            {
                actions.add( new PortletAction("restore") );
            }
            else
            {
                if ( state.allowMinimize( rundata ) )
                {
                    actions.add( new PortletAction("minimize") );
                }

                if ( state.allowMaximize( rundata ) )
                {
                    actions.add( new PortletAction("maximize") );
                }
            }
        }
        else
        {
            // the portlet only knows about edit and maximize
            if ( portlet.getAllowEdit( rundata ) )
            {
                actions.add( new PortletAction("info") );
            }
        
            if ( portlet.getAllowMaximize( rundata ) )
            {
                actions.add( new PortletAction("maximize") );
            }
        }
        return actions;
	}
    /** 
     * Disable content caching 
     */
    public boolean isCacheable()
    {
        return false;
    }
}
