/*
 * The contents of this file are subject to the JOnAS Public License Version 
 * 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License on the JOnAS web site.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific terms governing rights and limitations under 
 * the License.
 *
 * The Original Code is JOnAS application server code released July 1999.
 *
 * The Initial Developer of the Original Code is Bull S.A.
 * The Original Code and portions created by Bull S.A. are
 *    Copyright (C) 1999 Bull S.A. All Rights Reserved.
 *
 * Contributor(s): Jeff Mesnil
 *
 * --------------------------------------------------------------------------
 * $Id: $
 * --------------------------------------------------------------------------
 */

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException ;
import javax.transaction.UserTransaction;
import javax.rmi.PortableRemoteObject;

import sb.Op ;
import sb.OpHome ;

/**
 * This servlet is an example to show how to access a EJB from a servlet
 */
public class ServletOP extends HttpServlet {

    public void doGet(HttpServletRequest request,
                      HttpServletResponse response)
        throws IOException, ServletException
    {
	response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
	out.println("<title>Sample of Servlet accessing a protected EJB</title>");
        out.println("</head>");
        out.println("<body style=\"background : white; color : black;\">");
	out.println("<h1>Sample of Servlet accessing a protected EJB</h1>");
	out.println("<img src=\"images/tomcat.gif\" alt=\"Tomcat Logo\">") ;
	out.println("<img src=\"images/FinalLogo.jpg\" alt=\"JOnAS Logo\">") ;
	out.println("<h2>Actions realized by the servlet and the EJB</h2>") ;
	out.println("<ul>") ;
	Context initialContext = null;
	try {
	    initialContext = new InitialContext();
	} catch (Exception e) {
	    out.println("<li>Cannot get initial context for JNDI: " + e +"</li>");
	    return ;
	}
		// We want to start transactions from client: get UserTransaction
	UserTransaction utx = null;
	try {
	     utx = (UserTransaction) 
		PortableRemoteObject.narrow(initialContext.lookup("javax.transaction.UserTransaction"),
					    UserTransaction.class);
	} catch (Exception e) {
	    out.println("<li>Cannot lookup UserTransaction: "+e+"</li>");
	    return ;
	}
	// Connecting to OpHome thru JNDI
	OpHome home = null;
	try {
	       home = (OpHome)PortableRemoteObject.narrow(initialContext.lookup("OpHome"),
							  OpHome.class);
	} catch (Exception e) {
	    out.println( "<li>Cannot lookup OpHome: " + e+"</li>");
	    return ;
	}
	// OpBean creation
	Op t1 = null;
	try {	   
	    t1 = home.create("User1"); 
	    out.println("<li>Create a bean</li>");
	} catch (Exception e) {
	    out.println("<li>Cannot create OpBean: " + e+"</li>");
	    return ;
	}
	// First transaction (committed)
	try { 
	    out.println("<li>Start a first transaction</li>");
	    utx.begin();
	    t1.buy(10);
	    out.println("<li>First request on the new bean</li>");
	    t1.buy(20);
	    out.println("<li>Second request on the bean</li>");
	    utx.commit();
	    out.println("<li>Commit the transaction</li>");
	} catch (Exception e) {
	    out.println("<li>exception during 1st Tx: " + e+"</li>");
	    return ;
	}
	// Start another transaction (rolled back)
	try {
	    out.println("<li>Start a second transaction</li>");
	    utx.begin();
	    t1.buy(50);
	    utx.rollback();
	    out.println("<li>Rollback the transaction</li>");
	} catch (Exception e) {
	    out.println("<li>exception during 2nd Tx: " + e+"</li>");
	    return ;
	}
	// Get the total bought, outside the transaction
	int val = 0;
	try {
	    val = t1.read();
	    out.println("<li>Request outside any transaction</li>");
	} catch (Exception e) {
	    out.println("<li>Cannot read value on t1 : "+e+"</li>");  
	    return ;
	}
	if (val != 10+20) {
	    out.println("<li>Bad value read: "+val+"</li>");
	    return ;
	}
	// Remove Session bean
	try {
	    t1.remove();
	} catch (Exception e) {
	    out.println("<li>Exception on buy: "+e+"</li>");
	    return ;
	}
	out.println("</ul><br />") ;
	out.println("<strong>Sample is OK.</strong><br />");
	out.println("</body>");
	out.println("</html>");
    }
}
