// UserBean.java
// Entity Bean

package tests.ejb.bugs.chang;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBObject;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.deployment.ControlDescriptor;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.NotSupportedException;
import javax.transaction.Status;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

import org.objectweb.jonas.common.Trace;


/**
 *
 */
public class UserBean implements EntityBean {

    static private final int trace = Trace.DB_1;
    EntityContext ejbContext;

    // ------------------------------------------------------------------
    // State of the bean. 
    // They must be public for Container Managed Persistance.
    // ------------------------------------------------------------------
    public int field1;
    public int field2;
    public String field3;

    // ------------------------------------------------------------------
    // EntityBean implementation
    // ------------------------------------------------------------------

    /**
     * Set the associated entity context. The container invokes this method 
     * on an instance after the instance has been created.
     * This method is called in an unspecified transaction context. 
     * 
     * @param ctx - An EntityContext interface for the instance. The instance
     * should store the reference to the context in an instance variable.
     * @throws EJBException Thrown by the method to indicate a failure caused by a
     * system-level error.
     */
    public void setEntityContext(EntityContext ctx) {
	Trace.outln(trace, "UserBean setEntityContext");
	ejbContext = ctx;
    }

    /**
     * Unset the associated entity context. The container calls this method
     * before removing the instance. 
     * This is the last method that the container invokes on the instance.
     * The Java garbage collector will eventually invoke the finalize() method
     * on the instance.
     * This method is called in an unspecified transaction context.
     *
     * @throws EJBException Thrown by the method to indicate a failure caused by a
     * system-level error.
     */
    public void unsetEntityContext() {
	Trace.outln(trace, "UserBean unsetEntityContext");
	ejbContext = null;
    }
    
    /**
     * A container invokes this method before it removes the EJB object
     * that is currently associated with the instance. This method is
     * invoked when a client invokes a remove operation on the enterprise Bean's
     * home interface or the EJB object's remote interface. This method
     * transitions the instance from the ready state to the pool of available
     * instances. 
     *
     * This method is called in the transaction context of the remove operation.
     * @throws RemoveException  The enterprise Bean does not allow destruction of the object.
     * @throws EJBException - Thrown by the method to indicate a failure caused by a system-level
     * error.
     */
    public void ejbRemove() throws RemoveException {
	Trace.outln(trace, "UserBean ejbRemove");
    }

    /**
     * A container invokes this method to instruct the instance to synchronize
     * its state by loading it state from the underlying database. 
     * This method always executes in the proper transaction context.
     *
     * @throws EJBException Thrown by the method to indicate a failure caused by
     * a system-level error.
     */
    public void ejbLoad() {
	Trace.outln(trace, "UserBean ejbLoad");
    }

    /**
     * A container invokes this method to instruct the instance to synchronize
     * its state by storing it to the underlying database. 
     * This method always executes in the proper transaction context.
     *
     * @throws EJBException Thrown by the method to indicate a failure caused by
     * a system-level error.
     */
    public void ejbStore() throws RemoteException{
	Trace.outln(trace, "UserBean ejbStore");
	if (field2 == 1000)
	    throw new RemoteException("XXXXXXXXXX");
    }
	
    /**
     * There must be an ejbPostCreate par ejbCreate method
     *
     * @throws CreateException Failure to create an entity EJB object.
     */
    public void ejbPostCreate(String name, int f1, int f2) throws CreateException {
	Trace.outln(trace, "UserBean ejbPostCreate");
    }
	
    /**
     * The Entity bean can define 0 or more ejbCreate methods.
     *
     * @throws CreateException Failure to create an entity EJB object.
     * @throws DuplicateKeyException An object with the same key already exists. 
     */
    public java.lang.String ejbCreate(String name, int f1, int f2) throws CreateException, DuplicateKeyException {
	Trace.outln(trace, "UserBean ejbCreate");

	// Init here the bean fields
	field1 = f1;
	field2 = f2;
	field3 = name;

	// In CMP, should return null.
	return null;
    }

    /**
     * A container invokes this method on an instance before the instance
     * becomes disassociated with a specific EJB object.
     */
    public void ejbPassivate() {
	Trace.outln(trace, "UserBean ejbPassivate");
    }

    /**
     * A container invokes this method when the instance is taken out of 
     * the pool of available instances to become associated with a specific 
     * EJB object.
     */
    public void ejbActivate() {
	Trace.outln(trace, "UserBean ejbActivate");
    }
    
    // ------------------------------------------------------------------
    // User implementation
    // ------------------------------------------------------------------


    /**
     * changeUser
     */
    public void changeUser(int val) {
	Trace.outln(trace, "UserBean changeUser val= "+val);
	field2 = val;
    }
}
