// UserManagerBean.java
// Stateless Session bean

package tests.ejb.bugs.chang;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.ejb.EJBObject;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.rmi.PortableRemoteObject;
import java.util.*;
import org.objectweb.jonas.common.Trace;


/**
 *
 */
public class UserManagerBean implements SessionBean {

    static private final int trace = Trace.DB_1;
    SessionContext ejbContext;
    UserHome userHome = null;

    // ------------------------------------------------------------------
    // SessionBean implementation
    // ------------------------------------------------------------------

    /** 
     * Set the associated session context. The container calls this method
     * after the instance creation. 
     * The enterprise Bean instance should store the reference to the context
     * object in an instance variable. 
     * This method is called with no transaction context.
     *
     * @param sessionContext A SessionContext interface for the instance.
     * @throws EJBException Thrown by the method to indicate a failure caused by
     * a system-level error.
     */
    public void setSessionContext(SessionContext ctx) {
	Trace.outln(trace, "UserManagerBean setSessionContext");
	ejbContext = ctx;
    }
	
    /**
     * A container invokes this method before it ends the life of the session object. 
     * This happens as a result of a client's invoking a remove operation, or when a 
     *  container decides to terminate the session object after a timeout. 
     * This method is called with no transaction context. 
     *
     * @throws EJBException Thrown by the method to indicate a failure caused by
     * a system-level error.
     */
    public void ejbRemove() {
	Trace.outln(trace, "UserManagerBean ejbRemove");
    }
	
    /**
     * The Session bean must define 1 or more ejbCreate methods.
     *
     * @throws CreateException Failure to create a session EJB object.
     */
    public void ejbCreate() throws CreateException {
	Trace.outln(trace, "UserManagerBean ejbCreate");
	if(userHome == null){
	    String bName = "UserHome";
	    try {
		Properties env = new Properties();
		env.put(Context.INITIAL_CONTEXT_FACTORY,"org.objectweb.jeremie.libs.services.registry.jndi.JRMIInitialContextFactory");
		env.put(Context.PROVIDER_URL,"jrmi://wake:1952");
		env.put(Context.URL_PKG_PREFIXES, "org.objectweb.jonas.naming");
		InitialContext ctx = new InitialContext(env);
		userHome = (UserHome) PortableRemoteObject.narrow(ctx.lookup(bName), UserHome.class);
	    } catch(Exception e) {
		e.printStackTrace();

	    }
	}
    }

    /**
     * A container invokes this method on an instance before the instance
     * becomes disassociated with a specific EJB object.
     */
    public void ejbPassivate() {
	Trace.outln(trace, "UserManagerBean ejbPassivate");
    }

    /**
     * A container invokes this method when the instance is taken out of 
     * the pool of available instances to become associated with a specific 
     * EJB object.
     */
    public void ejbActivate() {
	Trace.outln(trace, "UserManagerBean ejbActivate");
    }
    
    // ------------------------------------------------------------------
    // UserManager implementation
    // ------------------------------------------------------------------


    /**
     * ChangeUser
     */
    public void changeUser(java.lang.String userId, int val) {
	Trace.outln(trace, "UserManagerBean ChangeUser "+userId+" "+val);
	javax.transaction.UserTransaction trans = this.ejbContext.getUserTransaction();
	try{
	    User user = userHome.findByPrimaryKey(userId);
	    Trace.outln(trace, "UserManagerBean findByPrimaryKey "+userId+" OK");
	    trans.begin();
	    user.changeUser(val);
	    Trace.outln(trace, "UserManagerBean user.changeUser for val = "+val);
	    trans.commit();
	    Trace.outln(trace, "UserManagerBean ChangeUser Transaction commmited");
	}catch(Exception e){
	    Trace.errln("UserManagerBean ChangeUser exception caught "+e);
	    try{
		trans.rollback();
		Trace.outln(trace,"UserManagerBean ChangeUser Transaction rolledback");
	    }catch (Exception e2) { }
	}
                        
    }
}
