// UserManagerClient.java
// mini Client for accessing bean UserManager

package tests.ejb.bugs.chang;

import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

/**
 *
 */
public class UserManagerClient {

    static Context ctx = null; 
    static UserManagerHome home = null;

    public static void main(String[] arg) {

	// Get InitialContext
	try {
	    ctx = new InitialContext();
	} catch (NamingException e) {
	    e.printStackTrace();
	    System.exit(2);
	}

	// Lookup bean home 
	String bName = "UserManagerHome";
	try {
	    home = (UserManagerHome) PortableRemoteObject.narrow(ctx.lookup(bName), UserManagerHome.class);
	} catch(Exception e) {
	    e.printStackTrace();
	    System.exit(2);
	}
	try{
	    UserManager um = home.create();
	    um.changeUser("User1", 30);
	    um.changeUser("User2", 1000);
	}catch(Exception e) {
	    e.printStackTrace();
	    System.exit(2);
	}
    }
}
