#!/bin/sh

# This script needs awk installed.

# $1: IPv6 origin 1. Will be translated by the first Jool instance.
V6_ORIGIN1="$1"
# $2: IPv6 origin 2. Will be translated by the second Jool instance.
V6_ORIGIN2="$2"
# $3: pool6.
POOL6="$3"
# The interface to the outside world.
OUT_INTERFACE=$4

create_namespace() {
	NS="jool$1"
	V6_ORIGIN="$2"
	JOOL_ADDRV4="192.168.${1}.8"
	GLOBAL_ADDRV4="192.168.${1}.1"
	
	echo "NS: $NS"
	echo "  V6_ORIGIN: $V6_ORIGIN"
	echo "  JOOL_ADDRV4: $JOOL_ADDRV4"
	echo "  GLOBAL_ADDRV4: $GLOBAL_ADDRV4"
	
	sudo ip netns add "$NS"
	
	sudo ip link add name "global_to_$NS" type veth peer name "${NS}_to_global"
	sudo ip link set dev "${NS}_to_global" netns $NS
	sudo ip link set dev "global_to_$NS" up
	sudo ip address add "${GLOBAL_ADDRV4}/24" dev "global_to_$NS"
	sudo ip netns exec "$NS" ip link set dev "${NS}_to_global" up
	sudo ip netns exec "$NS" ip address add "${JOOL_ADDRV4}/24" dev "${NS}_to_global"
	
	# Learn the IPv6 link-local addresses that were automatically generated
	GLOBAL_ADDRV6=$(sudo ip -brief addr show scope link dev "global_to_${NS}" \
		| awk '{print $3}' \
		| cut -f1 -d'/')
	JOOL_ADDRV6=$(sudo ip netns exec "$NS" ip -brief addr show scope link dev "${NS}_to_global" \
		| awk '{print $3}' \
		| cut -f1 -d'/')
	
	# Global namespace's IPv6 routing: Send all {src:$V6_ORIGIN, dst:pool6} packets to Jool's namespace
	sudo ip route add "$POOL6" from "$V6_ORIGIN" via "$JOOL_ADDRV6" dev "global_to_${NS}"
	
	# Global namespace's IPv4 routing: Nothing needed for now
	
	# Jool namespace's IPv6 routing: Send all packets to the global namespace
	sudo ip netns exec "$NS" ip -6 route add default via "$GLOBAL_ADDRV6" dev "${NS}_to_global"
	
	# Jool namespace's IPv4 routing: Send all packets to the global namespace
	sudo ip netns exec "$NS" ip -4 route add default via "$GLOBAL_ADDRV4"
	
	# Start Jool
	sudo ip netns exec "$NS" jool instance add --netfilter -6 "$POOL6"
	sudo ip netns exec "$NS" sysctl -w net.ipv6.conf.all.forwarding=1 > /dev/null
	sudo ip netns exec "$NS" sysctl -w net.ipv4.conf.all.forwarding=1 > /dev/null
}

sudo sysctl -w net.ipv6.conf.all.forwarding=1 > /dev/null
sudo sysctl -w net.ipv4.conf.all.forwarding=1 > /dev/null
sudo modprobe jool

create_namespace 1 "$V6_ORIGIN1"
create_namespace 2 "$V6_ORIGIN2"

sudo iptables -t nat -A POSTROUTING -o $OUT_INTERFACE -j MASQUERADE

