#include <linux/autoconf.h>
#include <linux/socket.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/netlink.h>
#include <net/sock.h>
#include <net/netlink.h>

#define MAX_PAYLOAD 1024
#define NETLINK_IB 24
#define GROUP_IB 0

static struct sock *nl_sk = NULL;
static u32 pid=0;


static void nl_ib_data_ready (struct sock *sk, int len)
{
	wake_up_interruptible(sk->sk_sleep);
	printk(KERN_ALERT "fonction callback appelee\n");
	struct sk_buff *skb = NULL;
	struct nlmsghdr *nlh=NULL;
	char * payload;
	
	while ((skb = skb_dequeue(&sk->sk_receive_queue)) != NULL)
	{
		nlh= (struct nlmsghdr *) skb->data;
		payload = NLMSG_DATA(nlh);
	}
	printk(KERN_ALERT "payload = %s\n",payload);
	int ppid = (int) payload;
	printk(KERN_ALERT "ppid = %i\n",ppid);
}


static void set_pid(u32 ppid)
{
	pid = ppid;
}

static void netlink_ib_open()
{
	struct sk_buff *skb = NULL;
	struct nlmsghdr *nlh = NULL;
	int err=0;

	skb = alloc_skb(NLMSG_SPACE(MAX_PAYLOAD),GFP_KERNEL);
	nlh = (struct nlmsghdr *)skb->data;
	nlh = skb_put(skb, NLMSG_ALIGN(1024));
	nlh->nlmsg_pid = 0; // Send from kernel
	nlh->nlmsg_flags = 0;

	strcpy(NLMSG_DATA(nlh), "Greeting from kernel!");
	NETLINK_CB(skb).pid = 0;
	NETLINK_CB(skb).dst_pid = pid; //Multicast => 0
	NETLINK_CB(skb).dst_group = GROUP_IB;// 0 if unicast
	
	printk( KERN_ALERT "Sending data...\n");
	if (pid!=0)
	{
		err = netlink_unicast(nl_sk, skb, pid, GFP_KERNEL);
	}
	//err = netlink_broadcast(nl_sk, skb, 0, GROUP_IB, GFP_KERNEL);
	if (err<0) {
		printk(KERN_ALERT "Error during netlink_broadcast: %i\n",err);
		if (err == -3) {
			printk(KERN_ALERT "No such process\n");
		}
	}
	goto out;

nlmsg_failure:
	printk(KERN_ALERT "Erreuuuur nlmsg_failure\n");

out:
	sock_release(nl_sk->sk_socket);
}

static int __init netlink_ib_module_init(void)
{
	printk(KERN_INFO "Init netlink_ib module\n");
	nl_sk = netlink_kernel_create(NETLINK_IB, GROUP_IB, nl_ib_data_ready, THIS_MODULE);
	if (nl_sk == NULL) {
		printk(KERN_ALERT "Error during netlink_kernel_create");
	}
	//netlink_ib_open();
	return 0;
}

static void __exit netlink_ib_module_exit(void)
{
	printk(KERN_INFO "Unloading netlink_ib module\n");
	sock_release(nl_sk);
}

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("Kernel/User socket for IB support");
module_init(netlink_ib_module_init);
module_exit(netlink_ib_module_exit);
