#include <sys/socket.h>
#include <sys/types.h>
#include <stdio.h>
#include <linux/netlink.h>
#define NETLINK_IB 24
#define GROUP_IB 0
#define MAX_PAYLOAD 1024
struct sockaddr_nl src_addr, dst_addr;
struct nlmsghdr *nlh = NULL;
struct msghdr msg;
struct iovec iov;
int sock_fd;


int main(int argc, char ** argv)
{
	int err;
	sock_fd = socket(AF_NETLINK, SOCK_RAW, NETLINK_IB);
	if (sock_fd<0) {
	        char s[BUFSIZ];
	        sprintf( s, "%s: can't assign fd for socket", argv[0] );
	        perror(s);
	        return -1;
	}

	//memset(&src_addr, 0, sizeof(src_addr));
	src_addr.nl_family = AF_NETLINK;
	src_addr.nl_pad = 0;
	src_addr.nl_pid = getpid();
	src_addr.nl_groups = GROUP_IB; // Multicast

	err = bind(sock_fd, (struct sockaddr*)&src_addr, sizeof(src_addr));
	if (err<0) {
	        char s[BUFSIZ];
        	sprintf( s, "%s: can't bind socket (%d)", argv[0], sock_fd );
	        perror(s);
	        return -1;
	}

	memset(&dst_addr, 0, sizeof(dst_addr));
	nlh = (struct nlhmsghdr *) malloc(NLMSG_SPACE(MAX_PAYLOAD));
	memset(nlh, 0, NLMSG_SPACE(MAX_PAYLOAD));

	iov.iov_base = (void *)nlh;
	iov.iov_len = NLMSG_SPACE(MAX_PAYLOAD);
	msg.msg_name = (void *)&dst_addr;
	msg.msg_namelen = sizeof(dst_addr);
	msg.msg_iov = &iov;
	msg.msg_iovlen = 1;

	printf("Waiting for messages from kernel...\n");
	recvmsg(sock_fd, &msg, 0);
	printf("Message : %s\n", NLMSG_DATA(nlh));
	close(sock_fd);

	return 0;

}
