#include <linux/config.h>
#include <linux/socket.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/netlink.h>
#include <linux/signal.h>
#include <net/sock.h>
#include <linux/kthread.h>
#include <net/netlink.h>
#include <linux/sched.h>

#define NETLINK_IB 24
#define PERSO 43


MODULE_LICENSE("GPL");
MODULE_AUTHOR("Thierry");
MODULE_DESCRIPTION("Kernel/User socket for IB support");

static struct sock *nl_sk = NULL;
int threadid;

static void nl_ib_data_ready (struct sock *sk, int len)
{
	wake_up_interruptible(sk->sk_sleep);
}

static void netlink_ib_open()
{
	allow_signal(SIGTERM);
	struct sk_buff *skb = NULL;
	struct nlmsghdr *nlh = NULL;
	int err;
	u32 pid;
	int nb=0;

//	for(nb=0;nb<5;nb++)
	while(1)
	{
	skb = NULL;
	nlh = NULL;

	//Creation de la netlink socket <=> socket()
	nl_sk = netlink_kernel_create(NETLINK_IB, 0, nl_ib_data_ready, THIS_MODULE);
	
	//Reception des donnees
	skb = skb_recv_datagram(nl_sk, 0, 0, &err);

	nlh = (struct nlmsghdr *)skb->data;
	printk(KERN_INFO "\n%s: message recu dans le noyau: %s\n", __FUNCTION__, NLMSG_DATA(nlh));

	strcpy(NLMSG_DATA(nlh), "Message du kernel =(");
	pid = nlh->nlmsg_pid;
	NETLINK_CB(skb).pid = 0;
	NETLINK_CB(skb).dst_pid = pid;
	NETLINK_CB(skb).dst_group = 0;
	
	//Envoi des donnees
	netlink_unicast(nl_sk, skb, pid, MSG_DONTWAIT);
	sock_release(nl_sk->sk_socket);
	}
	complete_and_exit(&comp,0);
}

static int __init netlink_ib_module_init(void)
{
	printk(KERN_INFO "netlink_ib module: Initialisation de la Netlink Socket\n");
	init_completion(&comp);
        threadid = kthread_run(netlink_ib_open, NULL, "thread open ib netlink");
	return 0;
}

static void __exit netlink_ib_module_exit(void)
{
	wait_for_completion(&comp);
	printk(KERN_INFO "Dechargement de netlink_ib module\n");
}

module_init(netlink_ib_module_init);
module_exit(netlink_ib_module_exit);
