#include <sys/socket.h>
#include <linux/netlink.h>
#define NETLINK_IB 24


#define MAX_PAYLOAD 1024
struct sockaddr_nl src_addr, dst_addr;
struct nlmsghdr *nlh = NULL;
struct msghdr msg;
struct iovec iov;
int sock_fd;

struct netlink_ib_data {
	char	*data;
	int	longueur;
};


int main()
{
	struct netlink_ib_data envoi;
	/* Ouverture de la socket Netlink*/
	sock_fd = socket(PF_NETLINK, SOCK_RAW, NETLINK_IB);

	memset(&src_addr, 0, sizeof(src_addr));
	src_addr.nl_family = AF_NETLINK;
	src_addr.nl_pid = getpid();
	src_addr.nl_groups = 0; // pas de multicast
	bind(sock_fd, (struct sockaddr*)&src_addr, sizeof(src_addr));

	memset(&dst_addr, 0, sizeof(dst_addr));
	dst_addr.nl_family = AF_NETLINK;
	dst_addr.nl_pid = 0; // 0: kernel
	dst_addr.nl_groups = 0;

	nlh = (struct nlhmsghdr *)malloc(NLMSG_SPACE(MAX_PAYLOAD));

	/* on remplit le header du paquet netlink*/
	nlh->nlmsg_len = NLMSG_SPACE(MAX_PAYLOAD);
	nlh->nlmsg_pid = getpid();
	nlh->nlmsg_flags = 0;

	strcpy(NLMSG_DATA(nlh), "Message de l utilisateur");

	iov.iov_base = (void *)nlh;
	iov.iov_len = nlh->nlmsg_len;

	msg.msg_name = (void *)&dst_addr;
	msg.msg_namelen = sizeof(dst_addr);
	msg.msg_iov = &iov;
	msg.msg_iovlen = 1;

	/* On envoi le message */
	sendmsg(sock_fd, &msg, 0);

	/* On ecoute ce que le kernel renvoi */
	memset(nlh, 0, NLMSG_SPACE(MAX_PAYLOAD));
	recvmsg(sock_fd, &msg, 0);
	char * truc = NLMSG_DATA(nlh);
	printf("Message recu dans lespace utilisateur: %s\n", truc);

	close(sock_fd);

	return 0;

}
