#include <linux/config.h>
#include <linux/socket.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/netlink.h>
#include <net/sock.h>
#include <net/netlink.h>

#define NETLINK_IB 24
#define PERSO 43


MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("Kernel/User socket for IB support");

static struct sock *nl_sk = NULL;

static void nl_ib_data_ready (struct sock *sk, int len)
{
	wake_up_interruptible(sk->sk_sleep);
}

static void netlink_ib_open()
{
	struct sk_buff *skb = NULL;
	struct nlmsghdr *nlh = NULL;
	int err, rc;
	u32 pid;

	//Creation de la netlink socket <=> socket()
	nl_sk = netlink_kernel_create(NETLINK_IB, 0, nl_ib_data_ready, THIS_MODULE);
//	struct netlink_ib_data *recept = NULL;
//	strcpy((*recept).data, "Message hihihaha");
//	recept.longueur = sizeof(recept);
	
	//Reception des donnees
	skb = skb_recv_datagram(nl_sk, 0, 0, &err);

	nlh = (struct nlmsghdr *)skb->data;
	printk(KERN_INFO "\n%s: message recu dans le noyau: %s\n", __FUNCTION__, NLMSG_DATA(nlh));

	strcpy(NLMSG_DATA(nlh), "Message du kernel =(");
	//nla_put(skb, PERSO,sizeof(struct netlink_ib_data), &recept);
	pid = nlh->nlmsg_pid;
	//pid=1;
	NETLINK_CB(skb).pid = 0;
	NETLINK_CB(skb).dst_pid = pid;
	NETLINK_CB(skb).dst_group = 0;
	
	//Envoi des donnees
	rc = netlink_unicast(nl_sk, skb, pid, MSG_DONTWAIT);
	printk(KERN_ALERT "rc = %i\n",rc);
	if (rc < 0) {
		printk(KERN_ERR "module_perso: can not broadcast skb (%d)\n", rc);
	}
	sock_release(nl_sk->sk_socket);
}

static int __init netlink_ib_module_init(void)
{
	printk(KERN_INFO "netlink_ib module: Initialisation de la Netlink Socket\n");
	netlink_ib_open();
	return 0;
}

static void __exit netlink_ib_module_exit(void)
{
	printk(KERN_INFO "Dechargement de netlink_ib module\n");
}

module_init(netlink_ib_module_init);
module_exit(netlink_ib_module_exit);
