#ifndef __KVM_H
#define __KVM_H

#include <linux/kvm.h>

#include "sys-wrap.h"

#define CONFIG_X86_64

struct vm {
	int fd;
	int sys_fd;
	int slot;
	int os_size;
	void *vcpu_share;
	void *write_mem;
	u64 write_mem_size;
};

struct vcpu {
	int fd;
	int id;
	void *stack;
	struct vm *vm;
	struct kvm_run		*kvm_run;
};

struct vm *create_vm(void);
void  kvm_register_mem_slot(struct vm *vm, u64 gpa, void *host, u64 size, int dirty_log, int slot);
void kvm_register_mem(struct vm *vm, u64 gpa, void *host, u64 size);
void kvm_register_mem_dirty(struct vm *vm, u64 gpa, void *host, u64 size);

struct vcpu *create_vcpu(struct vm *vm, int vcpu_id);
void vcpu_register_fun(struct vcpu *vcpu, void(*fun)(void));
void vcpu_run(struct vcpu *vcpu);
#endif
