/**
  * LzTLFTextSprite.as
  *
  * @copyright Copyright 2007-2010 Laszlo Systems, Inc.  All Rights Reserved.
  *            Use is subject to license terms.
  *
  * @topic Kernel
  * @subtopic swf9
  * @author Henry Minsky &lt;hminsky@laszlosystems.com&gt;
  */


/**
   Text Sprite implemented using Flash 10 Text Layout Framework API
 */

public class LzTLFTextSprite extends LzSprite {
    #passthrough (toplevel:true) {
    import flash.display.Sprite;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.events.TextEvent;
    import flashx.textLayout.events.*;
    import flashx.textLayout.operations.*;
    import flash.geom.Rectangle;
    import flashx.textLayout.elements.Configuration;
   
    import flashx.textLayout.container.ContainerController;
    import flashx.textLayout.elements.Configuration;
    import flashx.textLayout.elements.IConfiguration;
    import flashx.textLayout.formats.TextLayoutFormat;
    import flashx.textLayout.formats.TextAlign;
    import flash.text.engine.FontPosture;
    import flash.text.engine.Kerning;

    import flashx.textLayout.edit.EditingMode;
    import flashx.textLayout.conversion.TextConverter;
    import flashx.textLayout.formats.Direction;
    
    import flashx.textLayout.container.TextContainerManager;
    import flashx.textLayout.edit.EditManager;
    import flashx.textLayout.elements.ParagraphElement;
    import flashx.textLayout.elements.TextFlow;
    import flashx.textLayout.edit.SelectionState;
    import flashx.textLayout.events.SelectionEvent;
    import flashx.textLayout.edit.ISelectionManager;
    import flashx.textLayout.formats.TextLayoutFormat;
    import flash.text.engine.FontPosture;
    import flashx.undo.UndoManager;
    }#

    #passthrough {

        var font:LzFont = null;

        /**
         * @access private
         */
        public var scroll:Number = 0;
        /**
         * @access private
         */
        public var maxscroll:Number = 0;
        /**
         * @access private
         */
        public var hscroll:Number = 0;
        /**
         * @access private
         */
        public var maxhscroll:Number = 0;
        /**
         * @access private
         */
        public var lineheight:Number = 1;

        public var textcolor:Number = 0;
        public var text:String = "";

        public var resize:Boolean = true;
        public var multiline:Boolean = false;
        public var underline:Boolean = false;
        public var selectable:Boolean = false;
        public var editable:Boolean = false;

        public var textalign:String = "left";
        public var textindent:Number = 0;
        public var letterspacing:Number = 0;
        public var textdecoration:String = "none";

        public var sizeToHeight:Boolean = false;
        public var password:Boolean = false;
        public var scrollheight:Number = 0;
        public var html:Boolean = true;

        var config:Configuration = null;
        var layoutFormat:TextLayoutFormat = null;
        public var direction:String = Direction.LTR;

        ////////////////////////////////////////////////////////////////
        // TODO [hqm 2010-06] TLF objects, these are declared public right now for debugging
        public var editManager:EditManager = null;
        public var undoManager:UndoManager = null;
        public var tcm:LzTextContainerManager;
        public var textFlow:TextFlow;

        public function LzTLFTextSprite (newowner:LzView = null, args:Object = null) {
            super(newowner,false);
            var container:Sprite = new Sprite();
            // add container to the stage; create controller and add it to the text flow
            addChild(container);
            this.config = ((TextContainerManager.defaultConfiguration) as Configuration).clone();
            Debug.info("config.textFlowInitialFormat = ",  config.textFlowInitialFormat);
            layoutFormat =  new TextLayoutFormat(config.textFlowInitialFormat);
            config.textFlowInitialFormat = layoutFormat;
            
            tcm = new LzTextContainerManager(container, null, this);
            tcm.editingMode = EditingMode.READ_SELECT;
            // install event listeners on EditManager or ContainerController

            //            tcm.addEventListener( SelectionEvent.SELECTION_CHANGE, selectionChangeHandler);


            /*
              tfield.addEventListener(TextEvent.LINK, textLinkHandler);
              tfield.addEventListener(MouseEvent.CLICK, handleTextfieldMouse);
              tfield.addEventListener(MouseEvent.DOUBLE_CLICK, handleTextfieldMouse);
              tfield.addEventListener(MouseEvent.MOUSE_DOWN, handleTextfieldMouse);
              tfield.addEventListener(MouseEvent.MOUSE_UP, handleTextfieldMouse);
              tfield.addEventListener(MouseEvent.MOUSE_OVER, handleTextfieldMouse);
              tfield.addEventListener(MouseEvent.MOUSE_OUT, handleTextfieldMouse);
            */
        }

        // This is too late to stop the selection behavior
        function selectionChangeHandler(event:flashx.textLayout.events.SelectionEvent):void {
            Debug.info("selectionChangeHandler",
                       event.selectionState.absoluteStart, event.selectionState.absoluteEnd);

            if (!this.selectable) {
                Debug.info("not selectable, calling event.preventDefault, cancelable:", event.cancelable,
                           "eventphase:", event.eventPhase, 'type:', event.type);
                event.preventDefault();
            }
        }

        function mouseEventHandler(event:MouseEvent):void {


        }


    function textFlow_flowOperationBeginHandler(event:FlowOperationEvent):void
    {
        //trace("operationBegin");
        
        Debug.info("textFlow_flowOperationBeginHandler", event.operation);
        var op:FlowOperation = event.operation;

        // If the user presses the Enter key in a single-line TextView,
        // we cancel the paragraph-splitting operation and instead
        // simply dispatch an 'enter' event.
        if (op is SplitParagraphOperation && !multiline)
        {
            Debug.info("got SplitParagraphOperation");
            event.preventDefault();
        }
        
    }


        private function setTextfieldCursor (lzsprite:LzSprite) :void { }

        override public function setClickable( c:Boolean ):void {
            if (this.clickable == c) return;
            //setShowHandCursor(c);
            this.clickable = c;
        }

        public function addScrollEventListener():void {
            Debug.warn("addScrollEventListener not yet implemented");
            //this.textfield.addEventListener(Event.SCROLL, __handleScrollEvent);
        }

        var scrollevents = false;
        function setScrollEvents(on) {
            this.scrollevents = on;
        }

        function __handleScrollEvent(e:Event = null) :void {
            if (! this.scrollevents) return;
            Debug.warn("__handleScrollEvent not yet implemented");
        }

        public function textLinkHandler(e:TextEvent) :void {
            // ignore the next onclick-event for swf8-compatibility
            // Debug.write("textLinkHandler on %w", this);
            this.owner.ontextlink.sendEvent(e.text);
        }

        public function makeTextLink(str:String, value:String) :String {
            return '<a href="event:'+value+'">'+str+'</a>';
        }

        override public function setWidth( w:Number ):void {
            super.setWidth(w);
            tcm.compositionWidth = w;
            tcm.updateContainer();
            this.__handleScrollEvent();
        }

        override public function setHeight( h:Number ):void {
            super.setHeight(h);
            tcm.compositionHeight = h;
            tcm.updateContainer();
            this.__handleScrollEvent();
        }

        public function __initTextProperties (args:Object) :void {
            //textclip.autoSize = TextFieldAutoSize.NONE;

            //inherited attributes, documented in view

            Debug.info("__initTextProperties", args);

            this.fontname = args.font;
            this.fontsize = args.fontsize;
            this.fontstyle = args.fontstyle;
            this.textcolor = args.fgcolor;
            if (! args.hassetheight) {
                this.sizeToHeight = true;
                //                if (this.multiline) {
                //                    textclip.autoSize = TextFieldAutoSize.LEFT;
                //}
            } else if (args['height'] != null) {
                tcm.compositionHeight = args.height;
            }
            // Default the scrollheight to the visible height.
            this.scrollheight = this.height;

            // TODO [hqm 2008-01] There ought to be only call to
            // __setFormat during instantiation of an lzText. Figure
            // out how to suppress the other calls from setters.

            if (this.sizeToHeight) {
                var h = this.lineheight;
                //TODO [anba 20080602] is this ok for multiline? 
                if (this.multiline) h *= tcm.numLines;
                h += 4;//2*2px gutter, see flash docs for flash.text.TextLineMetrics 
                this.setHeight(h);
            }

            this.__setFormat();
            addScrollEventListener();
            tcm.compose();
            tcm.updateContainer();
            __handleScrollEvent();
        }

        public function setBorder ( onroff:Boolean):void {
        }

        public function setEmbedFonts ( onroff:Boolean ):void {
        }

        /** setDirection
         * sets reading order of text, legal values are 'ltr' and 'rtl'
         * @param dir reading order direction
         */
        public function setDirection (dir:String):void {
            if (dir == "ltr") {
                this.direction = Direction.LTR;
            } else if (dir == "rtl") {
                this.direction = Direction.RTL;
            } else {
                Debug.error('setDirection value "', dir, '" unknown, use "ltr" or "rtl"');
            }
            textFlow.direction = layoutFormat.direction = this.direction;
            tcm.updateContainer();
        }

        /*
         *  setFontSize( Number:size )
         o Sets the size of the font in pixels 
        */
        public function setFontSize ( fsize:Number ):void {
            Debug.info("setFontSize", fsize);
            textFlow.fontSize = layoutFormat.fontSize = fsize;
            tcm.compose();
            tcm.updateContainer();            
        }


        public function setFontStyle ( fstyle:String ):void {
            // FontPosture.NORMAL, for use in plain text, or FontPosture.ITALIC
            layoutFormat.fontStyle = fstyle == 'normal' ? FontPosture.NORMAL : FontPosture.ITALIC;
            textFlow.fontStyle = layoutFormat.fontStyle;
            tcm.updateContainer();            
        }

        /* setFontName( String:name )
           o Sets the name of the font
           o Can be a comma-separated list of font names 
        */
        public function setFontName ( fname:String , prop:*=null):void{
            textFlow.fontFamily = layoutFormat.fontFamily = fname;
            tcm.updateContainer();

        }

        function setFontInfo () :void {
            this.font = LzFontManager.getFont( this.fontname , this.fontstyle );
            //Debug.write('setFontInfo this.font = ', this.font, 'this.fontname = ', this.fontname, this.fontstyle);
        }

        /**
         * Sets the color of all the text in the field to the given hex color.
         * @param Number c: The color for the text -- from 0x0 (black) to 0xFFFFFF (white)
         */
        public function setTextColor ( col:* ):void {
            textFlow.color = layoutFormat.color = col;
            tcm.updateContainer();            
        }

        /**
         * Set the html flag on this text view
         */
        function setHTML (htmlp:Boolean) :void {
        }

        public function appendText( t:String ):void {
            this.text += t;
            textFlow = TextConverter.importToFlow(this.text, TextConverter.TEXT_FIELD_HTML_FORMAT, config);
            textFlow.addEventListener(
                FlowOperationEvent.FLOW_OPERATION_BEGIN,
                textFlow_flowOperationBeginHandler);
            tcm.setTextFlow(textFlow);

            // hqm [2010-06] This call to beginInteraction creates our
            // custom EditManager or SelectionManager, which is the
            // only way I have found to get mouse events, such as
            // mouseOver, mouseOut.
            tcm.beginInteraction();

            tcm.updateContainer();
            if (this.initted) this.owner._updateSize();
        }

        public function getText():String {
            return this.tcm.getText();
        }

        /** setText( String:text )
            o Sets the contents to the specified text
            o Uses the widthchange callback method if multiline is false and text is not resizable
            o Uses the heightchange callback method if multiline is true
        */


        /**
         * setText sets the text of the field to display
         * @param String t: the string to which to set the text
         */
        public function setText ( t:String ):void {
            this.text = t;
            textFlow = TextConverter.importToFlow(t, TextConverter.TEXT_FIELD_HTML_FORMAT, config);
            textFlow.addEventListener(
                FlowOperationEvent.FLOW_OPERATION_BEGIN,
                textFlow_flowOperationBeginHandler);
            tcm.setTextFlow(textFlow);
            // hqm [2010-06] This call to beginInteraction creates our
            // custom EditManager or SelectionManager, which is the
            // only way I have found to get mouse events, such as
            // mouseOver, mouseOut.
            tcm.beginInteraction();

            tcm.updateContainer();
            if (this.initted) this.owner._updateSize();
        }

        /**
         * Sets the format string for the text field.
         * @access private
         */
        public function __setFormat ():void {
            this.setFontInfo();
            var cfontname:String = LzFontManager.__fontnameCacheMap[this.fontname];
            if (cfontname == null) {
                cfontname = LzFontManager.__findMatchingFont(this.fontname);
                LzFontManager.__fontnameCacheMap[this.fontname] = cfontname;
                //Debug.write("caching fontname", this.fontname, cfontname);
            }
            //            Debug.write("__setFormat this.font=", this.font, 'this.fontname = ',this.fontname,
            //'cfontname=', cfontname);

            //SET TCM OR FLOW LAYOUT PROPERTIES?? 

            layoutFormat.fontFamily = cfontname;
            layoutFormat.fontSize = this.fontsize;
            layoutFormat.color = this.textcolor;
            //            textFlow.color = this.color;
            // TODO [hqm 2010-06] need to set all text properties
            // color
            // style
            // indent
            // kerning
            // linespacing
            // 
            // Should we be keeping a flash.textLayout.formats.TextLayoutFormat object around for this?
            if (this.initted) this.owner._updateSize();
        }


        public function setMultiline ( ml:Boolean ):void {
            // TODO [hqm 2008-01] have to figure out how the Flex textfield multiline
            // maps to Laszlo model.
            this.multiline = (ml == true);
            if (this.initted) this.owner._updateSize();
        }


        /**
         * Sets the selectability (with Ibeam cursor) of the text field
         * @param Boolean isSel: true if the text may be selected by the user
         */
        public function setSelectable ( isSel:Boolean ):void {
            if (this.selectable == isSel) return;
            this.selectable = isSel;
            if (this.selectable) {
                tcm.editingMode = EditingMode.READ_SELECT;
            } else {
                tcm.editingMode = EditingMode.READ_ONLY;
            }
        }

        // TODO [2010-06 hqm]  move this to LzTLFInputTextSprite? 
        public function setEditable (isEditable:Boolean):void {
            if (this.editable == isEditable) return;
            this.editable = isEditable;
            if (this.editable) {
                tcm.editingMode = EditingMode.READ_WRITE;
            } else {
                if (this.selectable) {
                    tcm.editingMode = EditingMode.READ_SELECT;
                } else {
                    tcm.editingMode = EditingMode.READ_ONLY;
                }
            }
        }

        public function getTextWidth (force=null):Number {
            var bounds:Rectangle = tcm.getContentBounds();
            return bounds.width;
        }

        public function getLineHeight ( ):Number {
            var bounds:Rectangle = tcm.getContentBounds();
            // TODO [hqm 2010-06] What is the right way to get line height? Ask which format object?
            return bounds.height / tcm.numLines;
        }

        public function getTextfieldHeight (force=null) :Number {
            var bounds:Rectangle = tcm.getContentBounds();
            return bounds.height;
        }


        function setHScroll(s:Number) :void {
            tcm.horizontalScrollPosition = s;
        }

        function setAntiAliasType( aliasType:String ):void {
            if (this.initted) this.owner._updateSize();
        }

        function getAntiAliasType():String {
            return null;
        }

        function setGridFit( gridFit:String ):void{
            if (this.initted) this.owner._updateSize();
        }

        function getGridFit():String {
            return null;
        }

        function setSharpness( sharpness:Number ):void {
        }

        function getSharpness():Number {
            return null;
        }

        function setThickness( thickness:Number ):void{
        }

        function getThickness():Number {
            return null;
        }

        function setMaxLength(val:Number) {
            if (this.initted) this.owner._updateSize();
        }

        function setPattern (val:String) :void {
        }

        function setSelection(start:Number, end:Number) :void {
            var selmgr:ISelectionManager = tcm.beginInteraction();
            if (selmgr != null) {
                selmgr.selectRange(start, end);
            }
        }

        function setResize ( val:Boolean ) :void {
            this.resize = val;
            if (this.initted) this.owner._updateSize();
        }

        function setScroll ( h:Number ) :void {
            this.scroll = h;
            tcm.verticalScrollPosition = h;
        }

        function getScroll() :Number {
            return tcm.verticalScrollPosition;
        }

        function getMaxScroll() :Number {
            // TODO [hqm 2010-06] how do we compute this? controller.getContentBounds() - controller.compositionHeight???
            var bounds:Rectangle = tcm.getContentBounds();
            return Math.max (0, bounds.height - tcm.compositionHeight);
        }

        function getBottomScroll() :Number {
            return 0;
        }

        function lineNoToPixel (n:Number):Number {
            return (n - 1) * lineheight;
        }

        function pixelToLineNo (n:Number):Number {
            return Math.ceil(n / lineheight) + 1;
        }

        function setYScroll (n:Number) :void {
            Debug.warn("setYScroll NYI");
        }

        function setXScroll (n:Number) :void {
            Debug.warn("setXScroll NYI");
        }

        function setWordWrap (wrap:Boolean) :void {
            Debug.warn("LzTLFTextSprite.setWordWrap not yet implemented");
        }

        function getSelectionPosition() :int {
            // TODO [hqm 2010-06] the SelectionState operates on a TextRange
            var selection:SelectionState = textFlow.interactionManager.getSelectionState();
            return selection.absoluteStart;

        }    
        function getSelectionSize() :int {
            var selection:SelectionState = textFlow.interactionManager.getSelectionState();
            return selection.absoluteEnd - selection.absoluteEnd;
        }    

        function setTextAlign (align:String) :void {
        }

        function setTextIndent (indent:Number) :void {

        }

        function setLetterSpacing (spacing:Number) :void {

        }

        function setTextDecoration (decoration:String) :void {

        }

    }#
}


