unit fMain;

{$MODE Delphi}

interface

uses
  LCLIntf,
{$IFDEF fpc}
{$ELSE}
  Messages, ToolWin,
{$ENDIF}
  SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Menus, ExtCtrls, LResources;

type
  TEasyDockMain = class(TForm)
    sb: TStatusBar;
    ToolBar1: TToolBar;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Docker: TPanel;
    buDump: TButton;
    procedure Shape1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure DockerDockDrop(Sender: TObject; Source: TDragDockObject; X,
      Y: Integer);
    procedure DockerMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure DockerDockOver(Sender: TObject; Source: TDragDockObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure buDumpClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  EasyDockMain: TEasyDockMain;

implementation

uses
  fDockable, fTree, EasyDockSite;


procedure TEasyDockMain.Shape1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  df: TDockable;
  shp: TShape;
begin
  if sender is TShape then begin
    shp := Sender as TShape;
    df := TDockable.Create(self);
    df.Color := shp.Brush.Color;
    //df.Name := shp.Name;
    df.Visible := True;
  end;
end;

procedure TEasyDockMain.FormCreate(Sender: TObject);
begin
  Docker.DockManager := TEasyTree.Create(Docker);
  Docker.DockSite := True;
  Docker.UseDockManager := True;
end;

procedure TEasyDockMain.DockerDockDrop(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer);
begin
  sb.SimpleText := 'drop!';
end;

procedure TEasyDockMain.DockerMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  //sb.SimpleText := 'move';
  //Docker.DockManager.
end;

procedure TEasyDockMain.DockerDockOver(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer; State: TDragState;
  var Accept: Boolean);
var
  s: string;
begin
  if DropOn = nil then
    sb.SimpleText := '<drop nowhere>'
  else begin
    s := Format('drop onto %s[%d,%d - %d,%d]', [
      DropOn.Name, DropOn.Top, DropOn.Left, DropOn.Width, DropOn.Height]);
    sb.SimpleText := s;
  end;
end;

procedure TEasyDockMain.buDumpClick(Sender: TObject);
var
  s: TStringStream;
begin
  s := TStringStream.Create('');
  try
    Docker.DockManager.SaveToStream(s);
    DumpBox.Memo1.Text := s.DataString;
  finally
    s.Free;
  end;
  DumpBox.Visible := True;
end;

initialization
  {$i fMain.lrs}
end.

