unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, HTTPDefs, websession, fpHTTP, fpWeb, fphtml,
  fpdatasetform, htmlwriter, sqldb, db, IBConnection, jQueryElements;

type

  { TFPWebModule1 }

  TFPWebModule1 = class(TFPWebModule)
    Datasource1: TDatasource;
    HTMLPageProducer1: THTMLPageProducer;
    IBConnection1: TIBConnection;
    jQueryGrid1: TjQueryGrid;
    jQueryPage1: TjQueryPage;
    SQLQuery1: TSQLQuery;
    SQLTransaction1: TSQLTransaction;
    procedure dataRequest(Sender: TObject; ARequest: TRequest; AResponse: TResponse;
      var Handled: Boolean);
    procedure HTMLPageProducer1WriteHeader(Sender: THTMLContentProducer; aWriter: THTMLWriter);
    procedure HTMLPageProducer1WriteVisualBody(Sender: THTMLContentProducer; aWriter: THTMLWriter);
    procedure HTMLPageProducer1WriteVisualFooter(Sender: THTMLContentProducer; aWriter: THTMLWriter);
    procedure jQueryGrid1CellSubmit(AID: String; AColumn: TColumn; ANewValue : String);
  public
    { public declarations }
  end; 

var
  FPWebModule1: TFPWebModule1; 

implementation

uses htmlelements;

{ TFPWebModule1 }

procedure TFPWebModule1.HTMLPageProducer1WriteVisualFooter(Sender: THTMLContentProducer;
  aWriter: THTMLWriter);
begin
  jQueryPage1.FinalizeHeader;
end;

procedure TFPWebModule1.jQueryGrid1CellSubmit(AID: String; AColumn: TColumn; ANewValue : String);
var AField : TField;
begin
  AField := SQLQuery1.FieldByName(AColumn.FieldName);
  if assigned(AField) then
    begin
    // This is really bad code, do not use this as an example...
    SQLQuery1.RecNo:=StrToInt(AID);
    SQLQuery1.Edit;
    AField.AsString:=ANewValue;
    SQLQuery1.Post;
    SQLQuery1.ApplyUpdates;
    SQLTransaction1.CommitRetaining;
    end;
end;

procedure TFPWebModule1.HTMLPageProducer1WriteHeader(Sender: THTMLContentProducer;
  aWriter: THTMLWriter);

begin
  jQueryPage1.InitialiseHeader(awriter.header(''));
  jQueryPage1.AjaxURL:='fpcjquery.psp?Action=Data';
end;

procedure TFPWebModule1.HTMLPageProducer1WriteVisualBody(Sender: THTMLContentProducer;
  aWriter: THTMLWriter);
begin
  jQueryGrid1.WriteContent(aWriter);
end;

procedure TFPWebModule1.dataRequest(Sender: TObject; ARequest: TRequest; AResponse: TResponse;
  var Handled: Boolean);
begin
  jQueryPage1.HandleRequest(ARequest,AResponse,Handled);
end;

initialization
  {$I unit1.lrs}

  RegisterHTTPModule('TFPWebModule1', TFPWebModule1); 
end.

