{ GTLK2 drop source for DND of files to other applications

  Copyright (C) 2012 Bernd Kreuss <prof7bit@gmail.com>

  This library is free software; you can redistribute it and/or modify it
  under the terms of the GNU Library General Public License as published
  by the Free Software Foundation; either version 2 of the License, or (at
  your option) any later version with the following modification:

  As a special exception, the copyright holders of this library give you
  permission to link this library with independent modules to produce an
  executable, regardless of the license terms of these independent
  modules,and to copy and distribute the resulting executable under terms
  of your choice, provided that you also meet, for each linked independent
  module, the terms and conditions of the license of that module. An
  independent module is a module which is not derived from or based on
  this library. If you modify this library, you may extend this exception
  to your version of the library, but you are not obligated to do so. If
  you do not wish to do so, delete this exception statement from your
  version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library
  General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

{ If we are on GTK2 then we are lucky. GTK2 will handle the complete
  operation of dragging completely autonomous. All that is needed is to
  declare a widget as the drag source and connect a few signals to it
  and then GTK2 will detect the begin of the drag on its own and handle
  everything until the end.
}
unit DragDropGtk2;

{$mode objfpc}{$H+}

interface
uses
  FileDragSource;

function DragStartsAutomatically: Boolean;
procedure MakeDragSource(Src: TFileDragSource; Uninstall: Boolean);


implementation
uses
  Classes,
  glib2,
  gtk2,
  gdk2;

const
  FileDragTarget: TGtkTargetEntry = (
    target: 'text/uri-list';
    flags: 0;
    info: 0;
  );

procedure GtkDragDataGet(GtkW: PGtkWidget;
                      Context: PGdkDragContext;
                      SelData: PGtkSelectionData;
                   TargetType: guint;
                         Time: guint;
                          Src: TFileDragSource); cdecl;
var
  Data: TStringList;
  I: Integer;
  A: array of PChar;
begin
  Data := TStringList.Create;
  Src.CallOnDragGetData(Data);

  SetLength(A, Data.Count);
  for I := 0 to Data.Count - 1 do begin
    Data.Strings[I] := 'file://' + Data.Strings[I];
    A[i] := PChar(Data.Strings[I]);
  end;
  A[Data.Count] := nil;
  gtk_selection_data_set_uris(SelData, @A[0]);

  Data.Free;
end;

procedure GtkDragBegin(GtkW: PGtkWidget;
                    Context: PGdkDragContext;
                        Src: TFileDragSource); cdecl;
begin
  Src.CallOnDragBegin;
end;

procedure GtkDragEnd(GtkW: PGtkWidget;
                  Context: PGdkDragContext;
                      Src: TFileDragSource); cdecl;
begin
  Src.CallOnDragEnd;
end;

procedure GtkRecursiveDisonnect(GtkW: PGtkWidget; Src: TFileDragSource); cdecl;
begin
  //WriteLn('disconnecting: ', gtk_widget_get_name(GtkW));
  gtk_drag_source_unset(GtkW);
  {$note fixme: disconnect the handlers. need to have them stored somewhere}

  // recurse through all child widgets
  if GTK_IS_CONTAINER(GtkW) then
    gtk_container_foreach(PGTKContainer(GtkW), TGtkCallback(@GtkRecursiveDisonnect), Src);
end;

procedure GtkRecursiveConnect(GtkW: PGtkWidget; Src: TFileDragSource); cdecl;
const
  FileDragTarget: TGtkTargetEntry = (target: 'text/uri-list'; flags: 0; info: 0;);
begin
  //WriteLn('connecting: ', gtk_widget_get_name(GtkW));
  gtk_drag_source_set(GtkW, GDK_BUTTON1_MASK, @FileDragTarget, 1, GDK_ACTION_COPY);
  g_signal_connect(GtkW, 'drag-data-get', TGCallback(@GtkDragDataGet), Src);
  g_signal_connect(GtkW, 'drag-begin', TGCallback(@GtkDragBegin), Src);
  g_signal_connect(GtkW, 'drag-end', TGCallback(@GtkDragEnd), Src);

  // recurse through all child widgets
  if GTK_IS_CONTAINER(GtkW) then
    gtk_container_foreach(PGTKContainer(GtkW), TGtkCallback(@GtkRecursiveConnect), Src);
end;

function DragStartsAutomatically: Boolean;
begin
  Result := True;
end;

procedure MakeDragSource(Src: TFileDragSource; Uninstall: Boolean);
var
  GtkW: PGtkWidget;
begin
  GtkW := PGtkWidget(Src.Control.Handle);
  if Uninstall then
    GtkRecursiveDisonnect(GtkW, src)
  else
    GtkRecursiveConnect(GtkW, Src)
end;

end.
