{ GTLK2 drop source for DND of files to other applications

  Copyright (C) 2012 Bernd Kreuss <prof7bit@gmail.com>

  This library is free software; you can redistribute it and/or modify it
  under the terms of the GNU Library General Public License as published
  by the Free Software Foundation; either version 2 of the License, or (at
  your option) any later version with the following modification:

  As a special exception, the copyright holders of this library give you
  permission to link this library with independent modules to produce an
  executable, regardless of the license terms of these independent
  modules,and to copy and distribute the resulting executable under terms
  of your choice, provided that you also meet, for each linked independent
  module, the terms and conditions of the license of that module. An
  independent module is a module which is not derived from or based on
  this library. If you modify this library, you may extend this exception
  to your version of the library, but you are not obligated to do so. If
  you do not wish to do so, delete this exception statement from your
  version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library
  General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

{ Although GTK2 could start the drag automatically
  if we would use gtk_drag_source_set() we don't do
  it because some of the LCL controls are not based
  on native GTK Widgets and would not work. Because
  of this we only connect the signals and start the
  drag manually with gtk_drag_begin().
}
unit DragDropGtk2;

{$mode objfpc}{$H+}

interface
uses
  FileDragSrc;

procedure MakeDragSource(Src: TFileDragSource);
procedure UnmakeDragSource(Src: TFileDragSource);
procedure StartDrag(Src: TFileDragSource); // need this in some cases


implementation
uses
  Classes,
  glib2,
  gtk2,
  gdk2;

const
  FileDragTarget: TGtkTargetEntry = (
    target: 'text/uri-list';
    flags: 0;
    info: 0;
  );

Type
  TDragSignalHandlers = class
    HDragBegin: gulong;
    HDragEnd: gulong;
    HDragDataGet: gulong;
  end;

procedure GtkDragDataGet(GtkW: PGtkWidget;
                      Context: PGdkDragContext;
                      SelData: PGtkSelectionData;
                   TargetType: guint;
                         Time: guint;
                          Src: TFileDragSource); cdecl;
var
  Data: TStringList;
  I: Integer;
  A: array of PChar;
begin
  Data := TStringList.Create;
  Src.CallOnDragGetData(Data);  // ask the application for the file list
  if Data.Count > 0 then begin
    SetLength(A, Data.Count);
    for I := 0 to Data.Count - 1 do begin
      Data.Strings[I] := 'file://' + Data.Strings[I];
      A[i] := PChar(Data.Strings[I]);
    end;
    A[Data.Count] := nil;
    gtk_selection_data_set_uris(SelData, @A[0]);
  end;
  Data.Free;
end;

procedure GtkDragBegin(GtkW: PGtkWidget;
                    Context: PGdkDragContext;
                        Src: TFileDragSource); cdecl;
begin
  Src.CallOnDragBegin;
end;

procedure GtkDragEnd(GtkW: PGtkWidget;
                  Context: PGdkDragContext;
                      Src: TFileDragSource); cdecl;
begin
  Src.CallOnDragEnd;
end;

procedure GtkDisconnectSignals(GtkW: PGtkWidget; Src: TFileDragSource); cdecl;
var
  H: TDragSignalHandlers;
begin
  H := TDragSignalHandlers(Src.InternalData);
  g_signal_handler_disconnect(GtkW, H.HDragDataGet);
  g_signal_handler_disconnect(GtkW, H.HDragBegin);
  g_signal_handler_disconnect(GtkW, H.HDragEnd);
  H.Free;
  Src.InternalData := nil;
end;

procedure GtkConnectSignals(GtkW: PGtkWidget; Src: TFileDragSource); cdecl;
var
  H: TDragSignalHandlers;
begin
  H := TDragSignalHandlers.Create;
  Src.InternalData := H;
  H.HDragDataGet := g_signal_connect(GtkW, 'drag-data-get', TGCallback(@GtkDragDataGet), Src);
  H.HDragBegin := g_signal_connect(GtkW, 'drag-begin', TGCallback(@GtkDragBegin), Src);
  H.HDragEnd := g_signal_connect(GtkW, 'drag-end', TGCallback(@GtkDragEnd), Src);
end;

procedure MakeDragSource(Src: TFileDragSource);
begin
  GtkConnectSignals(PGtkWidget(Src.Control.Handle), Src);
end;

procedure UnmakeDragSource(Src: TFileDragSource);
begin
  GtkDisconnectSignals(PGtkWidget(Src.Control.Handle), src);
end;

procedure StartDrag(Src: TFileDragSource);
var
  GtkW: PGtkWidget;
  TargetList: PGtkTargetList;
begin
  GtkW := PGtkWidget(Src.Control.Handle);
  TargetList := gtk_target_list_new(@FileDragTarget, 1);
  gtk_drag_begin(GtkW, TargetList, GDK_ACTION_COPY, 1, nil);
end;

end.
