unit IpServiceDaemon;

{$mode objfpc}{$H+}

interface

uses
  {$IFDEF UNIX}
    CThreads,
  {$ENDIF}
  Classes, SysUtils, FileUtil, DaemonApp;

type

  { TDaemon1 }

  TDaemon1 = class(TDaemon)
    procedure DataModuleAfterInstall(Sender: TCustomDaemon);
    procedure DataModuleStart(Sender: TCustomDaemon; var OK: Boolean);
    procedure DataModuleStop(Sender: TCustomDaemon; var OK: Boolean);
    procedure DataModuleShutDown(Sender: TCustomDaemon);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Daemon1: TDaemon1;

implementation

uses
  IpServiceCommon,
  IpServiceThread,
  uSimplelogger;

Procedure RegisterDaemon;
begin
  RegisterDaemonClass(TDaemon1)
end;

{ TDaemon1 }

procedure TDaemon1.DataModuleAfterInstall(Sender: TCustomDaemon);
begin
  {$IFDEF LINUX}
  SitaLogger.LogFileName := '/tmp/' + ExtractFileNameWithoutExt(ParamStr(0)) + '.log';
  {$ELSE}
  SitaLogger.LogFileName := ChangeFileExt(ParamStr(0), '.log');
  {$ENDIF}
  SitaLogger.Recycle;
  SitaLogger.Add(0, '===============================================');
  SitaLogger.WriterMode := wmRecycle;
  SitaLogger.Add(0, 'Sita Pocket Service installed');
end;

procedure TDaemon1.DataModuleStart(Sender: TCustomDaemon; var OK: Boolean);
var
  wT: TServiceThread;
begin
  wT := TServiceThread.Create;
  {$IFDEF LINUX}
  SitaLogger.LogFileName := '/tmp/' + ExtractFileNameWithoutExt(ParamStr(0)) + '.log';
  {$ELSE}
  SitaLogger.LogFileName := ChangeFileExt(ParamStr(0), '.log');
  {$ENDIF}
  SitaLogger.WriterMode := wmRecycle;
  SitaLogger.Add(0, 'Sita Pocket Service start');
  wT.Resume
end;

procedure TDaemon1.DataModuleStop(Sender: TCustomDaemon; var OK: Boolean);
begin
  {$IFDEF LINUX}
  SitaLogger.LogFileName := '/tmp/' + ExtractFileNameWithoutExt(ParamStr(0)) + '.log';
  {$ELSE}
  SitaLogger.LogFileName := ChangeFileExt(ParamStr(0), '.log');
  {$ENDIF}
  SitaLogger.WriterMode := wmRecycle;
  SitaLogger.Add(0, 'Sita Pocket Service stop');
end;

procedure TDaemon1.DataModuleShutDown(Sender: TCustomDaemon);
begin
  {$IFDEF LINUX}
  SitaLogger.LogFileName := '/tmp/' + ExtractFileNameWithoutExt(ParamStr(0)) + '.log';
  {$ELSE}
  SitaLogger.LogFileName := ChangeFileExt(ParamStr(0), '.log');
  {$ENDIF}
  SitaLogger.WriterMode := wmRecycle;
  SitaLogger.Add(0, 'Sita Pocket Service shutdown');
end;

{$R *.lfm}


initialization
  RegisterDaemon;
end.

