unit IpServiceThread;

{$mode objfpc}{$H+}

interface

uses
  {$IFDEF UNIX}
    CThreads,
  {$ENDIF}
  Classes,
  SysUtils;

type

  { TServiceThread }

  TServiceThread = class(TThread)
  private
    procedure ThreadTerminate(Sender: TObject);
  protected
    procedure Execute; override;
  public
    constructor Create;
    destructor Destroy; override;
  end;

implementation

uses
  uSimplelogger;

{ TServiceThread }

constructor TServiceThread.Create;
begin
  inherited Create(True);
  OnTerminate := @ThreadTerminate
end;

destructor TServiceThread.Destroy;
begin
  inherited Destroy;
end;

procedure TServiceThread.Execute;
var
  Run: Integer=0;
begin
  while not Terminated do begin
    Sleep(500);
    Inc(Run);
    SitaLogger.Add(0, Format('thread run %d', [Run]));
  end;
  SitaLogger.Add(0, 'Terminate intercepted');
end;

procedure TServiceThread.ThreadTerminate(Sender: TObject);
begin
  SitaLogger.Add(0, 'On terminate intercepted');
end;

end.

