unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls, ExtCtrls, Menus;

type
  TForm1 = class(TForm)
    Button1: TButton;
    CheckGroup1: TCheckGroup;
    Edit1: TEdit;
    MainMenu1: TMainMenu;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
    procedure MenuItem4Click(Sender: TObject);
    function ProcessHelp(Command: Word; Data: PtrInt; var CallHelp: Boolean): Boolean;
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  process;

{$R *.lfm}

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.HelpFile := 'helptest.inf';
  Application.OnHelp := @ProcessHelp;
end;

procedure TForm1.MenuItem3Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.MenuItem4Click(Sender: TObject);
begin
  Application.HelpContext(1);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ShowHelp;
end;

function TForm1.ProcessHelp(Command: Word; Data: PtrInt; var CallHelp: Boolean): Boolean;
var
  p: TProcess;
begin
  // we will process the help ourselves.
  CallHelp := False;
  // create the process to launch DocView help viewer with HelpContext value
  p := TProcess.Create(nil);
  try
    p.Executable := 'docview';
    // path to help file
    p.Parameters.Add(ExtractFilePath(ParamStr(0)) + Application.HelpFile);
    // docview command line parameter to open correct help topic
    if Data > 0 then
      p.Parameters.Add(Format('-n %d', [Data]));
    p.Options := [poNoConsole];
    p.Execute;
  finally
    p.Free;
  end;
end;

end.

