program cpTransl;

{$mode objfpc}{$H+}

uses
  Classes, SysUtils, CustApp, LConv;

type

  { TDTrApplication }

  TDTrApplication = class(TCustomApplication)
  protected
    procedure DoRun; override;
  public
    constructor Create(TheOwner: TComponent); override;
    destructor Destroy; override;
    procedure WriteHelp; virtual;
  end;

{ TDTrApplication }

procedure TDTrApplication.DoRun;
var
  ErrorMsg: String;
  Directory: String;
  SrcEnc: String;
  TgtEnc: String;
  FileList: TStringList;
  fr:TSearchRec;
  s: String;
  i: Integer;
  SL: TStringList;
begin
  // quick check parameters
  ErrorMsg:=CheckOptions('h','help');
  if ErrorMsg<>'' then begin
    ShowException(Exception.Create(ErrorMsg));
    Halt;
  end;
  // parse parameters
  if (ParamCount<2) or HasOption('h','help') then begin
    WriteHelp;
    Halt;
  end;
  if ParamCount>2 then Directory:=ParamStr(1) else Directory:='.';
  SrcEnc:=ParamStr(ParamCount-1);TgtEnc:=ParamStr(ParamCount);
  FileList:=TStringList.Create;
  SetCurrentDir(Directory);
  if FindFirst('*'{$ifdef MSWindows}+'.*'{$endif},faAnyFile,fr)=0 then
  repeat
    s:=LowerCase(ExtractFileExt(fr.name));
    if (s='.pp')or(s='.pas')or(s='.lfm')or(s='.lpr')or(s='.lfm')or(s='.po')or
      (s='.dpr')or(s='.dfm')or(s='.xfm')or(s='.lrt') then FileList.Add(fr.name);
  until FindNext(fr)<>0;
  FindClose(fr);
  for i:=0 to FileList.Count-1 do
  begin
    SL:=TStringList.Create;
    Write('Converting '+FileList[i]+'...');
    SL.LoadFromFile(FileList[i]);
    SL.Text:=CPConvert(SL.Text,SrcEnc,TgtEnc);
    SL.SaveToFile(FileList[i]);
    SL.Free;
    Writeln('done');
  end;
  FileList.Free;
  Terminate;
end;

constructor TDTrApplication.Create(TheOwner: TComponent);
begin
  inherited Create(TheOwner);
  StopOnException:=True;
end;

destructor TDTrApplication.Destroy;
begin
  inherited Destroy;
end;

procedure TDTrApplication.WriteHelp;
begin
  writeln('Usage: ',ExeName,' [-h|DirName] charset-from charset-to');
  writeln('-h               - help');
  writeln('DirName          - the name of a pascal project directory (none means current)');
  writeln('charset-from     - name of source charset');
  writeln('charset-to       - name of target charset');
  Writeln(ExeName,' translates all pascal files in the directory DirName from one charset to another');
end;

var
  Application: TDTrApplication;
begin
  Application:=TDTrApplication.Create(nil);
  Application.Title:='Dir Translator';
  Application.Run;
  Application.Free;
end.

