unit LibSyncMgr;

interface

uses
  ExtCtrls,
  Dialogs,
  DynLibs,
  Classes;

type
  TLibCheckSynchronize = procedure (TimeOut: LongInt = 0);
  TLibSetWakeMainThread = procedure (WakeProc: TNotifyEvent);

  { TLibSyncMgr }

  TLibSyncMgr = class(TComponent)
  private
    FLibHandle: TLibHandle;
    FLibSync: TLibCheckSynchronize;
    FLibWake: TLibSetWakeMainThread;
    FTimer: TTimer;
    procedure SetLibHandle(const AValue: TLibHandle);
    procedure Wake(Sender: TObject);
    procedure DoSync(Sender: TObject);
  public
    constructor Create(AOwner: TComponent); override;
    property LibHandle: TLibHandle read FLibHandle write SetLibHandle;
  end;


implementation

{ TLibSyncMgr }

constructor TLibSyncMgr.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FTimer := TTimer.Create(Self);;
  FTimer.Enabled := False;
  FTimer.Interval := 1;
  FTimer.OnTimer := DoSync;
end;

procedure TLibSyncMgr.SetLibHandle(const AValue: TLibHandle);
begin
  if FLibHandle = AValue then Exit;

  FLibHandle := AValue;
  if Pointer(FLibHandle) = nil then Exit;

  FLibSync := GetProcedureAddress(LibHandle, 'LibCheckSynchronize');
  if not Assigned(FLibSync) then Exit;

  FLibWake := GetProcedureAddress(LibHandle, 'LibSetWakeMainThread');
  if not Assigned(FLibWake) then Exit;

  FLibWake(Wake);
end;

procedure TLibSyncMgr.Wake(Sender: TObject);
begin
  FTimer.Enabled := True;
end;

procedure TLibSyncMgr.DoSync(Sender: TObject);
begin
  FTimer.Enabled := False;
  FLibSync(1000);
end;

end.

