library libthread;

uses
  SysUtils,
  Classes;

type
  TMyThread = class(TThread)
  private
    FMethod: TThreadMethod;
  public
    constructor Create(AMethod: TThreadMethod);
    destructor Destroy; override;
    procedure Execute; override;
  end;

  constructor TMyThread.Create(AMethod: TThreadMethod);
  begin
    inherited Create(True);
    FreeOnTerminate := True;
    
    FMethod := AMethod;
  end;
  
  destructor TMyThread.Destroy;
  begin
    FMethod := nil;
    inherited Destroy;
  end;

  procedure TMyThread.Execute;
  var
    I: integer;
  begin
    for I := 0 to 10 do
    begin
      if Assigned (FMethod) then
      begin
        Synchronize(FMethod);
      end;
    end;
  end;

 // --- //

function CreateMyThread(AMethod: TThreadMethod): TThread;
begin
  Result := TMyThread.Create(AMethod);
end;

exports CreateMyThread;

{$i LibSyncMgr.inc}

begin

end.

