unit TestForm;

interface

uses
  Forms,
  Buttons,
  Dialogs,
  Classes,
  Controls,
  Graphics,
  SysUtils,
  StdCtrls,
  LibSyncMgr,
  LResources;

type
  { TTestLibrary }
  TTestLibrary = class(TForm)
    Memo: TMemo;
    TestBtn: TBitBtn;
    procedure TestBtnClick(Sender: TObject);
  private
    { private declarations }
    MyThread: TThread;
  public
    { public declarations }
    procedure OnSynchronize;
    procedure OnTerminate(Sender: TObject);
  end;

var
  TestLibrary: TTestLibrary;

implementation

uses
  DynLibs;
  
type
  TCreateMyThreadFunc = function(Method: TThreadMethod): TThread;

var
  CreateMyThreadFunc: TCreateMyThreadFunc;
  LibHandle: TLibHandle;

{ TTestLibrary }

procedure TTestLibrary.OnSynchronize;
begin
  ShowMessage('Synchronize call work');
end;

procedure TTestLibrary.OnTerminate(Sender: TObject);
begin
  ShowMessage('OnTerminate event work');
end;

procedure TTestLibrary.TestBtnClick(Sender: TObject);
var
  LibSyncMgr: TLibSyncMgr;
begin
  LibHandle := LoadLibrary('libthread.dll');
  LibSyncMgr := TLibSyncMgr.Create(Self);
  LibSyncMgr.LibHandle := LibHandle;

  CreateMyThreadFunc := GetProcedureAddress(LibHandle, 'CreateMyThread');
  if Assigned(CreateMyThreadFunc) then
  begin
    MyThread := CreateMyThreadFunc(OnSynchronize);
    MyThread.OnTerminate := OnTerminate;
    MyThread.Resume;
  end;
end;

initialization

  {$I testform.lrs}

end.

