unit testform_static;

interface

uses
  Forms,
  Dialogs,
  Classes,
  Buttons,
  Graphics,
  SysUtils,
  Controls,
  Windows,
  LResources;

type
  { TTestLibrary }

  TTestLibrary = class(TForm)
    TestBtn: TSpeedButton;
    procedure TestBtnClick(Sender: TObject);
  private
    { private declarations }
    MyThread: TThread;
  public
    { public declarations }
    procedure OnSynchronize;
    procedure OnTerminate(Sender: TObject);
  end; 

var
  TestLibrary: TTestLibrary;

implementation

function CreateMyThread(Method: TThreadMethod): TThread; external 'libthread.dll';

{ TTestLibrary }

procedure TTestLibrary.OnSynchronize;
begin
  ShowMessage('Synchronize call work');
end;

procedure TTestLibrary.OnTerminate(Sender: TObject);
begin
  ShowMessage('Terminate event work');
end;

procedure TTestLibrary.TestBtnClick(Sender: TObject);
begin
  MyThread := CreateMyThread(OnSynchronize);
  MyThread.OnTerminate:= OnTerminate;
  MyThread.Resume;
end;

initialization

  {$I testform_static.lrs}
  


end.

