/*****************************************************************************/
/*									     */
/*									     */
/*	X patience version 2 -- module BubbleButton.c			     */
/*									     */
/*	A Pushbutton widget with bubblehelp				     */
/*	written by Rick Scott for the Xlt-library			     */
/*	Modified by Karsten Jensen					     */
/*	November-2000							     */
/*	see COPYRIGHT.xpat2 for Copyright details			     */
/*									     */
/*									     */
/*****************************************************************************/

#include <Xm/LabelP.h>
#include <X11/Shell.h>
#include <BubbleButtonP.h>


#define Max(x,y)     (x) > (y) ? (x) : (y)
#define Min(x,y)     (x) < (y) ? (x) : (y)

/*
 * Widget methods, forward declarations
 */

static void class_initialize(void);
static void class_part_initialize(WidgetClass widget_class);
static void initialize(Widget request, Widget new_w, ArgList args,
		       Cardinal * num_args);
static void destroy(Widget w);
static Boolean set_values(Widget old, Widget request, Widget new_w,
			  ArgList args, Cardinal * num_args);
void _XmExportLabelString(Widget w, int offset, XtArgVal * value);

/*
 * Helper functions, forward declarations
 */

/*
 * Widget default resources
 */

#define Offset(field) XtOffsetOf(XltBubbleButtonRec, bubble_button.field)
static XtResource resources[] = {
    {
     XltNbubbleString, XltCBubbleString, XmRXmString,
     sizeof(XmString), Offset(BubbleString),
     XmRImmediate, (XtPointer) NULL}
    ,
    {
     XltNshowBubble, XltCShowBubble, XmRBoolean,
     sizeof(Boolean), Offset(show_bubble),
     XmRImmediate, (XtPointer) True}
    ,
    {
     XltNdelay, XltCDelay, XtRInt,
     sizeof(int), Offset(Delay),
     XtRImmediate, (XtPointer) 1000},
    {
     XltNmouseOverString, XltCMouseOverString, XmRXmString,
     sizeof(XmString), Offset(MouseOverString),
     XtRImmediate, (XtPointer) NULL}
    ,
    {
     XltNmouseOverPixmap, XltCMouseOverPixmap, XmRPrimForegroundPixmap,
     sizeof(Pixmap), Offset(MouseOverPixmap),
     XtRImmediate, (XtPointer) None}
    ,
    {
     XltNbubbleDuration, XltCBubbleDuration, XtRInt,
     sizeof(int), Offset(Duration),
     XtRImmediate, (XtPointer) 0},
    {
     XltNfadeRate, XltCFadeRate, XtRInt,
     sizeof(int), Offset(fade_rate),
     XtRImmediate, (XtPointer) 0},
    {
     XltNbubbleBackground, XltCBubbleBackground, XtRPixel,
     sizeof(Pixel), Offset(bubble_background),
     XtRImmediate, (XtPointer) 0}
    ,
    {
     XltNbubbleForeground, XltCBubbleForeground, XtRPixel,
     sizeof(Pixel), Offset(bubble_foreground),
     XtRImmediate, (XtPointer) 0}
    ,
    {
     XltNbubbleBorderColor, XltCBubbleBorderColor, XtRPixel,
     sizeof(Pixel), Offset(bubble_border_color),
     XtRImmediate, (XtPointer) 0}
    ,
    {
     XltNbubbleBorderWidth, XltCBubbleBorderWidth, XtRDimension,
     sizeof(Dimension), Offset(bubble_border_width),
     XtRImmediate, (XtPointer) 1}
    ,
};

static XmSyntheticResource syn_resources[] = {
    {
     XltNbubbleString,
     sizeof(XmString), Offset(BubbleString),
     _XmExportLabelString, NULL}
};
#undef Offset

/*
 * Widget class record
 */

static void EnterWindow(Widget w, XEvent * event, String * params,
			Cardinal * num_params);
static void LeaveWindow(Widget w, XEvent * event, String * params,
			Cardinal * num_params);

static XtActionsRec actions[] = {
    {"Enter", EnterWindow},
    {"Leave", LeaveWindow},
};

/* *INDENT-OFF* */
XltBubbleButtonClassRec xltBubbleButtonClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmPushButtonClassRec,
        /* class_name            */ "XltBubbleButton",
	/* widget_size           */ sizeof(XltBubbleButtonRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ False,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ XtInheritRealize,
	/* actions               */ actions,
	/* num_actions           */ XtNumber(actions),
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ True,
	/* compress_exposure     */ XtExposeCompressMaximal,
	/* compress_enterleave   */ True,
	/* visible_interest      */ False,
	/* destroy               */ destroy,
	/* resize                */ XtInheritResize,
	/* expose                */ XtInheritExpose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ XtInheritQueryGeometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)NULL
    },
    /* Primitive Class part */
    {
	/* border_highlight      */ XmInheritBorderHighlight,
       	/* border_unhighlight    */ XmInheritBorderUnhighlight,
       	/* translations          */ XtInheritTranslations,
       	/* arm_and_activate_proc */ XmInheritArmAndActivate,
       	/* synthetic resources   */ syn_resources, 
        /* num syn res           */ XtNumber(syn_resources),
	/* extension             */ (XtPointer)NULL
    },
    /* Label Class part */
    {
        /* setOverrideCallback */ XmInheritSetOverrideCallback,
        /* menuProcs           */ XmInheritMenuProc,
        /* translations        */ XtInheritTranslations,
	/* extension           */ NULL
    },
    /* PushButton Class part */
    {
	/* extension */ NULL
    },
    /* BubbleButton Class part */
    {
	/* leave_time  */ 0,
	/* extension   */ NULL
    }
};
/* *INDENT-ON* */



WidgetClass xltBubbleButtonWidgetClass =
    (WidgetClass) & xltBubbleButtonClassRec;

/*
 * Helper routines
 */

/*
 * Widget methods
 */

static void
class_initialize(void)
{
    xltBubbleButtonClassRec.bubble_button_class.leave_time = 0;
}

static void
class_part_initialize(WidgetClass widget_class)
{
}

static void
initialize(Widget request, Widget new_w, ArgList args, Cardinal * num_args)
{
    Widget Shell;
    Pixel bubble_foreground, bubble_background;
    char *bubble_label_name, *bubble_shell_name;

    BubbleButton_Timer(new_w) = (XtIntervalId) NULL;
    BubbleButton_DurationTimer(new_w) = (XtIntervalId) NULL;
    BubbleButton_Swapped(new_w) = False;
    bubble_shell_name =
	XtMalloc(sizeof(char) * (strlen(XtName(new_w)) + 12));
    strcpy(bubble_shell_name, XtName(new_w));
    strcat(bubble_shell_name, "BubbleShell");
    Shell =
	XtCreatePopupShell(bubble_shell_name, overrideShellWidgetClass,
			   new_w, NULL, 0);
    XtFree(bubble_shell_name);
    XtVaSetValues(Shell, XmNoverrideRedirect, True, NULL);
    if (BubbleButton_MouseOverString(new_w) != NULL) {
	BubbleButton_MouseOverString(new_w) =
	    XmStringCopy(BubbleButton_MouseOverString(new_w));
    }
    if (BubbleButton_BubbleString(new_w) == NULL) {
	XmString xmstring;

	xmstring = _XmOSGetLocalizedString((char *) NULL,
					   new_w,
					   XmNlabelString, XtName(new_w));
	BubbleButton_BubbleString(new_w) = xmstring;
    }
    else {
	BubbleButton_BubbleString(new_w) =
	    XmStringCopy(BubbleButton_BubbleString(new_w));
    }
    bubble_label_name =
	XtMalloc(sizeof(char) * (strlen(XtName(new_w)) + 12));
    strcpy(bubble_label_name, XtName(new_w));
    strcat(bubble_label_name, "BubbleLabel");
    BubbleButton_Label(new_w) = XmCreateLabel(Shell,
					      bubble_label_name, NULL, 0);
    XtFree(bubble_label_name);

    XtVaSetValues(BubbleButton_Label(new_w),
		  XmNlabelString, BubbleButton_BubbleString(new_w), NULL);
    XmStringFree(BubbleButton_BubbleString(new_w));
    BubbleButton_BubbleString(new_w) = NULL;
    if (BubbleButton_BubbleForeground(new_w) == 0 &&
	BubbleButton_BubbleBackground(new_w) == 0) {
	bubble_foreground =
	    ((XltBubbleButtonWidget) new_w)->core.background_pixel;
	bubble_background =
	    ((XltBubbleButtonWidget) new_w)->primitive.foreground;
    }
    else if (BubbleButton_BubbleForeground(new_w) != 0 &&
	     BubbleButton_BubbleBackground(new_w) == 0) {
	bubble_foreground = BubbleButton_BubbleForeground(new_w);
	bubble_background =
	    ((XltBubbleButtonWidget) new_w)->core.background_pixel;
    }
    else if (BubbleButton_BubbleForeground(new_w) == 0 &&
	     BubbleButton_BubbleBackground(new_w) != 0) {
	bubble_foreground =
	    ((XltBubbleButtonWidget) new_w)->primitive.foreground;
	bubble_background = BubbleButton_BubbleBackground(new_w);
    }
    else {
	bubble_foreground = BubbleButton_BubbleForeground(new_w);
	bubble_background = BubbleButton_BubbleBackground(new_w);
    }
    if (BubbleButton_BubbleBorderColor(new_w) == 0)
	BubbleButton_BubbleBorderColor(new_w) =
	    BubbleButton_BubbleForeground(new_w);
    XtVaSetValues(BubbleButton_Label(new_w),
		  XmNforeground, bubble_foreground,
		  XmNbackground, bubble_background,
		  NULL);
    XtVaSetValues(Shell,
		  XmNborderWidth, BubbleButton_BubbleBorderWidth(new_w),
		  XmNborderColor, BubbleButton_BubbleBorderColor(new_w),
		  NULL);
    XtManageChild(BubbleButton_Label(new_w));
}

static void
destroy(Widget w)
{
    if (BubbleButton_MouseOverString(w)) {
	XmStringFree(BubbleButton_MouseOverString(w));
    }
    if (BubbleButton_Timer(w)) {
	XtRemoveTimeOut(BubbleButton_Timer(w));
    }
    if (BubbleButton_DurationTimer(w)) {
	XtRemoveTimeOut(BubbleButton_DurationTimer(w));
    }
}

static Boolean
set_values(Widget old, Widget request, Widget new_w, ArgList args,
	   Cardinal * num_args)
{
    if (BubbleButton_MouseOverString(new_w) !=
	BubbleButton_MouseOverString(old)) {
	XmStringFree(BubbleButton_MouseOverString(old));
	BubbleButton_MouseOverString(new_w) =
	    XmStringCopy(BubbleButton_MouseOverString(new_w));
    }
    if (XtIsSensitive(old) != XtIsSensitive(new_w)) {
	if (!XtIsSensitive(new_w)) {
	    Cardinal num_params = 0;

	    LeaveWindow(new_w, NULL, NULL, &num_params);
	}
    }
    return (False);
}

void
_XmExportLabelString(Widget w, int offset, XtArgVal * value)
{
    XmString str;
    XmString ret;

    str = *(XmString *) (((char *) w) + offset);
    if (str) {
	if (XmIsLabel(w)) {
	    ret = XmStringCopy(str);
	}
	else {
	    ret = NULL;
	}
    }
    else {
	ret = NULL;
    }

    *value = (XtArgVal) ret;
}

static void
FadeOut(XtPointer closure, XtIntervalId *id)
{
    Widget w = (Widget) closure;
    Dimension height, shell_height =
	XtHeight(XtParent(BubbleButton_Label(w)));

    if (XtHeight(XtParent(BubbleButton_Label(w))) > 1)
	height = Max(shell_height * 90 / 100, 1);
    else
	height = 1;
    if (height > 1) {
	XtVaSetValues(XtParent(BubbleButton_Label(w)),
		      XmNheight, height, NULL);
	BubbleButton_DurationTimer(w) =
	    XtAppAddTimeOut(XtWidgetToApplicationContext(w),
			    BubbleButton_FadeRate(w),
			    FadeOut, w);
    }
    else {
	BubbleButton_DurationTimer(w) = (XtIntervalId) NULL;
	XtPopdown(XtParent(BubbleButton_Label(w)));
    }
}

static void
UnpostIt(XtPointer closure, XtIntervalId *id)
{
    Widget w = (Widget) closure;
    BubbleButton_DurationTimer(w) = (XtIntervalId) NULL;
    XtPopdown(XtParent(BubbleButton_Label(w)));
    /*
     * BubbleButton_DurationTimer(w) =
     * XtAppAddTimeOut(XtWidgetToApplicationContext(w),
     * 0,
     * FadeOut, 
     * w);
     */
}

static void
FadeIn(XtPointer closure, XtIntervalId *id)
{
    Widget w = (Widget) closure;
    XtWidgetGeometry geo;
    Dimension height, label_height, shell_height;

    XtQueryGeometry(BubbleButton_Label(w), NULL, &geo);
    label_height = geo.height + 2 * geo.border_width;
    shell_height = XtHeight(XtParent(BubbleButton_Label(w)));
    if (shell_height < label_height)
	height = Min(shell_height * 110 / 100 + 1, label_height);
    else
	height = label_height;
    if (height == label_height) {
	BubbleButton_DurationTimer(w) = (XtIntervalId) NULL;
	if (BubbleButton_Duration(w) > 0) {
	    BubbleButton_DurationTimer(w) =
		XtAppAddTimeOut(XtWidgetToApplicationContext(w),
				BubbleButton_Duration(w),
				UnpostIt, w);
	}
    }
    else {
	XtVaSetValues(XtParent(BubbleButton_Label(w)),
		      XmNheight, height, NULL);
	BubbleButton_DurationTimer(w) =
	    XtAppAddTimeOut(XtWidgetToApplicationContext(w),
			    BubbleButton_FadeRate(w),
			    FadeIn, w);
    }
}

static void
PostIt(XtPointer closure, XtIntervalId *id)
{
    Widget w = (Widget) closure;
    int rx, ry, x, y;
    unsigned int key;
    Window root, child;
    XtWidgetGeometry geo;

    XtRemoveTimeOut(BubbleButton_Timer(w));
    BubbleButton_Timer(w) = (XtIntervalId) NULL;
    XQueryPointer(XtDisplay(w),
		  XtWindow(w), &root, &child, &rx, &ry, &x, &y, &key);
    XtQueryGeometry(BubbleButton_Label(w), NULL, &geo);
    XtVaSetValues(XtParent(BubbleButton_Label(w)),
		  XmNx, rx - x + XtWidth(w) / 2,
		  XmNy, ry - y + XtHeight(w),
		  /*
		   * XmNheight, 1,
		   * XmNwidth, geo.width + 2 * geo.border_width,
		   */
		  NULL);

#if 1
    XtPopup(XtParent(BubbleButton_Label(w)), XtGrabNone);
    /*
     * if (BubbleButton_DurationTimer(w) != (XtIntervalId)NULL)
     * {
     * XtRemoveTimeOut(BubbleButton_DurationTimer(w));
     * BubbleButton_DurationTimer(w) = (XtIntervalId)NULL;
     * }
     * BubbleButton_DurationTimer(w) = XtAppAddTimeOut(XtWidgetToApplicationContext(w),
     * 0,
     * FadeIn, 
     * w);
     */
#else
    XtPopup(XtParent(BubbleButton_Label(w)), XtGrabNone);
    if (BubbleButton_DurationTimer(w) != (XtIntervalId) NULL) {
	XtRemoveTimeOut(BubbleButton_DurationTimer(w));
	BubbleButton_DurationTimer(w) = (XtIntervalId) NULL;
    }
    if (BubbleButton_Duration(w) > 0) {
	BubbleButton_DurationTimer(w) =
	    XtAppAddTimeOut(XtWidgetToApplicationContext(w),
			    BubbleButton_Duration(w),
			    UnpostIt, w);
    }
#endif
}

static void
SwapLabels(Widget w)
{
    XmString tmp = NULL;

    if (BubbleButton_MouseOverString(w)) {
	XtVaGetValues(w, XmNlabelString, &tmp, NULL);
	XtVaSetValues(w,
		      XmNlabelString, BubbleButton_MouseOverString(w),
		      NULL);
	XmStringFree(BubbleButton_MouseOverString(w));
	BubbleButton_MouseOverString(w) = tmp;
    }
}

static void
SwapPixmaps(Widget w)
{
    Pixmap tmp;

    if (BubbleButton_MouseOverPixmap(w)) {
	XtVaGetValues(w, XmNlabelPixmap, &tmp, NULL);
	XtVaSetValues(w,
		      XmNlabelPixmap, BubbleButton_MouseOverPixmap(w),
		      NULL);
	BubbleButton_MouseOverPixmap(w) = tmp;
    }
}

static void
Swap(Widget w)
{
    if (Lab_IsText(w)) {
	SwapLabels(w);
    }
    else {
	SwapPixmaps(w);
    }
    BubbleButton_Swapped(w) = BubbleButton_Swapped(w) ? False : True;
}

static void
EnterWindow(Widget w, XEvent * event, String * params,
	    Cardinal * num_params)
{
    if (BubbleButton_ShowBubble(w) && !BubbleButton_Timer(w)) {
	unsigned long delay;

	if (event
	    && (event->xcrossing.time - BubbleButtonClass_LeaveTime(w) <
		BubbleButton_Delay(w))) {
	    delay = 0;
	}
	else {
	    delay = BubbleButton_Delay(w);
	}
	BubbleButton_Timer(w) =
	    XtAppAddTimeOut(XtWidgetToApplicationContext(w),
			    delay, PostIt, w);
    }
    if (!BubbleButton_Swapped(w)) {
	Swap(w);
    }
}

static void
LeaveWindow(Widget w, XEvent * event, String * params,
	    Cardinal * num_params)
{
    if (BubbleButton_Timer(w)) {
	XtRemoveTimeOut(BubbleButton_Timer(w));
	BubbleButton_Timer(w) = (XtIntervalId) NULL;
    }
    else {
	XtPopdown(XtParent(BubbleButton_Label(w)));
	if (event) {
	    if (BubbleButton_DurationTimer(w)
		|| BubbleButton_Duration(w) == 0) {
		BubbleButtonClass_LeaveTime(w) = event->xcrossing.time;
	    }
	}
    }
    if (BubbleButton_DurationTimer(w)) {
	XtRemoveTimeOut(BubbleButton_DurationTimer(w));
	BubbleButton_DurationTimer(w) = (XtIntervalId) NULL;
    }
    if (BubbleButton_Swapped(w)) {
	Swap(w);
    }
}

/*
 * Public functions
 */

Widget
XltCreateBubbleButton(Widget parent,
		      char *name, Arg * arglist, Cardinal argCount)
{
    return XtCreateWidget(name, xltBubbleButtonWidgetClass, parent,
			  arglist, argCount);
}
