#ifndef _BUBBLEBUTTONP_H
#define _BUBBLEBUTTONP_H

#include <BubbleButton.h>
#include <Xm/PushBP.h>

typedef struct {
    XtIntervalId Timer;
    int Delay;
    Widget BubbleLabel;
    XmString BubbleString;
    Boolean show_bubble;
    XmString MouseOverString;
    Pixmap MouseOverPixmap;
    XtIntervalId DurationTimer;
    int Duration;
    Boolean Swapped;
    int fade_rate;
    Pixel bubble_foreground;
    Pixel bubble_background;
    Pixel bubble_border_color;
    Dimension bubble_border_width;
} XltBubbleButtonPart;

#define BubbleButton_Timer(w) (((XltBubbleButtonWidget)w)->bubble_button.Timer)
#define BubbleButton_Delay(w) (((XltBubbleButtonWidget)w)->bubble_button.Delay)
#define BubbleButton_Label(w) (((XltBubbleButtonWidget)w)->bubble_button.BubbleLabel)
#define BubbleButton_BubbleString(w) (((XltBubbleButtonWidget)w)->bubble_button.BubbleString)
#define BubbleButton_ShowBubble(w) (((XltBubbleButtonWidget)w)->bubble_button.show_bubble)
#define BubbleButton_MouseOverString(w) (((XltBubbleButtonWidget)w)->bubble_button.MouseOverString)
#define BubbleButton_MouseOverPixmap(w) (((XltBubbleButtonWidget)w)->bubble_button.MouseOverPixmap)
#define BubbleButton_DurationTimer(w) (((XltBubbleButtonWidget)w)->bubble_button.DurationTimer)
#define BubbleButton_Duration(w) (((XltBubbleButtonWidget)w)->bubble_button.Duration)
#define BubbleButton_Swapped(w) (((XltBubbleButtonWidget)w)->bubble_button.Swapped)
#define BubbleButton_FadeRate(w) (((XltBubbleButtonWidget)w)->bubble_button.fade_rate)
#define BubbleButton_BubbleForeground(w) (((XltBubbleButtonWidget)w)->bubble_button.bubble_foreground)
#define BubbleButton_BubbleBackground(w) (((XltBubbleButtonWidget)w)->bubble_button.bubble_background)
#define BubbleButton_BubbleBorderColor(w) (((XltBubbleButtonWidget)w)->bubble_button.bubble_border_color)
#define BubbleButton_BubbleBorderWidth(w) (((XltBubbleButtonWidget)w)->bubble_button.bubble_border_width)

#define BubbleButtonClass_LeaveTime(w) (((XltBubbleButtonWidgetClass)XtClass(w))->bubble_button_class.leave_time)

typedef struct _XltBubbleButtonRec {
	CorePart core;
	XmPrimitivePart primitive;
	XmLabelPart label;
	XmPushButtonPart pushbutton;
	XltBubbleButtonPart bubble_button;
} XltBubbleButtonRec;

typedef struct {
	Time leave_time;
	XtPointer extension;
} XltBubbleButtonClassPart;

typedef struct _XltBubbleButtonClassRec {
	CoreClassPart core_class;
	XmPrimitiveClassPart primitive_class;
	XmLabelClassPart label_class;
	XmPushButtonClassPart pushbutton_class;
	XltBubbleButtonClassPart bubble_button_class;
} XltBubbleButtonClassRec;

extern XltBubbleButtonClassRec xltBubbleButtonClassRec;
#endif
