#include <microhttpd.h>
#include <memory.h>

#define PAGE "<html><body>Hello world</body></html>"

static struct MHD_Response *response;

static int ahc_echo(void *cls, struct MHD_Connection *cnc, const char *url, const char *method, const char *version,
                    const char *upload_data, size_t *upload_data_size, void **ptr) {
    return MHD_queue_response(cnc, MHD_HTTP_OK, response);
}

int main() {
    struct MHD_Daemon *d;
    response = MHD_create_response_from_buffer(strlen(PAGE), (void *) PAGE, MHD_RESPMEM_PERSISTENT);
    d = MHD_start_daemon(MHD_USE_EPOLL_INTERNALLY | MHD_SUPPRESS_DATE_NO_CLOCK | MHD_USE_EPOLL_TURBO,
                         8080, NULL, NULL, &ahc_echo, NULL,
                         MHD_OPTION_CONNECTION_TIMEOUT, (unsigned int) 120,
                         MHD_OPTION_THREAD_POOL_SIZE, (unsigned int) sysconf(_SC_NPROCESSORS_ONLN),
                         MHD_OPTION_CONNECTION_LIMIT, (unsigned int) 1000,
                         MHD_OPTION_END);
    while (1)
        sleep(1);
    MHD_stop_daemon(d);
    MHD_destroy_response(response);
    return 0;
}
