#include "myheader.h"

int main(int argc, char *argv[]) {
  int status = 0;
  char (*func)();
  void *mydata, *temp;
  char symbol[20];
  char buffer[2048];
  char message[30] = "This is the main program.\n";

  static char mylib[]="libmylib.so";

  printf("message is \"%s\"\n",message);

  printf("Opening the library %s\n",mylib);

  mydata = dlopen(mylib, RTLD_LAZY);

  printf("Opened the library %s\n",mylib);
  printf("dlopen() returned %x\n",mydata);

  printf("dlerror() returns %s\n%d\n",dlerror(),errno);
  if (errno) {
    switch(errno) {
    case EACCES:
      printf("Indicates the file is not an ordinary file, or the mode of the program\nfile denies execution permission, or search permission is denied on a component\nof the path prefix.\n");
      break;
    case EINVAL:
      printf("Indicates the file or archive member has a valid magic number in its\nheader, but the header is damaged or is incorrect for the machine on which the\nfile is to be run.\n");
      break;
    case ELOOP:
      printf("Indicates too many symbolic links were encountered in translating the path\nname.\n");
      break;
    case ENOEXEC:
      printf("Indicates an error occurred when loading or resolving symbols for the\nspecified module. This can be due to an attempt to load a module with an invalid\nXCOFF header, a failure to resolve symbols that were not defined as deferred\nimports or several other load time related problems. The loadquery subroutine\ncan be used to return more information about the load failure. If the main\nprogram was linked on a 4.2 or later system, and if runtime linking is used, the\nload subroutine will fail if the runtime linker could not resolve some symbols.\nIn this case, errno will be set to ENOEXEC , but the loadquery subroutine will\nnot return any additional information.\n");
      break;
    case ENOMEM:
      printf("Indicates the program requires more memory than is allowed by the\nsystem-imposed maximum.\n");
      break;
    case ETXTBSY:
      printf("Indicates the file is currently open for writing by some process.\n");
      break;
    case ENAMETOOLONG:
      printf("Indicates a component of a path name exceeded 255 characters, or an\nentire path name exceeded 1023 characters.\n");
      break;
    case ENOENT:
      printf("Indicates a component of the path prefix does not exist, or the path name\nis a null value.\n");
      break;
    case ENOTDIR:
      printf("Indicates a component of the path prefix is not a directory.\n");
      break;
    case ESTALE:
      printf("Indicates the process root or current directory is located in a virtual\nfile system that has been unmounted.\n");
      break;
    default:
      printf("errno is %d\n",errno);
    }
    //    loadquery(L_GETINFO|L_GETMESSAGES, buffer, 2048);
    printf("loadquery returns:\n%s\n",buffer);
  }
  strcpy(symbol,"getpoint");

  printf("Getting symbol %s from %s\n",symbol,mylib);

  temp = dlsym(mydata,symbol);
  func = (char(*)())temp;

  printf("dlsym() returned %d\n",temp);
  if (errno) {
    switch(errno) {
    case EACCES:
      printf("Indicates the file is not an ordinary file, or the mode of the program\nfile denies execution permission, or search permission is denied on a component\nof the path prefix.\n");
      break;
    case EINVAL:
      printf("Indicates the file or archive member has a valid magic number in its\nheader, but the header is damaged or is incorrect for the machine on which the\nfile is to be run.\n");
      break;
    case ELOOP:
      printf("Indicates too many symbolic links were encountered in translating the path\nname.\n");
      break;
    case ENOEXEC:
      printf("Indicates an error occurred when loading or resolving symbols for the\nspecified module. This can be due to an attempt to load a module with an invalid\nXCOFF header, a failure to resolve symbols that were not defined as deferred\nimports or several other load time related problems. The loadquery subroutine\ncan be used to return more information about the load failure. If the main\nprogram was linked on a 4.2 or later system, and if runtime linking is used, the\nload subroutine will fail if the runtime linker could not resolve some symbols.\nIn this case, errno will be set to ENOEXEC , but the loadquery subroutine will\nnot return any additional information.\n");
      break;
    case ENOMEM:
      printf("Indicates the program requires more memory than is allowed by the\nsystem-imposed maximum.\n");
      break;
    case ETXTBSY:
      printf("Indicates the file is currently open for writing by some process.\n");
      break;
    case ENAMETOOLONG:
      printf("Indicates a component of a path name exceeded 255 characters, or an\nentire path name exceeded 1023 characters.\n");
      break;
    case ENOENT:
      printf("Indicates a component of the path prefix does not exist, or the path name\nis a null value.\n");
      break;
    case ENOTDIR:
      printf("Indicates a component of the path prefix is not a directory.\n");
      break;
    case ESTALE:
      printf("Indicates the process root or current directory is located in a virtual\nfile system that has been unmounted.\n");
      break;
    default:
      printf("errno is %d\n",errno);
    }
    //    loadquery(L_GETINFO|L_GETMESSAGES, buffer, 2048);
    printf("loadquery returns:\n%s\n",buffer);
  }

  printf("message is \"%s\"\n", (*func)() );

  return(0);
}
